/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.bundle;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.jboss.tools.common.el.core.model.ELArgumentInvocation;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.model.ELPropertyInvocation;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.bundle.BundleMapListener;
import org.jboss.tools.jst.web.ui.internal.editor.i18n.MainLocaleProvider;

public class BundleMap {
    public static final String TITLE_ATTRIBUTE_NAME = "title";
    private static final String[] JSF_PROJECT_NATURES = new String[]{"org.jboss.tools.jsf.jsfnature"};
    private BundleMapListener[] bundleMapListeners = new BundleMapListener[0];
    private String[] javaSources;
    private Locale locale;
    private BundleEntry[] bundles = new BundleEntry[0];
    private Map<String, UsedKey> usedKeys = new HashMap<String, UsedKey>();
    boolean showBundleUsageAsEL = WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Show Resource Bundles Usage as EL Expressions");
    XModelTreeListener modelListener = new ML();
    private IProject project;

    public void init(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            this.project = ((IFileEditorInput)input).getFile().getProject();
        }
        this.init(this.project);
    }

    public void init(IProject project) {
        if (project != null) {
            this.javaSources = BundleMap.getJavaProjectSrcLocations(project);
        }
        this.locale = MainLocaleProvider.getInstance().getLocale(project);
        this.refreshRegisteredBundles();
        PreferenceModelUtilities.getPreferenceModel().addModelTreeListener(this.modelListener);
    }

    public void refreshRegisteredBundles() {
        block6: {
            IModelNature modelNature;
            if (!this.hasJsfProjectNatureType() || this.project == null || (modelNature = EclipseResourceUtil.getModelNature((IProject)this.project)) == null) break block6;
            XModel model = modelNature.getModel();
            List l = WebPromptingProvider.getInstance().getList(model, "jsf.registered.bundles", null, null);
            if (l != null && l.size() > 1 && l.get(1) instanceof Map) {
                Map map = (Map)l.get(1);
                if (map.keySet().size() > 0) {
                    Iterator it = map.keySet().iterator();
                    while (it.hasNext()) {
                        String uri = it.next().toString();
                        String prefix = map.get(uri).toString();
                        int hash = (String.valueOf(prefix) + ":" + uri).hashCode();
                        this.removeBundle(hash);
                        this.addBundle(hash, prefix, uri, true);
                    }
                } else if (this.bundles.length > 0) {
                    int i = 0;
                    while (i < this.bundles.length) {
                        String uri = this.bundles[i].uri;
                        String prefix = this.bundles[i].prefix;
                        int hash = (String.valueOf(prefix) + ":" + uri).hashCode();
                        this.removeBundle(hash);
                        this.addBundle(hash, prefix, uri, true);
                        ++i;
                    }
                }
            }
        }
    }

    public void clearAll() {
        this.bundles = new BundleEntry[0];
        this.usedKeys = new HashMap<String, UsedKey>();
    }

    public void dispose() {
        PreferenceModelUtilities.getPreferenceModel().removeModelTreeListener(this.modelListener);
    }

    public boolean isShowBundleUsageAsEL() {
        return this.showBundleUsageAsEL;
    }

    private boolean hasJsfProjectNatureType() {
        boolean hasJsfProjectNatureType;
        block4: {
            hasJsfProjectNatureType = false;
            try {
                if (this.project == null || !this.project.exists() || !this.project.isOpen()) break block4;
                int i = 0;
                while (i < JSF_PROJECT_NATURES.length) {
                    if (this.project.hasNature(JSF_PROJECT_NATURES[i])) {
                        hasJsfProjectNatureType = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                WebUiPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return hasJsfProjectNatureType;
    }

    public boolean openBundle(String expression, String locale) {
        List<ELInstance> is = this.parseJSFExpression(expression);
        if (is == null || is.size() == 0) {
            return false;
        }
        String prefix = null;
        String propertyName = null;
        for (ELInstance i : is) {
            String[] values;
            List invs;
            ELExpression expr = i.getExpression();
            if (expr == null || (invs = expr.getInvocations()).size() <= 0 || (values = this.getCall((ELInvocationExpression)invs.get(0))) == null) continue;
            prefix = values[0];
            propertyName = values[1];
            break;
        }
        if (prefix == null) {
            return false;
        }
        BundleEntry entry = this.getBundle(prefix);
        if (entry == null) {
            if (this.hasJsfProjectNatureType() && this.project != null) {
                XModel model = EclipseResourceUtil.getModelNature((IProject)this.project).getModel();
                String prefix2 = prefix;
                if (propertyName != null && prefix != null) {
                    prefix2 = String.valueOf(prefix) + "." + propertyName;
                }
                WebPromptingProvider.getInstance().getList(model, "jsf.bean.open", prefix2, null);
            }
            return false;
        }
        if (this.hasJsfProjectNatureType()) {
            Properties p = new Properties();
            p.put("bundle", entry.uri);
            p.put("key", propertyName);
            if (locale != null) {
                p.put("locale", locale);
            }
            p.put("file", this.project);
            String error = null;
            if (this.project != null) {
                XModel model = EclipseResourceUtil.getModelNature((IProject)this.project).getModel();
                WebPromptingProvider.getInstance().getList(model, "jsf.open.key", entry.uri, p);
                error = p.getProperty("error");
            }
            return error == null || error.length() == 0;
        }
        return false;
    }

    public IFile getBundleFile(String uri) {
        block6: {
            if (this.project == null || !this.project.isOpen()) {
                return null;
            }
            if (this.project.hasNature("org.eclipse.jdt.core.javanature")) break block6;
            return null;
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                IFile file;
                if (es[i].getEntryKind() == 3 && (file = (IFile)this.project.getWorkspace().getRoot().getFolder(es[i].getPath()).findMember("/" + this.getBundleFileName(uri))) != null && file.exists()) {
                    return file;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
            return null;
        }
        return null;
    }

    private String getBundleFileName(String uri) {
        String resultUri = uri.replace('.', '/');
        ResourceBundle bundle = this.getBundleByUrl(uri, this.locale);
        String localeString = bundle.getLocale().toString();
        if (localeString != null && localeString.length() > 0) {
            String[] parts = localeString.split("_");
            if (parts.length == 2) {
                parts[1] = parts[1].toUpperCase();
            }
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                resultUri = String.valueOf(resultUri) + "_" + part;
                ++n2;
            }
        }
        resultUri = String.valueOf(resultUri) + ".properties";
        return resultUri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResourceBundle getBundleByUrl(String uri, Locale locale) {
        try {
            if (this.javaSources == null) return null;
            URL[] urls = new URL[this.javaSources.length];
            int i = 0;
            while (true) {
                if (i >= this.javaSources.length) {
                    URLClassLoader classLoader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
                    return ResourceBundle.getBundle(uri, locale, classLoader);
                }
                try {
                    File file = new File(this.javaSources[i]).getCanonicalFile();
                    urls[i] = file.toURL();
                }
                catch (IOException ioe) {
                    WebUiPlugin.getDefault().logError(ioe);
                    return null;
                }
                ++i;
            }
        }
        catch (MissingResourceException missingResourceException) {}
        return null;
    }

    private static String[] getJavaProjectSrcLocations(IProject project) {
        return EclipseResourceUtil.getJavaProjectSrcLocations((IProject)project);
    }

    private void removeBundle(int hashCode, boolean refresh) {
        if (this.bundles.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.bundles.length) {
            if (hashCode == this.bundles[i].hashCode) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.bundles.length == 1) {
            this.bundles = new BundleEntry[0];
            return;
        }
        BundleEntry[] newBundles = new BundleEntry[this.bundles.length - 1];
        System.arraycopy(this.bundles, 0, newBundles, 0, index);
        System.arraycopy(this.bundles, index + 1, newBundles, index, this.bundles.length - index - 1);
        this.bundles = newBundles;
        if (refresh) {
            this.refreshUsedKeys();
        }
    }

    public void removeBundle(int hashCode) {
        this.removeBundle(hashCode, true);
    }

    public void addBundle(int hashCode, String prefix, String uri, boolean refresh) {
        ResourceBundle bundle = this.getBundleByUrl(uri, this.locale);
        BundleEntry entry = new BundleEntry(bundle, uri, prefix, hashCode);
        if (bundle != null) {
            BundleEntry[] newBundles = new BundleEntry[this.bundles.length + 1];
            System.arraycopy(this.bundles, 0, newBundles, 0, this.bundles.length);
            this.bundles = newBundles;
            this.bundles[this.bundles.length - 1] = entry;
        }
        if (refresh) {
            this.refreshUsedKeys();
        }
    }

    public void changeBundle(int hashCode, String prefix, String uri) {
        this.removeBundle(hashCode, false);
        this.addBundle(hashCode, prefix, uri, true);
    }

    private void changeBundleWithoutRefresh(int hashCode, String prefix, String uri) {
        this.removeBundle(hashCode, false);
        this.addBundle(hashCode, prefix, uri, false);
    }

    private BundleEntry getBundle(String prefix) {
        if (prefix == null) {
            return null;
        }
        BundleEntry lastBundle = null;
        int i = 0;
        while (i < this.bundles.length) {
            if (prefix.equals(this.bundles[i].prefix)) {
                lastBundle = this.bundles[i];
            }
            ++i;
        }
        return lastBundle;
    }

    public void refresh() {
        this.refreshRegisteredBundles();
        if (this.project != null) {
            this.javaSources = BundleMap.getJavaProjectSrcLocations(this.project);
            UsedKey[] array = new UsedKey[]{};
            array = this.usedKeys.values().toArray(array);
            int i = 0;
            while (i < array.length) {
                UsedKey key = array[i];
                this.changeBundleWithoutRefresh(key.hashCode, key.prefix, key.uri);
                ++i;
            }
            this.refreshUsedKeys();
        }
    }

    private void refreshUsedKeys() {
        ArrayList<String> keysToBeRemoved = new ArrayList<String>(0);
        Set<String> usedKeysSet = this.usedKeys.keySet();
        for (String key : usedKeysSet) {
            UsedKey keyValue = this.usedKeys.get(key);
            BundleEntry entry = this.getBundle(keyValue.prefix);
            if (entry != null) {
                String value;
                try {
                    value = (String)entry.bundle.getObject(keyValue.key);
                }
                catch (MissingResourceException missingResourceException) {
                    value = null;
                    this.fireBundleKeyChanged(keyValue.prefix, keyValue.key, value);
                    keysToBeRemoved.add(key);
                    continue;
                }
                if (value == null && keyValue.value != null || value != null && keyValue.value == null) {
                    keyValue.value = value;
                    this.fireBundleKeyChanged(keyValue.prefix, keyValue.key, value);
                    continue;
                }
                if (value == null || keyValue.value == null || value.equals(keyValue.value)) continue;
                keyValue.value = value;
                this.fireBundleKeyChanged(keyValue.prefix, keyValue.key, value);
                continue;
            }
            keyValue.value = null;
            this.fireBundleKeyChanged(keyValue.prefix, keyValue.key, null);
        }
        for (String key : keysToBeRemoved) {
            this.usedKeys.remove(key);
        }
    }

    private List<ELInstance> parseJSFExpression(String expression) {
        ELParser parser = ELParserUtil.getDefaultFactory().createParser();
        ELModel model = parser.parse(expression);
        List is = model.getInstances();
        return is;
    }

    public String getBundleValue(String name) {
        List<ELInstance> is;
        String bundleValue = name;
        if (!this.showBundleUsageAsEL && (is = this.parseJSFExpression(name)) != null) {
            StringBuffer sb = new StringBuffer();
            int index = 0;
            boolean parsingErrors = false;
            for (ELInstance i : is) {
                String value;
                ELInvocationExpression expr;
                String[] values;
                if (!i.getErrors().isEmpty()) {
                    parsingErrors = true;
                    break;
                }
                int start = i.getStartPosition();
                sb.append(name.substring(index, start));
                index = start;
                if (i.getExpression() instanceof ELInvocationExpression && (values = this.getCall(expr = (ELInvocationExpression)i.getExpression())) != null && (value = this.getBundleValue(values[0], values[1])) != null) {
                    sb.append(value);
                    index = i.getEndPosition();
                }
                if (index >= i.getEndPosition()) continue;
                if (name.length() > i.getEndPosition()) {
                    sb.append(name.substring(index, i.getEndPosition()));
                    index = i.getEndPosition();
                    continue;
                }
                sb.append(name.substring(index, name.length()));
                index = name.length();
            }
            if (!parsingErrors) {
                bundleValue = sb.append(name.substring(index)).toString();
            }
        }
        return bundleValue;
    }

    String[] getCall(ELInvocationExpression expr) {
        if (expr == null) {
            return null;
        }
        ELInvocationExpression left = expr.getLeft();
        if (left == null) {
            return null;
        }
        String name = expr.getMemberName();
        if (name == null || name.length() == 0) {
            return null;
        }
        if (expr instanceof ELPropertyInvocation) {
            return new String[]{left.getText(), name};
        }
        if (expr instanceof ELArgumentInvocation) {
            if (!name.startsWith("\"") && !name.startsWith("'")) {
                return null;
            }
            name = name.substring(1);
            if (!name.endsWith("\"") && !name.endsWith("'")) {
                return null;
            }
            name = name.substring(0, name.length() - 1);
            if (name.length() == 0) {
                return null;
            }
            return new String[]{left.getText(), name};
        }
        return null;
    }

    private String getBundleValue(String prefix, String propertyName) {
        String bundleValue = null;
        BundleEntry entry = this.getBundle(prefix);
        if (entry != null) {
            String name = String.valueOf(prefix) + "." + propertyName;
            try {
                bundleValue = (String)entry.bundle.getObject(propertyName);
                if (!this.usedKeys.containsKey(name)) {
                    this.usedKeys.put(name, new UsedKey(entry.uri, prefix, propertyName, bundleValue, entry.hashCode));
                }
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return bundleValue;
    }

    public void addBundleMapListener(BundleMapListener listener) {
        if (listener != null) {
            BundleMapListener[] newBundleMapListener = new BundleMapListener[this.bundleMapListeners.length + 1];
            System.arraycopy(this.bundleMapListeners, 0, newBundleMapListener, 0, this.bundleMapListeners.length);
            this.bundleMapListeners = newBundleMapListener;
            this.bundleMapListeners[this.bundleMapListeners.length - 1] = listener;
        }
    }

    public void removeBundleMapListener(BundleMapListener listener) {
        if (listener == null || this.bundleMapListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.bundleMapListeners.length) {
            if (listener == this.bundleMapListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.bundleMapListeners.length == 1) {
            this.bundleMapListeners = new BundleMapListener[0];
            return;
        }
        BundleMapListener[] newBundleMapListener = new BundleMapListener[this.bundleMapListeners.length - 1];
        System.arraycopy(this.bundleMapListeners, 0, newBundleMapListener, 0, index);
        System.arraycopy(this.bundleMapListeners, index + 1, newBundleMapListener, index, this.bundleMapListeners.length - index - 1);
        this.bundleMapListeners = newBundleMapListener;
    }

    private void fireBundleKeyChanged(String prefix, String key, String value) {
        int i = 0;
        while (i < this.bundleMapListeners.length) {
            this.bundleMapListeners[i].bundleKeyChanged(prefix, key, value);
            ++i;
        }
    }

    public void updateShowBundleUsageAsEL(boolean showBundlesAsEL) {
        if (this.showBundleUsageAsEL != showBundlesAsEL) {
            this.showBundleUsageAsEL = showBundlesAsEL;
            this.refresh();
        }
    }

    public void updateShowBundleUsageAsEL() {
        this.updateShowBundleUsageAsEL(WebUiPlugin.getDefault().getPreferenceStore().getBoolean("Show Resource Bundles Usage as EL Expressions"));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setShowBundleUsageAsEL(boolean showBundleUsageAsEL) {
        this.showBundleUsageAsEL = showBundleUsageAsEL;
    }

    public BundleEntry[] getBundles() {
        return this.bundles;
    }

    public static class BundleEntry {
        public ResourceBundle bundle;
        public String uri;
        public String prefix;
        public int hashCode;

        public BundleEntry(ResourceBundle bundle, String uri, String prefix, int hashCode) {
            this.bundle = bundle;
            this.uri = uri;
            this.prefix = prefix;
            this.hashCode = hashCode;
        }

        public String toString() {
            return "BundleEntry [prefix=" + this.prefix + ", uri=" + this.uri + ", hashCode=" + this.hashCode + ", bundle=" + this.bundle + "]";
        }
    }

    static class Expression {
        public String prefix;
        public String propertyName;

        Expression() {
        }
    }

    class ML
    implements XModelTreeListener {
        ML() {
        }

        public void nodeChanged(XModelTreeEvent event) {
            BundleMap.this.updateShowBundleUsageAsEL();
        }

        public void structureChanged(XModelTreeEvent event) {
        }
    }

    static class UsedKey {
        public int hashCode;
        public String uri;
        public String prefix;
        public String key;
        public String value;

        public UsedKey(String uri, String prefix, String key, String value, int hashCode) {
            this.uri = uri;
            this.prefix = prefix;
            this.key = key;
            this.value = value;
            this.hashCode = hashCode;
        }
    }
}

