/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog.selector.dnd;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.CSSSelectorPartComposite;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSRuleContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSStyleSheetContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSTreeNode;

public class CSSTreeDragAdapter
implements DragSourceListener {
    private Table table;
    private Tree tree;
    private CSSSelectorPartComposite parent;
    private TreeViewer treeViewer;
    private TableViewer tableViewer;

    public CSSTreeDragAdapter(CSSSelectorPartComposite parent, TreeViewer treeViewer, TableViewer tableViewer) {
        this.table = tableViewer.getTable();
        this.tree = treeViewer.getTree();
        this.treeViewer = treeViewer;
        this.tableViewer = tableViewer;
        this.parent = parent;
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = this.tree.getSelectionCount() > 0;
    }

    public void dragSetData(DragSourceEvent event) {
        ArrayList<String> selectedItems = new ArrayList<String>(0);
        TreeItem[] selectedTreeItems = this.tree.getSelection();
        if (selectedTreeItems != null) {
            int i = 0;
            while (i < selectedTreeItems.length) {
                selectedItems.add(selectedTreeItems[i].getData().toString());
                ++i;
            }
        }
        event.data = "css_selector_tree_viwer";
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.detail == 2) {
            LinkedHashSet<CSSTreeNode> itemsToMove = new LinkedHashSet<CSSTreeNode>(0);
            TreeItem[] selectedItems = this.treeViewer.getTree().getSelection();
            if (selectedItems != null && selectedItems.length > 0) {
                int i = 0;
                while (i < selectedItems.length) {
                    TreeItem item = selectedItems[i];
                    CSSContainer container = ((CSSTreeNode)item.getData()).getCSSContainer();
                    CSSTreeNode treeNode = (CSSTreeNode)item.getData();
                    if (container instanceof CSSStyleSheetContainer) {
                        List<CSSTreeNode> children = treeNode.getChildren();
                        int j = 0;
                        while (j < children.size()) {
                            itemsToMove.add(children.get(j));
                            ++j;
                        }
                    } else if (container instanceof CSSRuleContainer) {
                        itemsToMove.add(treeNode);
                    }
                    ++i;
                }
                for (CSSTreeNode cssTreeNode : itemsToMove) {
                    this.tableViewer.add((Object)cssTreeNode.toString());
                }
                this.parent.updateStyles();
            }
        }
    }
}

