/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog.common;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.css.dialog.common.CSSValidator;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;

public class CSSStyleValueValidator
extends CSSValidator
implements IValidator {
    private final LogHacker logHacker = new LogHacker();
    private static Reference<CSSStyleValueValidator> instanceCache;

    public static CSSStyleValueValidator getInstance() {
        CSSStyleValueValidator instance = null;
        if (instanceCache != null) {
            instance = instanceCache.get();
        }
        if (instance == null) {
            instance = new CSSStyleValueValidator();
            instanceCache = new SoftReference<CSSStyleValueValidator>(instance);
        }
        return instance;
    }

    private CSSStyleValueValidator() {
    }

    public boolean isValidValue(String value) {
        this.logHacker.disableLogging();
        boolean valid = true;
        try {
            try {
                this.getValidatingCSS().insertRule(".testSelector {}", 0);
                CSSStyleRule cssRule = (CSSStyleRule)this.getValidatingCSS().getCssRules().item(0);
                CSSStyleDeclaration declaration = cssRule.getStyle();
                declaration.setProperty("background", value, "");
            }
            catch (Throwable throwable) {
                valid = false;
                this.logHacker.enableLogging();
                this.cleanValidatingDocument();
            }
        }
        finally {
            this.logHacker.enableLogging();
            this.cleanValidatingDocument();
        }
        return valid;
    }

    public IStatus validate(Object value) {
        return this.isValidValue((String)value) ? Status.OK_STATUS : new Status(4, "org.jboss.tools.jst.web.ui", JstUIMessages.CSS_INVALID_STYLE_PROPERTY);
    }

    private static class LogHacker {
        private Field logListeners = null;
        private Object oldValue = null;

        public LogHacker() {
            try {
                this.logListeners = RuntimeLog.class.getDeclaredField("logListeners");
                this.logListeners.setAccessible(true);
            }
            catch (Throwable e) {
                WebUiPlugin.getDefault().logError(e);
            }
        }

        public void disableLogging() {
            try {
                this.oldValue = this.logListeners.get(null);
                this.logListeners.set(null, new ArrayList(0));
            }
            catch (Throwable e) {
                WebUiPlugin.getDefault().logError(e);
            }
        }

        public void enableLogging() {
            try {
                try {
                    if (this.oldValue != null) {
                        this.logListeners.set(null, this.oldValue);
                    }
                }
                catch (Throwable e) {
                    WebUiPlugin.getDefault().logError(e);
                    this.oldValue = null;
                }
            }
            finally {
                this.oldValue = null;
            }
        }
    }
}

