/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;

public class FontFamilyDialog
extends Dialog
implements SelectionListener {
    private static final int VIEWER_HEIGHT = 300;
    private static final int BUTTOND_WIDTH = 50;
    private static final int VIEWER_WIDTH = 175;
    private String fontFamily;
    private String existFontFamily;
    private TableViewer fontFamilyTable;
    private TableViewer allFontFamilyTable;
    private Button rightButton;
    private Button leftButton;
    private Composite buttonsContainer;
    private static final String ALL_FONTS_TABLE_SOURCE = "all_fonts_table_source";
    private static final String FONTS_TABLE_SOURCE = "fonts_table_source";

    public FontFamilyDialog(Shell parentShell, String existingFontFamily) {
        super(parentShell);
        this.existFontFamily = existingFontFamily;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initControls(composite);
        this.createLayout(composite);
        this.initListeners();
        this.initDND();
        this.initDefaultContent(composite);
        return composite;
    }

    private void initDefaultContent(Composite composite) {
        HashSet<String> s = new HashSet<String>();
        FontData[] fds = composite.getDisplay().getFontList(null, false);
        int i = 0;
        while (i < fds.length) {
            s.add(fds[i].getName());
            ++i;
        }
        fds = composite.getDisplay().getFontList(null, true);
        i = 0;
        while (i < fds.length) {
            s.add(fds[i].getName());
            ++i;
        }
        Object[] existFonts = this.fontFamilyParser();
        Arrays.sort(existFonts);
        Object[] answer = new String[s.size()];
        s.toArray(answer);
        Arrays.sort(answer);
        int i2 = 0;
        while (i2 < answer.length) {
            this.allFontFamilyTable.add(answer[i2]);
            ++i2;
        }
        if (this.existFontFamily != null && !this.existFontFamily.equals("")) {
            i2 = 0;
            while (i2 < existFonts.length) {
                this.fontFamilyTable.add(existFonts[i2]);
                this.allFontFamilyTable.remove(existFonts[i2]);
                ++i2;
            }
        }
    }

    private void initDND() {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        this.allFontFamilyTable.addDragSupport(2, types, new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
                if (event.doit && event.detail == 2) {
                    FontFamilyDialog.this.handleAddFont();
                }
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = FontFamilyDialog.ALL_FONTS_TABLE_SOURCE;
            }

            public void dragStart(DragSourceEvent event) {
                event.doit = FontFamilyDialog.this.allFontFamilyTable.getTable().getSelectionCount() > 0;
            }
        });
        this.allFontFamilyTable.addDropSupport(2, types, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                if (event.data == null || event.data.equals(FontFamilyDialog.ALL_FONTS_TABLE_SOURCE)) {
                    event.detail = 0;
                    return;
                }
            }
        });
        this.fontFamilyTable.addDragSupport(2, types, new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
                if (event.doit && event.detail == 2) {
                    FontFamilyDialog.this.handleRemoveFont();
                }
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = FontFamilyDialog.FONTS_TABLE_SOURCE;
            }

            public void dragStart(DragSourceEvent event) {
                event.doit = FontFamilyDialog.this.fontFamilyTable.getTable().getSelectionCount() > 0;
            }
        });
        this.fontFamilyTable.addDropSupport(2, types, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                if (event.data == null || event.data.equals(FontFamilyDialog.FONTS_TABLE_SOURCE)) {
                    event.detail = 0;
                    return;
                }
            }
        });
    }

    private void initListeners() {
        this.allFontFamilyTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FontFamilyDialog.this.handleAddFont();
            }
        });
        this.allFontFamilyTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FontFamilyDialog.this.fontFamilyTable.getTable().deselectAll();
                FontFamilyDialog.this.leftButton.setEnabled(false);
                FontFamilyDialog.this.rightButton.setEnabled(true);
            }
        });
        this.fontFamilyTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FontFamilyDialog.this.allFontFamilyTable.getTable().deselectAll();
                FontFamilyDialog.this.rightButton.setEnabled(false);
                FontFamilyDialog.this.leftButton.setEnabled(true);
            }
        });
        this.fontFamilyTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FontFamilyDialog.this.handleRemoveFont();
            }
        });
        this.fontFamilyTable.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (0x1000003 == e.keyCode && 65536 == e.stateMask) {
                    FontFamilyDialog.this.handleRemoveFont();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.allFontFamilyTable.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (0x1000004 == e.keyCode && 65536 == e.stateMask) {
                    FontFamilyDialog.this.handleAddFont();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.rightButton.addSelectionListener((SelectionListener)this);
        this.leftButton.addSelectionListener((SelectionListener)this);
    }

    private void createLayout(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 300;
        gridData.widthHint = 175;
        this.allFontFamilyTable.getTable().setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 300;
        gridData.widthHint = 175;
        this.fontFamilyTable.getTable().setLayoutData((Object)gridData);
        GridLayout btmContGridLayout = new GridLayout();
        btmContGridLayout.numColumns = 1;
        this.buttonsContainer.setLayout((Layout)btmContGridLayout);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 50;
        this.rightButton.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 50;
        this.leftButton.setLayoutData((Object)gridData);
    }

    private void initControls(Composite composite) {
        this.allFontFamilyTable = new TableViewer(composite, 2818);
        this.buttonsContainer = new Composite(composite, 0);
        this.rightButton = new Button(this.buttonsContainer, 8);
        this.leftButton = new Button(this.buttonsContainer, 8);
        this.fontFamilyTable = new TableViewer(composite, 2818);
        this.rightButton.setToolTipText(JstUIMessages.ADD_FONT_FAMILY_TIP);
        ImageDescriptor rightDesc = WebUiPlugin.getImageDescriptor("images/cssdialog/right.gif");
        Image rightImage = rightDesc.createImage();
        this.rightButton.setImage(rightImage);
        this.rightButton.setEnabled(false);
        this.rightButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Button button = (Button)e.getSource();
                button.getImage().dispose();
            }
        });
        this.leftButton.setToolTipText(JstUIMessages.REMOVE_FONT_FAMILY_TIP);
        ImageDescriptor leftDesc = WebUiPlugin.getImageDescriptor("images/cssdialog/left.gif");
        Image leftImage = leftDesc.createImage();
        this.leftButton.setImage(leftImage);
        this.leftButton.setEnabled(false);
        this.leftButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Button button = (Button)e.getSource();
                button.getImage().dispose();
            }
        });
    }

    private void handleAddFont() {
        TableItem[] selectedItems = this.allFontFamilyTable.getTable().getSelection();
        if (selectedItems != null) {
            Object[] data = new Object[selectedItems.length];
            int i = 0;
            while (i < selectedItems.length) {
                data[i] = selectedItems[i].getData();
                ++i;
            }
            this.fontFamilyTable.add(data);
            this.allFontFamilyTable.remove(data);
            this.rightButton.setEnabled(false);
            this.leftButton.setEnabled(false);
        }
    }

    private void handleRemoveFont() {
        TableItem[] selectedItems = this.fontFamilyTable.getTable().getSelection();
        if (selectedItems != null) {
            Object[] data = new Object[selectedItems.length];
            int i = 0;
            while (i < selectedItems.length) {
                data[i] = selectedItems[i].getData();
                ++i;
            }
            this.addFonts(this.allFontFamilyTable, data);
            this.fontFamilyTable.remove(data);
            this.rightButton.setEnabled(false);
            this.leftButton.setEnabled(false);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(JstUIMessages.FONT_FAMILY_DIALOG_TITLE);
    }

    protected void okPressed() {
        TableItem[] items = this.fontFamilyTable.getTable().getItems();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < items.length) {
            buf.append(String.valueOf(i == 0 ? "" : ",") + items[i].getData());
            ++i;
        }
        this.fontFamily = buf.toString();
        super.okPressed();
    }

    private void addFonts(TableViewer table, Object[] fonts) {
        HashSet<Object> s = new HashSet<Object>();
        TableItem[] items = table.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            s.add(items[i].getData());
            ++i;
        }
        i = 0;
        while (i < fonts.length) {
            s.add(fonts[i]);
            ++i;
        }
        table.getTable().removeAll();
        Object[] answer = new String[s.size()];
        s.toArray(answer);
        Arrays.sort(answer);
        int i2 = 0;
        while (i2 < answer.length) {
            table.add(answer[i2]);
            ++i2;
        }
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    private String[] fontFamilyParser() {
        this.existFontFamily = this.existFontFamily.trim();
        return this.existFontFamily.split(",");
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        Object ob = e.getSource();
        if (ob.equals(this.leftButton)) {
            this.handleRemoveFont();
        } else if (ob.equals(this.rightButton)) {
            this.handleAddFont();
        } else if (ob.equals(this.allFontFamilyTable)) {
            this.fontFamilyTable.getTable().deselectAll();
            this.leftButton.setEnabled(false);
            this.rightButton.setEnabled(true);
        } else if (ob.equals(this.fontFamilyTable)) {
            this.allFontFamilyTable.getTable().deselectAll();
            this.rightButton.setEnabled(false);
            this.leftButton.setEnabled(true);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object ob = e.getSource();
        if (ob.equals(this.leftButton)) {
            this.handleRemoveFont();
        } else if (ob.equals(this.rightButton)) {
            this.handleAddFont();
        }
    }
}

