/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.editor.pref.template.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.editor.pref.template.TemplateContextTypeIdsXHTML;
import org.jboss.tools.jst.web.ui.editor.pref.template.contentassist.XHTMLTemplateCompletionProcessor;
import org.w3c.dom.Node;

public class XHTMLContentAssistProcessor
implements IContentAssistProcessor,
IPropertyChangeListener {
    protected IPreferenceStore fPreferenceStore = null;
    protected boolean isXHTML = false;
    private XHTMLTemplateCompletionProcessor fTemplateProcessor = null;

    private void addTemplates(ITextViewer fTextViewer, List<ICompletionProposal> contentAssistRequest, List<String> fTemplateContexts, int startOffset) {
        if (contentAssistRequest == null) {
            return;
        }
        if (this.getTemplateCompletionProcessor() != null) {
            for (String context : fTemplateContexts) {
                this.getTemplateCompletionProcessor().setContextType(context);
                ICompletionProposal[] proposals = this.getTemplateCompletionProcessor().computeCompletionProposals(fTextViewer, startOffset);
                int i = 0;
                while (i < proposals.length) {
                    contentAssistRequest.add(proposals[i]);
                    ++i;
                }
            }
        }
    }

    protected boolean beginsWith(String aString, String prefix) {
        if (aString == null || prefix == null || prefix.length() == 0) {
            return true;
        }
        int minimumLength = Math.min(prefix.length(), aString.length());
        String beginning = aString.substring(0, minimumLength);
        return beginning.equalsIgnoreCase(prefix);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int documentPosition) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        List<String> fContextTypes = this.getContentTypes(textViewer, documentPosition);
        this.addTemplates(textViewer, result, fContextTypes, documentPosition);
        return result.toArray(new ICompletionProposal[0]);
    }

    private List<String> getContentTypes(ITextViewer textViewer, int documentPosition) {
        ArrayList<String> fContextTypes = new ArrayList<String>();
        fContextTypes.add(TemplateContextTypeIdsXHTML.ALL);
        IDocument document = textViewer.getDocument();
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            Node node = (Node)model.getIndexedRegion(documentPosition);
            if (node == null || node.getNodeType() == 9) {
                fContextTypes.add(TemplateContextTypeIdsXHTML.NEW);
            } else if (node.getNodeType() == 1 || node.getNodeType() == 3) {
                fContextTypes.add(TemplateContextTypeIdsXHTML.ATTRIBUTE);
                fContextTypes.add(TemplateContextTypeIdsXHTML.ATTRIBUTE_VALUE);
                fContextTypes.add(TemplateContextTypeIdsXHTML.TAG);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return fContextTypes;
    }

    protected String getEmptyTagCloseString() {
        if (this.isXHTML) {
            return " />";
        }
        return ">";
    }

    private XHTMLTemplateCompletionProcessor getTemplateCompletionProcessor() {
        if (this.fTemplateProcessor == null) {
            this.fTemplateProcessor = new XHTMLTemplateCompletionProcessor();
        }
        return this.fTemplateProcessor;
    }

    protected boolean getXHTML(Node node) {
        return true;
    }

    protected void init() {
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void release() {
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    protected boolean stringsEqual(String a, String b) {
        return a.equalsIgnoreCase(b);
    }

    public void propertyChange(PropertyChangeEvent event) {
        event.getProperty();
    }

    protected IPreferenceStore getPreferenceStore() {
        if (this.fPreferenceStore == null) {
            this.fPreferenceStore = WebUiPlugin.getDefault().getPreferenceStore();
        }
        return this.fPreferenceStore;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentPosition, IndexedRegion indexedNode, ITextRegion region) {
        return this.computeCompletionProposals(viewer, documentPosition);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return new IContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[0];
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

