/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.action;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.jboss.tools.common.model.ui.ModelUIImages;
import org.jboss.tools.common.ui.CommonUIPlugin;
import org.jboss.tools.jst.web.ui.Messages;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AddAttributeMarkerResolution
implements IMarkerResolution2,
IJavaCompletionProposal {
    private IFile file;
    private int start;
    private int end;
    private String attributeName;
    private Node node;

    public AddAttributeMarkerResolution(IFile file, Node node, String attributeName, int start, int end) {
        this.file = file;
        this.node = node;
        this.attributeName = attributeName;
        this.start = start;
        this.end = end;
    }

    public String getLabel() {
        return NLS.bind((String)Messages.AddAttributeMarkerResolution_Name, (Object)this.attributeName, (Object)this.node.getNodeName());
    }

    public void run(IMarker marker) {
        FileEditorInput input = new FileEditorInput(this.file);
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider((IEditorInput)input);
        try {
            provider.connect((Object)input);
            boolean dirty = provider.canSaveDocument((Object)input);
            IDocument document = provider.getDocument((Object)input);
            this.apply(document);
            if (!dirty) {
                provider.aboutToChange((Object)input);
                provider.saveDocument((IProgressMonitor)new NullProgressMonitor(), (Object)input, document, true);
                provider.changed((Object)input);
            }
            provider.disconnect((Object)input);
        }
        catch (CoreException ex) {
            WebUiPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    public String getDescription() {
        return this.getLabel();
    }

    public Image getImage() {
        return CommonUIPlugin.getImageDescriptorRegistry().get(ModelUIImages.getImageDescriptor((String)ModelUIImages.TAGLIB_ATTRIBUTE));
    }

    public void apply(IDocument document) {
        String text = "<" + this.node.getNodeName() + " ";
        NamedNodeMap attributes = this.node.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node att = attributes.item(i);
                text = String.valueOf(text) + att.getNodeName() + "=\"" + att.getNodeValue() + "\" ";
                ++i;
            }
        }
        text = String.valueOf(text) + this.attributeName + "=\"\">";
        try {
            document.replace(this.start, this.end - this.start, text);
        }
        catch (BadLocationException ex) {
            WebUiPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.getDescription();
    }

    public String getDisplayString() {
        return this.getLabel();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return 0;
    }
}

