/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IValidatingProjectSet;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.IValidationContextManager;
import org.jboss.tools.common.validation.IValidator;
import org.jboss.tools.common.validation.ValidationResourceRegister;

public class ValidationContext
implements IValidationContextManager {
    private Set<ValidationResourceRegister> validationResourceRegisters;
    private Map<IValidator, IValidatingProjectTree> projectTree = new HashMap<IValidator, IValidatingProjectTree>();
    static List<IConfigurationElement> ALL_VALIDATORS;
    protected List<IValidator> validators = new ArrayList<IValidator>();
    private Map<IValidator, Set<IProject>> validatedProjects = new HashMap<IValidator, Set<IProject>>();

    public ValidationContext(IProject project) {
        this.init(project);
    }

    static synchronized void inintConfigurationElements() {
        if (ALL_VALIDATORS == null) {
            ALL_VALIDATORS = new ArrayList<IConfigurationElement>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.jboss.tools.common.validation.validator");
            if (extensionPoint != null) {
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    IConfigurationElement[] elements = extension.getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        ALL_VALIDATORS.add(elements[j]);
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public static void loadValidatorByProblemType(String problemType) {
        ValidationContext.inintConfigurationElements();
        for (IConfigurationElement element : ALL_VALIDATORS) {
            String pt = element.getAttribute("problemType");
            if (!problemType.equals(pt)) continue;
            ValidationContext.createValidator(element, problemType);
        }
    }

    private static IValidator createValidator(IConfigurationElement element, String problemType) {
        try {
            IValidator validator = (IValidator)element.createExecutableExtension("class");
            validator.setProblemType(problemType);
            validator.registerPreferenceInfo();
            return validator;
        }
        catch (CoreException e) {
            CommonPlugin.getDefault().logError((Throwable)e);
            return null;
        }
    }

    protected List<IValidator> getAllValidators(IProject project) {
        this.projectTree.clear();
        this.validators.clear();
        this.validationResourceRegisters = null;
        ValidationContext.inintConfigurationElements();
        ArrayList<IValidator> dependentValidators = new ArrayList<IValidator>();
        ArrayList<IValidator> allValidators = new ArrayList<IValidator>();
        for (IConfigurationElement element : ALL_VALIDATORS) {
            String problemType = element.getAttribute("problemType");
            if (problemType != null) {
                IValidator validator = ValidationContext.createValidator(element, problemType);
                if (validator == null) continue;
                String dependent = element.getAttribute("dependent");
                if (Boolean.parseBoolean(dependent)) {
                    dependentValidators.add(validator);
                    continue;
                }
                allValidators.add(validator);
                continue;
            }
            CommonPlugin.getDefault().logError("problemType is not found for validator class: " + element.getAttribute("class") + " and validator id: " + element.getAttribute("id") + ", problemType must be set as a attribute of element validator in org.jboss.tools.common.validation.validator extension point");
        }
        allValidators.addAll(dependentValidators);
        return allValidators;
    }

    @Override
    public void init(IProject project) {
        List<IValidator> allValidators = this.getAllValidators(project);
        for (IValidator validator : allValidators) {
            IValidatingProjectTree prTree;
            if (!this.shouldValidate(validator, project) || (prTree = validator.getValidatingProjects(project)) == null) continue;
            this.validators.add(validator);
            this.projectTree.put(validator, prTree);
        }
    }

    protected boolean shouldValidate(IValidator validator, IProject project) {
        return validator.shouldValidate(project);
    }

    @Override
    public boolean isObsolete() {
        if (this.validationResourceRegisters != null) {
            Set<ValidationResourceRegister> registers = this.getValidationResourceRegisters();
            for (ValidationResourceRegister register : registers) {
                if (!register.isObsolete()) continue;
                return true;
            }
        }
        return false;
    }

    private Set<ValidationResourceRegister> getValidationResourceRegisters() {
        if (this.validationResourceRegisters == null) {
            this.validationResourceRegisters = new HashSet<ValidationResourceRegister>();
            if (!this.projectTree.isEmpty()) {
                this.validationResourceRegisters = new HashSet<ValidationResourceRegister>();
                for (IValidatingProjectTree tree : this.projectTree.values()) {
                    if (tree.getBrunches().isEmpty()) continue;
                    for (IValidatingProjectSet brunch : tree.getBrunches().values()) {
                        IProjectValidationContext context = brunch.getRootContext();
                        ValidationResourceRegister register = context.getValidationResourceRegister();
                        if (register == null) {
                            register = new ValidationResourceRegister();
                            context.setValidationResourceRegister(register);
                        }
                        this.validationResourceRegisters.add(register);
                    }
                }
            }
        }
        return this.validationResourceRegisters;
    }

    @Override
    public void setValidationResourceRegisters(Set<ValidationResourceRegister> validationResourceRegisters) {
        this.validationResourceRegisters = validationResourceRegisters;
    }

    @Override
    public List<IValidator> getValidators() {
        return this.validators;
    }

    @Override
    public void clearRegisteredFiles() {
        Set<ValidationResourceRegister> registers = this.getValidationResourceRegisters();
        for (ValidationResourceRegister register : registers) {
            register.clear();
        }
    }

    @Override
    public Set<IFile> getRemovedFiles() {
        HashSet<IFile> removed = new HashSet<IFile>();
        Set<ValidationResourceRegister> registers = this.getValidationResourceRegisters();
        for (ValidationResourceRegister register : registers) {
            removed.addAll(register.getRemovedFiles());
        }
        return removed;
    }

    @Override
    public void addRemovedFile(IFile file) {
        for (IValidatingProjectTree tree : this.projectTree.values()) {
            tree.addProject(file.getProject());
        }
        Set<ValidationResourceRegister> registers = this.getValidationResourceRegisters();
        for (ValidationResourceRegister register : registers) {
            register.addRemovedFile(file);
        }
    }

    @Override
    public Set<IFile> getRegisteredFiles() {
        HashSet<IFile> registered = new HashSet<IFile>();
        Set<ValidationResourceRegister> registers = this.getValidationResourceRegisters();
        for (ValidationResourceRegister register : registers) {
            registered.addAll(register.getRegisteredFiles());
        }
        return registered;
    }

    @Override
    public void registerFile(IFile file) {
        Set<ValidationResourceRegister> registers = this.getValidationResourceRegisters();
        for (ValidationResourceRegister register : registers) {
            register.registerFile(file);
        }
    }

    @Override
    public IValidatingProjectTree getValidatingProjectTree(IValidator validator) {
        return this.projectTree.get(validator);
    }

    @Override
    public void addProject(IProject project) {
        for (IValidator validator : this.validators) {
            this.projectTree.get(validator).addProject(project);
        }
    }

    @Override
    public Set<IProject> getRootProjects() {
        HashSet<IProject> roots = new HashSet<IProject>();
        for (IValidatingProjectTree tree : this.projectTree.values()) {
            for (IValidatingProjectSet brunch : tree.getBrunches().values()) {
                roots.add(brunch.getRootProject());
            }
        }
        return roots;
    }

    @Override
    public void clearAllResourceLinks(Set<IProject> rootProjects) {
        Collection<IValidatingProjectTree> trees = this.projectTree.values();
        for (IProject rootProject : rootProjects) {
            for (IValidatingProjectTree tree : trees) {
                IValidatingProjectSet brunch = tree.getBrunches().get(rootProject);
                if (brunch == null) continue;
                brunch.getRootContext().clearAll();
            }
        }
    }

    @Override
    public void addValidatedProject(IValidator validator, IProject project) {
        Set<IProject> projects = this.validatedProjects.get(validator);
        if (projects == null) {
            projects = new HashSet<IProject>();
            this.validatedProjects.put(validator, projects);
        }
        projects.add(project);
    }

    @Override
    public void clearValidatedProjectsList() {
        this.validatedProjects.clear();
    }

    @Override
    public boolean projectHasBeenValidated(IValidator validator, IProject project) {
        Set<IProject> projects = this.validatedProjects.get(validator);
        return projects == null ? false : projects.contains(project);
    }
}

