/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.wizard.export;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.extensions.PlatformSupport;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.internal.projectGenerator.ProjectGeneratorContentProvider;
import org.eclipse.thym.ui.internal.projectGenerator.ProjectGeneratorLabelProvider;
import org.eclipse.thym.ui.wizard.export.BaseExportWizardDestinationPage;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class NativeProjectDestinationPage
extends BaseExportWizardDestinationPage
implements IOverwriteQuery {
    private static final String IMAGE_WIZBAN = "/icons/wizban/exportnativeprj_wiz.png";

    protected NativeProjectDestinationPage(String pageName, IStructuredSelection initialSelection) {
        super(pageName, initialSelection);
        this.setImageDescriptor(HybridUI.getImageDescriptor("org.eclipse.thym.ui", IMAGE_WIZBAN));
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getPlatformsGroup().getTableViewer().setInput((Object)HybridCore.getPlatformSupports());
    }

    public String queryOverwrite(String pathString) {
        final MessageDialog dialog = new MessageDialog(this.getShell(), "Overwrite Files?", null, "Directory " + pathString + " already exists. Would you like to overwrite it?", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
    }

    public List<PlatformSupport> getSelectedPlatforms() {
        Object[] checked = this.getPlatformsGroup().getTableViewer().getCheckedElements();
        ArrayList<PlatformSupport> list = new ArrayList<PlatformSupport>(checked.length);
        int i = 0;
        while (i < checked.length) {
            list.add((PlatformSupport)checked[i]);
            ++i;
        }
        return list;
    }

    @Override
    protected IContentProvider getPlatformContentProvider() {
        return new ProjectGeneratorContentProvider();
    }

    @Override
    protected IBaseLabelProvider getPlatformLabelProvider() {
        return new ProjectGeneratorLabelProvider();
    }
}

