/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.plugin.registry.CordovaPluginRegistryManager;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPluginInfo;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.internal.status.StatusManager;
import org.eclipse.thym.ui.plugins.internal.CordovaPluginCatalogViewer;
import org.eclipse.thym.ui.plugins.internal.ICordovaPluginWizard;
import org.eclipse.thym.ui.plugins.internal.RegistryConfirmPage;
import org.eclipse.thym.ui.util.DirectorySelectionGroup;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CordovaPluginSelectionPage
extends WizardPage {
    public static final int PLUGIN_SOURCE_REGISTRY = 1;
    public static final int PLUGIN_SOURCE_GIT = 2;
    public static final int PLUGIN_SOURCE_DIRECTORY = 3;
    private static final String PAGE_NAME = "Cordova Plug-in Selection Page";
    private static final String PAGE_TITLE = "Install Cordova Plug-in";
    private static final String PAGE_DESCRIPTION = "Discover and Install Cordova Plug-ins";
    private List<CordovaRegistryPluginInfo> cordovaPluginInfos;
    private HybridProject fixedProject;
    private boolean noProject;
    private IStructuredSelection initialSelection;
    private TabFolder tabFolder;
    private TabItem registryTab;
    private CordovaPluginCatalogViewer catalogViewer;
    private TabItem gitTab;
    private TabItem directoryTab;
    private DirectorySelectionGroup destinationDirectoryGroup;
    private Text textProject;
    private Group grpRepositoryUrl;
    private Text gitUrlTxt;
    private final CordovaPluginRegistryManager client = new CordovaPluginRegistryManager();
    private int initialTab;

    public CordovaPluginSelectionPage() {
        super(PAGE_NAME, PAGE_TITLE, HybridUI.getImageDescriptor("org.eclipse.thym.ui", "/icons/wizban/cordova_plugin_wiz.png"));
        this.setDescription(PAGE_DESCRIPTION);
    }

    protected CordovaPluginSelectionPage(IStructuredSelection selection) {
        this();
        this.initialSelection = selection;
    }

    protected CordovaPluginSelectionPage(HybridProject project, int intialTab) {
        this();
        this.fixedProject = project;
        this.initialTab = intialTab;
    }

    public CordovaPluginSelectionPage(boolean noProject) {
        this();
        this.noProject = noProject;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        if (this.fixedProject == null && !this.noProject) {
            this.createProjectGroup(container);
        }
        this.tabFolder = new TabFolder(container, 0);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, true).applyTo((Control)this.tabFolder);
        this.tabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (CordovaPluginSelectionPage.this.cordovaPluginInfos == null && CordovaPluginSelectionPage.this.getSelectedTabItem() == CordovaPluginSelectionPage.this.registryTab) {
                    event.widget.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CordovaPluginSelectionPage.this.populatePluginInfos();
                            CordovaPluginSelectionPage.this.displayPluginInfos();
                        }
                    });
                }
            }
        });
        this.registryTab = new TabItem(this.tabFolder, 0);
        this.registryTab.setText("Registry");
        this.catalogViewer = new CordovaPluginCatalogViewer(this.noProject ? 0 : 2);
        this.catalogViewer.createControl((Composite)this.tabFolder);
        this.catalogViewer.getControl().setFocus();
        this.registryTab.setControl(this.catalogViewer.getControl());
        this.gitTab = new TabItem(this.tabFolder, 0);
        this.gitTab.setText("Git");
        this.grpRepositoryUrl = new Group((Composite)this.tabFolder, 0);
        this.grpRepositoryUrl.setText("Repository");
        this.gitTab.setControl((Control)this.grpRepositoryUrl);
        this.grpRepositoryUrl.setLayout((Layout)new GridLayout(2, false));
        Label lblGitUrlInfo = new Label((Composite)this.grpRepositoryUrl, 0);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)lblGitUrlInfo);
        lblGitUrlInfo.setText("Specify a url to a git repository, an optional git-ref and an optional sub directory");
        Label lblUrl = new Label((Composite)this.grpRepositoryUrl, 0);
        lblUrl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblUrl.setText("URL:");
        this.gitUrlTxt = new Text((Composite)this.grpRepositoryUrl, 2048);
        this.gitUrlTxt.setMessage("http://my.git.com#v1.0.0:/a/sub/dir");
        this.gitUrlTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.gitUrlTxt.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                CordovaPluginSelectionPage.this.setPageComplete(CordovaPluginSelectionPage.this.validatePage());
            }
        });
        this.directoryTab = new TabItem(this.tabFolder, 0);
        this.directoryTab.setText("Directory");
        this.destinationDirectoryGroup = new DirectorySelectionGroup((Composite)this.tabFolder, 0);
        this.destinationDirectoryGroup.setText("Plug-in:");
        this.destinationDirectoryGroup.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.destinationDirectoryGroup.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                CordovaPluginSelectionPage.this.setPageComplete(CordovaPluginSelectionPage.this.validatePage());
            }
        });
        this.directoryTab.setControl((Control)this.destinationDirectoryGroup);
        this.tabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CordovaPluginSelectionPage.this.setPageComplete(CordovaPluginSelectionPage.this.validatePage());
            }
        });
        this.setupFromInitialSelection();
        this.restoreWidgetValues();
        this.updateProjectOnViewer();
        this.updateInitialTab();
        this.catalogViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CordovaPluginSelectionPage.this.setPageComplete(CordovaPluginSelectionPage.this.validatePage());
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.getSelectedTabItem() == this.registryTab) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CordovaPluginSelectionPage.this.populatePluginInfos();
                    CordovaPluginSelectionPage.this.displayPluginInfos();
                }
            });
        }
    }

    private void createProjectGroup(Composite container) {
        Group grpProject = new Group(container, 0);
        grpProject.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpProject.setText("Project");
        grpProject.setLayout((Layout)new GridLayout(3, false));
        Label lblProject = new Label((Composite)grpProject, 0);
        lblProject.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblProject.setText("Project:");
        this.textProject = new Text((Composite)grpProject, 2048);
        this.textProject.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textProject.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                boolean isValidProject = CordovaPluginSelectionPage.this.isValidProject(CordovaPluginSelectionPage.this.textProject.getText());
                CordovaPluginSelectionPage.this.setPageComplete(CordovaPluginSelectionPage.this.validatePage());
                if (isValidProject && CordovaPluginSelectionPage.this.getPluginSourceType() == 1) {
                    CordovaPluginSelectionPage.this.updateProjectOnViewer();
                }
            }
        });
        Button btnProjectBrowse = new Button((Composite)grpProject, 0);
        btnProjectBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog es = new ElementListSelectionDialog(CordovaPluginSelectionPage.this.getShell(), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
                es.setElements(HybridCore.getHybridProjects().toArray());
                es.setTitle("Project Selection");
                es.setMessage("Select a project to run");
                if (es.open() == 0) {
                    HybridProject project = (HybridProject)es.getFirstResult();
                    CordovaPluginSelectionPage.this.textProject.setText(project.getProject().getName());
                }
            }
        });
        btnProjectBrowse.setText("Browse...");
    }

    private void populatePluginInfos() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Class<?> clazz = this.getClass();
                    synchronized (clazz) {
                        try {
                            if (CordovaPluginSelectionPage.this.cordovaPluginInfos == null) {
                                CordovaPluginSelectionPage.this.cordovaPluginInfos = CordovaPluginSelectionPage.this.client.retrievePluginInfos(monitor);
                            }
                        }
                        catch (CoreException ce) {
                            throw new InvocationTargetException(ce);
                        }
                    }
                    if (CordovaPluginSelectionPage.this.cordovaPluginInfos == null) {
                        CoreException e = new CoreException((IStatus)new Status(4, "org.eclipse.thym.ui", "Error while retrieving the Cordova Plug-in Registry Catalog"));
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException inve) {
            if (inve.getTargetException() != null) {
                if (inve.getTargetException() instanceof CoreException) {
                    StatusManager.handle((CoreException)inve.getTargetException());
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Registry catalog eror ", null, (IStatus)new Status(4, "org.eclipse.thym.ui", "Error retrieving the Cordova plug-in registry catalog", inve.getTargetException()));
                }
            }
        }
        catch (InterruptedException inte) {
            throw new OperationCanceledException(inte.getMessage());
        }
    }

    private void setupFromInitialSelection() {
        if (this.initialSelection != null && !this.initialSelection.isEmpty()) {
            for (Object obj : this.initialSelection) {
                IResource res;
                IProject project;
                HybridProject hybrid;
                if (!(obj instanceof IResource) || (hybrid = HybridProject.getHybridProject((IProject)(project = (res = (IResource)obj).getProject()))) == null) continue;
                this.textProject.setText(project.getName());
            }
        }
    }

    public IWizardPage getNextPage() {
        if (this.getSelectedTabItem() != this.registryTab) {
            return null;
        }
        List<CordovaRegistryPluginInfo> infos = this.getCheckedCordovaRegistryItems();
        if (this.getPluginWizard().isPluginSelectionOptional() && (infos == null || infos.isEmpty())) {
            return null;
        }
        ICordovaPluginWizard wiz = (ICordovaPluginWizard)this.getWizard();
        RegistryConfirmPage confirmPage = (RegistryConfirmPage)wiz.getRegistryConfirmPage();
        confirmPage.setSelectedPlugins(this.getCheckedCordovaRegistryItems());
        return super.getNextPage();
    }

    public int getPluginSourceType() {
        TabItem selected = this.getSelectedTabItem();
        if (selected == this.gitTab) {
            return 2;
        }
        if (selected == this.directoryTab) {
            return 3;
        }
        return 1;
    }

    public String getSelectedDirectory() {
        return this.destinationDirectoryGroup.getValue();
    }

    public String getSpecifiedGitURL() {
        return this.gitUrlTxt.getText();
    }

    public String getProjectName() {
        if (this.fixedProject != null) {
            return this.fixedProject.getProject().getName();
        }
        if (this.noProject) {
            return "";
        }
        return this.textProject.getText();
    }

    private List<CordovaRegistryPluginInfo> getCheckedCordovaRegistryItems() {
        IStructuredSelection selection = this.catalogViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return Collections.emptyList();
        }
        return selection.toList();
    }

    private TabItem getSelectedTabItem() {
        TabItem[] selections = this.tabFolder.getSelection();
        Assert.isTrue((selections.length > 0 ? 1 : 0) != 0);
        return selections[0];
    }

    private boolean validatePage() {
        String projectName;
        if (this.fixedProject == null && !this.noProject && !this.isValidProject(projectName = this.textProject.getText())) {
            return false;
        }
        boolean valid = false;
        switch (this.getPluginSourceType()) {
            case 3: {
                valid = this.validateDirectroyTab();
                break;
            }
            case 2: {
                valid = this.validateGitTab();
                break;
            }
            case 1: {
                valid = this.validateRegistryTab();
            }
        }
        if (valid) {
            this.setMessage(null, 0);
        }
        return valid;
    }

    private boolean isValidProject(String projectName) {
        if (projectName == null || projectName.isEmpty()) {
            this.setMessage("Specify a project", 3);
            return false;
        }
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject prj = ws.getRoot().getProject(projectName);
        if (!prj.exists()) {
            this.setMessage("Project does not exist", 3);
            return false;
        }
        if (!prj.isOpen()) {
            this.setMessage("Project is not open", 3);
            return false;
        }
        List projects = HybridCore.getHybridProjects();
        boolean projectValid = false;
        for (HybridProject hybridProject : projects) {
            if (!hybridProject.getProject().getName().equals(projectName)) continue;
            projectValid = true;
            break;
        }
        if (!projectValid) {
            this.setMessage("Specified project is not suitable for Cordova plug-in installation", 3);
            return false;
        }
        return true;
    }

    private boolean validateRegistryTab() {
        List<CordovaRegistryPluginInfo> infos = this.getCheckedCordovaRegistryItems();
        if (!this.getPluginWizard().isPluginSelectionOptional() && infos.isEmpty()) {
            this.setMessage("Specify Cordova plug-in(s) for installation", 3);
            return false;
        }
        return true;
    }

    private void updateProjectOnViewer() {
        HybridProject project = null;
        if (this.fixedProject != null) {
            project = this.fixedProject;
        }
        if (this.noProject) {
            project = null;
        } else if (project == null && this.textProject != null) {
            project = HybridProject.getHybridProject((String)this.textProject.getText());
        }
        this.catalogViewer.setProject(project);
    }

    private boolean validateGitTab() {
        String url = this.gitUrlTxt.getText();
        if (!this.getPluginWizard().isPluginSelectionOptional() && (url == null || url.isEmpty())) {
            this.setMessage("Specify a git repository for fetching the Cordova plug-in", 3);
            return false;
        }
        try {
            new URI(url);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.setMessage("Specify a valid address", 3);
            return false;
        }
        return true;
    }

    private boolean validateDirectroyTab() {
        String directory = this.destinationDirectoryGroup.getValue();
        if (directory == null || directory.isEmpty()) {
            if (this.getPluginWizard().isPluginSelectionOptional()) {
                return true;
            }
            this.setMessage("Select the directory for the Cordova plug-in", 3);
            return false;
        }
        File pluginFile = new File(directory);
        if (!DirectorySelectionGroup.isValidDirectory(pluginFile)) {
            this.setMessage(String.valueOf(directory) + " is not a valid directory", 3);
            return false;
        }
        if (!pluginFile.isDirectory()) {
            this.setMessage("Select an existing directory", 3);
            return false;
        }
        File pluginXML = new File(pluginFile, "plugin.xml");
        if (!pluginXML.isFile()) {
            this.setMessage("Specified directory is not a valid plug-in directory", 3);
            return false;
        }
        return true;
    }

    void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.destinationDirectoryGroup.saveHistory(settings);
        }
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.destinationDirectoryGroup.restoreHistory(settings);
        }
    }

    private ICordovaPluginWizard getPluginWizard() {
        return (ICordovaPluginWizard)this.getWizard();
    }

    private void updateInitialTab() {
        switch (this.initialTab) {
            case 2: {
                this.tabFolder.setSelection(this.gitTab);
                break;
            }
            case 3: {
                this.tabFolder.setSelection(this.directoryTab);
                break;
            }
            default: {
                this.tabFolder.setSelection(this.registryTab);
            }
        }
    }

    protected void displayPluginInfos() {
        if (this.getControl() == null || this.cordovaPluginInfos == null) {
            return;
        }
        final Display display = this.getControl().getDisplay();
        final Object[] pluginInfos = this.cordovaPluginInfos.toArray();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!CordovaPluginSelectionPage.this.getControl().isDisposed() && CordovaPluginSelectionPage.this.isCurrentPage()) {
                            CordovaPluginSelectionPage.this.catalogViewer.getViewer().setInput((Object)pluginInfos);
                        }
                    }
                });
            }
        });
    }
}

