/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.internal.status;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridMobileStatus;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.internal.status.DefaultStatusHandler;
import org.eclipse.thym.ui.internal.status.HybridMobileStatusExtension;
import org.eclipse.thym.ui.status.AbstractStatusHandler;

public class StatusManager {
    private static Map<String, AbstractStatusHandler> handlers;

    public static void handle(IStatus status) {
        if (status.isMultiStatus()) {
            IStatus[] childs = status.getChildren();
            int i = 0;
            while (i < childs.length) {
                if (!childs[i].isOK()) {
                    AbstractStatusHandler handler = StatusManager.getStatusHandler(childs[i]);
                    handler.handle(childs[i]);
                    break;
                }
                ++i;
            }
        } else {
            AbstractStatusHandler handler = StatusManager.getStatusHandler(status);
            handler.handle(status);
        }
    }

    public static void handle(CoreException exception) {
        AbstractStatusHandler handler = StatusManager.getStatusHandler(exception);
        handler.handle(exception);
    }

    private static AbstractStatusHandler getStatusHandler(IStatus status) {
        if (status instanceof HybridMobileStatus) {
            return StatusManager.getHybridMobileStatusHandler((HybridMobileStatus)status);
        }
        return new DefaultStatusHandler();
    }

    private static AbstractStatusHandler getStatusHandler(CoreException exception) {
        IStatus status = exception.getStatus();
        if (status instanceof HybridMobileStatus) {
            return StatusManager.getHybridMobileStatusHandler((HybridMobileStatus)status);
        }
        return StatusManager.getStatusHandler(status);
    }

    private static AbstractStatusHandler getHybridMobileStatusHandler(HybridMobileStatus status) {
        StatusManager.initHandlers();
        String key = StatusManager.makeHandlerKey(status.getPlugin(), status.getCode());
        if (handlers.containsKey(key)) {
            return handlers.get(key);
        }
        return new DefaultStatusHandler();
    }

    private static void initHandlers() {
        if (handlers != null) {
            return;
        }
        HashMap<String, AbstractStatusHandler> initHandles = new HashMap<String, AbstractStatusHandler>();
        List<HybridMobileStatusExtension> extensions = HybridUI.getHybridMobileStatusExtensions();
        for (HybridMobileStatusExtension extension : extensions) {
            String key = StatusManager.makeHandlerKey(extension.getPluginID(), extension.getCode());
            initHandles.put(key, extension.getHandler());
        }
        handlers = initHandles;
    }

    private static String makeHandlerKey(String pluginID, int code) {
        return NLS.bind((String)"{0}_{1}", (Object[])new String[]{pluginID, Integer.toString(code)});
    }
}

