/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.internal.properties;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.plugin.CordovaPlugin;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.internal.engine.AvailableCordovaEnginesSection;
import org.eclipse.ui.dialogs.PropertyPage;

public class EnginePropertyPage
extends PropertyPage {
    public static final String PAGE_ID = "org.eclipse.thym.ui.internal.properties.enginePropertyPage";
    private AvailableCordovaEnginesSection engineSection;

    protected Control createContents(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(control);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)control);
        this.engineSection = new AvailableCordovaEnginesSection();
        this.engineSection.createControl(control);
        this.engineSection.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EnginePropertyPage.this.setValid(EnginePropertyPage.this.isValid());
            }
        });
        this.noDefaultAndApplyButton();
        HybridProject hybridProject = this.getProject();
        Object[] activeEngines = hybridProject.getActiveEngines();
        if (activeEngines != null) {
            this.engineSection.setSelection((ISelection)new StructuredSelection(activeEngines));
        } else {
            this.setValid(this.isValid());
        }
        return control;
    }

    private HybridProject getProject() {
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        HybridProject hybridProject = HybridProject.getHybridProject((IProject)project);
        return hybridProject;
    }

    public boolean isValid() {
        if (this.engineSection.getSelection().isEmpty()) {
            this.setErrorMessage("No engines have been selected");
            return false;
        }
        IStructuredSelection sel = (IStructuredSelection)this.engineSection.getSelection();
        for (HybridMobileEngine engine : sel) {
            IStatus consistentStatus = engine.isLibraryConsistent();
            if (!consistentStatus.isOK()) {
                IStatus[] statusArray = consistentStatus.getChildren();
                int severity = consistentStatus.getSeverity();
                String message = consistentStatus.getMessage();
                int i = 0;
                while (i < statusArray.length) {
                    if (statusArray[i].getSeverity() == severity) {
                        message = statusArray[i].getMessage();
                    }
                    ++i;
                }
                this.setMessage(message, severity);
                return severity != 4;
            }
            try {
                List installedPlugins = this.getProject().getPluginManager().getInstalledPlugins();
                for (CordovaPlugin cordovaPlugin : installedPlugins) {
                    IStatus status = cordovaPlugin.isEngineCompatible(engine);
                    if (status.isOK()) continue;
                    this.setMessage(status.getMessage(), status.getSeverity());
                    return status.getSeverity() != 4;
                }
            }
            catch (CoreException e) {
                HybridUI.log(2, "Error while checking engine and plug-in compatability ", e);
            }
        }
        this.setMessage(null);
        this.setErrorMessage(null);
        return true;
    }

    public boolean performOk() {
        IStructuredSelection selection = (IStructuredSelection)this.engineSection.getSelection();
        List list = selection.toList();
        try {
            this.getProject().updateActiveEngines(list.toArray(new HybridMobileEngine[list.size()]));
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Hybrid Mobile Engine Update failed", (String)("Unable to update the active engine for the project " + this.getProject().getProject().getName()), (IStatus)e.getStatus());
            return false;
        }
        return true;
    }
}

