/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.config.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.thym.core.config.Author;
import org.eclipse.thym.core.config.Content;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.config.internal.AbstactConfigEditorPage;
import org.eclipse.thym.ui.config.internal.ConfigEditor;
import org.eclipse.thym.ui.config.internal.FormUtils;
import org.eclipse.thym.ui.config.internal.StringToDisplayableStringConverter;
import org.eclipse.thym.ui.plugins.internal.LaunchCordovaPluginWizardAction;
import org.eclipse.thym.ui.wizard.export.NativeArtifactExportAction;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class EssentialsPage
extends AbstactConfigEditorPage
implements IHyperlinkListener {
    private static final String PLUGINS_SECTION_CONTENT = "<form><p>Add Cordova plug-ins to extend your applications functionality</p><li style=\"image\"  value=\"plugin\" bindent=\"5\">Search and install from a <a href=\"plugin.registry\">registry</a></li><li style=\"image\"  value=\"plugin\" bindent=\"5\">Use a <a href=\"plugin.git\">git</a> URL to pull and install from a repo</li><li style=\"image\"  value=\"plugin\" bindent=\"5\">Install from a <a href=\"plugin.folder\">directory</a></li></form>";
    private static final String EXPORT_SECTION_CONTENT = "<form><p>Options available to export this application to supported platforms:</p><li style=\"image\" value=\"export\" bindent=\"5\">Export <a href=\"export.project\">Native Platform Project(s)</a> and continue with native tools</li><li style=\"image\" value=\"export\" bindent=\"5\">Export <a href=\"export.app\">Mobile application(s)</a> to distribute</li></form>";
    private DataBindingContext m_bindingContext;
    private FormToolkit formToolkit;
    private Text txtIdtxt;
    private Text txtAuthorname;
    private Text txtDescription;
    private Text txtName;
    private Text txtEmail;
    private Text txtUrl;
    private Text txtVersion;
    private Text txtContentsource;

    public EssentialsPage(FormEditor editor) {
        super(editor, "essentials", "Overview");
        this.formToolkit = editor.getToolkit();
    }

    private Widget getWidget() {
        return ((ConfigEditor)this.getEditor()).getWidget();
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        this.formToolkit.decorateFormHeading(form.getForm());
        managedForm.getForm().setText(this.getTitle());
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormUtils.createFormTableWrapLayout(2));
        Composite left = this.formToolkit.createComposite(body);
        left.setLayout((Layout)FormUtils.createFormPaneTableWrapLayout(1));
        left.setLayoutData((Object)new TableWrapData(256));
        Composite right = this.formToolkit.createComposite(body);
        right.setLayout((Layout)FormUtils.createFormPaneTableWrapLayout(1));
        right.setLayoutData((Object)new TableWrapData(256));
        this.createNameDescriptionSection(left);
        this.createAuthorSection(left);
        this.createPluginsSection(right);
        this.createExportSection(right);
        this.m_bindingContext = this.initDataBindings();
        this.bindAuthor(this.m_bindingContext);
        this.bindContent(this.m_bindingContext);
    }

    private void createPluginsSection(Composite parent) {
        Section sctnPlugins = this.createSection(parent, "Plug-ins");
        sctnPlugins.setLayout((Layout)FormUtils.createClearTableWrapLayout(false, 1));
        TableWrapData data = new TableWrapData(256);
        sctnPlugins.setLayoutData((Object)data);
        FormText text = this.formToolkit.createFormText((Composite)sctnPlugins, true);
        ImageDescriptor idesc = HybridUI.getImageDescriptor("org.eclipse.thym.ui", "/icons/etool16/cordovaplug_wiz.png");
        text.setImage("plugin", idesc.createImage());
        text.setText(PLUGINS_SECTION_CONTENT, true, false);
        sctnPlugins.setClient((Control)text);
        text.addHyperlinkListener((IHyperlinkListener)this);
    }

    private void createExportSection(Composite parent) {
        Section sctnExport = this.createSection(parent, "Export");
        sctnExport.setLayout((Layout)FormUtils.createClearTableWrapLayout(false, 1));
        TableWrapData data = new TableWrapData(256);
        sctnExport.setLayoutData((Object)data);
        FormText text = this.formToolkit.createFormText((Composite)sctnExport, true);
        ImageDescriptor idesc = HybridUI.getImageDescriptor("org.eclipse.thym.ui", "/icons/etool16/export_wiz.png");
        text.setImage("export", idesc.createImage());
        text.setText(EXPORT_SECTION_CONTENT, true, false);
        sctnExport.setClient((Control)text);
        text.addHyperlinkListener((IHyperlinkListener)this);
    }

    private void createAuthorSection(Composite parent) {
        Section sctnAuthor = this.createSection(parent, "Author");
        sctnAuthor.setLayoutData((Object)new TableWrapData(256));
        Composite composite = this.formToolkit.createComposite((Composite)sctnAuthor, 64);
        this.formToolkit.paintBordersFor(composite);
        sctnAuthor.setClient((Control)composite);
        composite.setLayout((Layout)FormUtils.createSectionClientGridLayout(false, 2));
        this.createFormFieldLabel(composite, "Name:");
        this.txtAuthorname = this.formToolkit.createText(composite, "", 64);
        this.txtAuthorname.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.createFormFieldLabel(composite, "Email:");
        this.txtEmail = this.formToolkit.createText(composite, "", 0);
        this.txtEmail.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.createFormFieldLabel(composite, "URL:");
        this.txtUrl = this.formToolkit.createText(composite, "", 0);
        this.txtUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    private Label createFormFieldLabel(Composite composite, String labelText) {
        Label label = this.formToolkit.createLabel(composite, labelText, 0);
        PixelConverter converter = new PixelConverter((Control)label);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        widthHint = Math.max(widthHint, label.computeSize((int)-1, (int)-1, (boolean)true).x);
        GridDataFactory.swtDefaults().hint(widthHint, -1).applyTo((Control)label);
        return label;
    }

    private void createNameDescriptionSection(Composite parent) {
        Section sctnNameAndDescription = this.createSection(parent, "Name and Description");
        sctnNameAndDescription.setLayoutData((Object)new TableWrapData(256));
        Composite container = this.formToolkit.createComposite((Composite)sctnNameAndDescription, 64);
        this.formToolkit.paintBordersFor(container);
        sctnNameAndDescription.setClient((Control)container);
        container.setLayout((Layout)FormUtils.createSectionClientGridLayout(false, 2));
        GridData textGridData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.createFormFieldLabel(container, "ID:");
        this.txtIdtxt = this.formToolkit.createText(container, "", 0);
        this.txtIdtxt.setLayoutData((Object)textGridData);
        this.createFormFieldLabel(container, "Name:");
        this.txtName = this.formToolkit.createText(container, "", 0);
        GridDataFactory.createFrom((GridData)textGridData).applyTo((Control)this.txtName);
        this.createFormFieldLabel(container, "Version:");
        this.txtVersion = this.formToolkit.createText(container, "", 0);
        GridDataFactory.createFrom((GridData)textGridData).applyTo((Control)this.txtVersion);
        this.createFormFieldLabel(container, "Description:");
        this.txtDescription = this.formToolkit.createText(container, "", 2);
        GridDataFactory.createFrom((GridData)textGridData).hint(-1, 100).applyTo((Control)this.txtDescription);
        this.createFormFieldLabel(container, "Content Source:");
        this.txtContentsource = this.formToolkit.createText(container, "", 0);
        GridDataFactory.createFrom((GridData)textGridData).applyTo((Control)this.txtContentsource);
    }

    private Section createSection(Composite parent, String text) {
        Section sctn = this.formToolkit.createSection(parent, 256);
        sctn.clientVerticalSpacing = 6;
        sctn.setText(text);
        return sctn;
    }

    private void bindAuthor(DataBindingContext bindingContext) {
        final WritableValue value = new WritableValue();
        if (this.getWidget() != null) {
            Author author = this.getWidget().getAuthor();
            if (author == null) {
                value.setValue((Object)new DummyAuthor());
            } else {
                value.setValue((Object)author);
            }
            this.getWidget().addPropertyChangeListener("author", new PropertyChangeListener(){

                @Override
                public void propertyChange(final PropertyChangeEvent evt) {
                    value.getRealm().exec(new Runnable(){

                        @Override
                        public void run() {
                            if (evt.getNewValue() == null) {
                                value.setValue((Object)new DummyAuthor());
                            } else {
                                value.setValue(evt.getNewValue());
                            }
                        }
                    });
                }
            });
        }
        ISWTObservableValue observeTextTxtAuthornameObserveWidget = WidgetProperties.text((int)24).observe((org.eclipse.swt.widgets.Widget)this.txtAuthorname);
        IObservableValue authornameGetWidgetObserveValue = BeanProperties.value((String)"name").observeDetail((IObservableValue)value);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new StringToDisplayableStringConverter());
        bindingContext.bindValue((IObservableValue)observeTextTxtAuthornameObserveWidget, authornameGetWidgetObserveValue, null, strategy);
        ISWTObservableValue observeTextTxtEmailObserveWidget = WidgetProperties.text((int)24).observe((org.eclipse.swt.widgets.Widget)this.txtEmail);
        IObservableValue authoremailGetWidgetObserveValue = BeanProperties.value((String)"email").observeDetail((IObservableValue)value);
        bindingContext.bindValue((IObservableValue)observeTextTxtEmailObserveWidget, authoremailGetWidgetObserveValue, null, null);
        ISWTObservableValue observeTextTxtUrlObserveWidget = WidgetProperties.text((int)24).observe((org.eclipse.swt.widgets.Widget)this.txtUrl);
        IObservableValue authorhrefGetWidgetObserveValue = BeanProperties.value((String)"href").observeDetail((IObservableValue)value);
        bindingContext.bindValue((IObservableValue)observeTextTxtUrlObserveWidget, authorhrefGetWidgetObserveValue, null, null);
    }

    private void bindContent(DataBindingContext bindingContext) {
        final WritableValue value = new WritableValue();
        if (this.getWidget() != null) {
            Content content = this.getWidget().getContent();
            if (content == null) {
                value.setValue((Object)new DummyContent());
            } else {
                value.setValue((Object)content);
            }
            this.getWidget().addPropertyChangeListener("content", new PropertyChangeListener(){

                @Override
                public void propertyChange(final PropertyChangeEvent evt) {
                    value.getRealm().exec(new Runnable(){

                        @Override
                        public void run() {
                            if (evt.getNewValue() == null) {
                                value.setValue((Object)new DummyContent());
                            } else {
                                value.setValue(evt.getNewValue());
                            }
                        }
                    });
                }
            });
        }
        ISWTObservableValue observeTextTxtContentsourceObserveWidget = WidgetProperties.text((int)24).observe((org.eclipse.swt.widgets.Widget)this.txtContentsource);
        IObservableValue contentsrcGetWidgetObserveValue = BeanProperties.value((String)"src").observeDetail((IObservableValue)value);
        bindingContext.bindValue((IObservableValue)observeTextTxtContentsourceObserveWidget, contentsrcGetWidgetObserveValue, new UpdateValueStrategy(){

            protected IStatus doSet(IObservableValue observableValue, Object value) {
                if (value == null || value.toString().isEmpty()) {
                    EssentialsPage.this.getWidget().setContent(null);
                    return Status.OK_STATUS;
                }
                return super.doSet(observableValue, value);
            }
        }, null);
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTxtIdtxtObserveWidget = WidgetProperties.text((int)24).observe((org.eclipse.swt.widgets.Widget)this.txtIdtxt);
        IObservableValue idGetWidgetObserveValue = BeanProperties.value((String)"id").observe((Object)this.getWidget());
        bindingContext.bindValue((IObservableValue)observeTextTxtIdtxtObserveWidget, idGetWidgetObserveValue, null, null);
        ISWTObservableValue observeTextTxtNameObserveWidget = WidgetProperties.text((int)24).observe((org.eclipse.swt.widgets.Widget)this.txtName);
        IObservableValue nameGetWidgetObserveValue = BeanProperties.value((String)"name").observe((Object)this.getWidget());
        UpdateValueStrategy strategy_3 = new UpdateValueStrategy();
        strategy_3.setConverter((IConverter)new StringToDisplayableStringConverter());
        bindingContext.bindValue((IObservableValue)observeTextTxtNameObserveWidget, nameGetWidgetObserveValue, null, strategy_3);
        ISWTObservableValue observeTextTxtDescriptionObserveWidget = WidgetProperties.text((int)24).observe((org.eclipse.swt.widgets.Widget)this.txtDescription);
        IObservableValue descriptionGetWidgetObserveValue = BeanProperties.value((String)"description").observe((Object)this.getWidget());
        UpdateValueStrategy strategy_2 = new UpdateValueStrategy();
        strategy_2.setConverter((IConverter)new StringToDisplayableStringConverter());
        bindingContext.bindValue((IObservableValue)observeTextTxtDescriptionObserveWidget, descriptionGetWidgetObserveValue, null, strategy_2);
        ISWTObservableValue observeTextTxtVersionObserveWidget = WidgetProperties.text((int)24).observe((org.eclipse.swt.widgets.Widget)this.txtVersion);
        IObservableValue versionGetWidgetObserveValue = BeanProperties.value((String)"version").observe((Object)this.getWidget());
        bindingContext.bindValue((IObservableValue)observeTextTxtVersionObserveWidget, versionGetWidgetObserveValue, null, null);
        return bindingContext;
    }

    public void linkActivated(HyperlinkEvent e) {
        String href = (String)e.getHref();
        Action action = null;
        if ("export.project".equals(href)) {
            action = new NativeArtifactExportAction(this.getConfigEditor(), NativeArtifactExportAction.ExportType.PROJECT);
        } else if ("export.app".equals(href)) {
            action = new NativeArtifactExportAction(this.getConfigEditor(), NativeArtifactExportAction.ExportType.APPLICATION);
        } else if ("plugin.folder".equals(href)) {
            action = new LaunchCordovaPluginWizardAction(this.getConfigEditor(), 3);
        } else if ("plugin.git".equals(href)) {
            action = new LaunchCordovaPluginWizardAction(this.getConfigEditor(), 2);
        } else if ("plugin.registry".equals(href)) {
            action = new LaunchCordovaPluginWizardAction(this.getConfigEditor(), 1);
        }
        Assert.isNotNull((Object)action);
        action.run();
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }

    private class DummyAuthor {
        private DummyAuthor() {
        }

        public void setHref(String href) {
            Author a = this.createAuthor();
            a.setHref(href);
        }

        public void setEmail(String email) {
            Author a = this.createAuthor();
            a.setEmail(email);
        }

        public void setName(String name) {
            Author a = this.createAuthor();
            a.setName(name);
        }

        private Author createAuthor() {
            Author a = ((ConfigEditor)EssentialsPage.this.getEditor()).getWidgetModel().createAuthor(EssentialsPage.this.getWidget());
            EssentialsPage.this.getWidget().setAuthor(a);
            return a;
        }

        public String getName() {
            return null;
        }

        public String getEmail() {
            return null;
        }

        public String getHref() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }
    }

    private class DummyContent {
        private DummyContent() {
        }

        public void setSrc(String href) {
            Content c = ((ConfigEditor)EssentialsPage.this.getEditor()).getWidgetModel().createContent(EssentialsPage.this.getWidget());
            EssentialsPage.this.getWidget().setContent(c);
            c.setSrc(href);
        }

        public String getSrc() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }
    }
}

