/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.xml.model;

import java.util.ArrayList;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.common.model.filesystems.impl.Libs;
import org.jboss.tools.common.model.impl.trees.FileSystemResourceTree;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class HibernateResourceTree
extends FileSystemResourceTree {
    protected boolean accepts0(XModelObject o) {
        String pathpart;
        int type = o.getFileType();
        if (type == 2) {
            return !"true".equals(o.get("overlapped"));
        }
        if (type != 1) {
            return false;
        }
        String pp = pathpart = o.getPathPart();
        pp = pp.toLowerCase();
        return pp.endsWith(".hbm.xml");
    }

    public void setModel(XModel model) {
        FileSystemsImpl fs;
        super.setModel(model);
        if (EclipseResourceUtil.isProjectFragment((XModel)model) && (fs = (FileSystemsImpl)FileSystemsHelper.getFileSystems((XModel)model)) != null) {
            fs.forceUpdate();
        }
    }

    public XModelObject[] getChildren(XModelObject object) {
        if (object == this.getRoot()) {
            String name;
            XModelObject[] os = object.getChildren();
            ArrayList<XModelObject> list = new ArrayList<XModelObject>();
            int i = 0;
            while (i < os.length) {
                name = os[i].getAttributeValue("name");
                if (name.startsWith("src")) {
                    list.add(os[i]);
                }
                ++i;
            }
            i = 0;
            while (i < os.length) {
                name = os[i].getAttributeValue("name");
                if (name.startsWith(Libs.LIB_PREFIX)) {
                    list.add(os[i]);
                }
                ++i;
            }
            return list.toArray(new XModelObject[0]);
        }
        if (!this.hasChildren(object)) {
            return new XModelObject[0];
        }
        ArrayList<XModelObject> l = new ArrayList<XModelObject>();
        XModelObject[] cs = object.getChildren();
        int i = 0;
        while (i < cs.length) {
            if (this.accept(cs[i])) {
                l.add(cs[i]);
            }
            ++i;
        }
        return l.toArray(new XModelObject[0]);
    }

    public XModelObject getParent(XModelObject object) {
        return object.getParent();
    }

    private boolean accept(XModelObject c) {
        if (c.getFileType() == 2) {
            String overlappedSystem;
            String overlapped = c.get("overlapped");
            if (overlapped != null && overlapped.length() > 0 && !"FileSystems/WEB-INF".equals(overlappedSystem = c.get("overlappedSystem"))) {
                return false;
            }
        } else if (c.getFileType() == 1) {
            String nm = c.getAttributeValue("name");
            if (nm.length() == 0) {
                return false;
            }
            if (!this.accepts0(c)) {
                return false;
            }
        }
        return true;
    }

    public boolean isSelectable(XModelObject object) {
        return object != null && object.getFileType() == 1;
    }

    public String getPath(XModelObject o) {
        if (o == null || o.getFileType() == 3) {
            return "";
        }
        String s = XModelObjectLoaderUtil.getResourcePath((XModelObject)o);
        String p = o.getPath();
        if (p == null) {
            return "";
        }
        int b = "FileSystems/".length();
        int e = p.length() - s.length();
        if (e < b) {
            return "";
        }
        if (o.getFileType() == 2) {
            s = String.valueOf(s) + "/";
        }
        if (s.startsWith("/")) {
            s = s.substring(1);
        }
        return s;
    }

    public XModelObject find(String value) {
        XModelObject result;
        if (value != null && value.endsWith("/")) {
            value = value.substring(0, value.length() - 1);
        }
        if ((result = this.model.getByPath(value)) == null && value != null && !value.startsWith("/")) {
            result = this.model.getByPath("/" + value);
        }
        return result;
    }
}

