/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.xml.model;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.w3c.dom.Element;

class HibernateLoaderUtil
extends XModelObjectLoaderUtil {
    static String[] metaFolders = new String[]{"Meta"};
    static String[] fileFolders = new String[]{"Types", "Imports", "Classes", "Result Sets", "Queries", "Filters", "Database Objects"};
    static String[] classFolders = new String[]{"Tuplizers", "Properties", "Subclasses", "SQL", "Filters", "Result Sets", "Queries"};
    static String[] subclassFolders = new String[]{"Tuplizers", "Synchronize", "Properties", "Subclasses", "SQL", "Result Sets", "Queries"};
    static String[] compositeElementFolders = new String[]{"Properties"};
    static String[] listFolders = new String[]{"SQL"};
    static String[] setFolders = new String[]{"SQL", "Filters"};
    static Map<String, String[]> folders = new HashMap<String, String[]>();

    static {
        folders.put("file", fileFolders);
        folders.put("class", classFolders);
        folders.put("subclass", subclassFolders);
        folders.put("component", compositeElementFolders);
        folders.put("element", compositeElementFolders);
        folders.put("list", listFolders);
        folders.put("set", setFolders);
    }

    HibernateLoaderUtil() {
    }

    private String[] getFolders(XModelObject o) {
        String loaderKind = o.getModelEntity().getProperty("loaderKind");
        return loaderKind == null ? null : folders.get(loaderKind);
    }

    public void loadChildren(Element element, XModelObject o) {
        super.loadChildren(element, o);
        this.loadFolders(element, o, metaFolders);
        String[] fs = this.getFolders(o);
        if (fs != null) {
            this.loadFolders(element, o, fs);
        }
    }

    protected void loadFolders(Element element, XModelObject o, String[] folders) {
        int i = 0;
        while (i < folders.length) {
            XModelObject c = o.getChildByPath(folders[i]);
            if (c != null) {
                super.loadChildren(element, c);
            }
            ++i;
        }
    }

    public boolean saveChildren(Element element, XModelObject o) {
        this.saveFolders(element, o, metaFolders);
        String entity = o.getModelEntity().getName();
        if ("Hibernate3Component".equals(entity)) {
            HibernateLoaderUtil.moveElementToEnd(element, "parent");
        }
        boolean b = super.saveChildren(element, o);
        String[] fs = this.getFolders(o);
        if (fs != null) {
            this.saveFolders(element, o, fs);
        }
        return b;
    }

    protected boolean saveFolders(Element element, XModelObject o, String[] folders) {
        boolean b = true;
        int i = 0;
        while (i < folders.length) {
            XModelObject c = o.getChildByPath(folders[i]);
            if (c != null) {
                b &= super.saveChildren(element, c);
            }
            ++i;
        }
        return b;
    }

    protected boolean isSaveable(XModelEntity entity, String n, String v, String dv) {
        if (v == null) {
            return false;
        }
        if (v.length() == 0 || v.equals(dv)) {
            XAttribute attr = entity.getAttribute(n);
            return attr != null && "always".equals(attr.getProperty("save"));
        }
        return super.isSaveable(entity, n, v, dv);
    }

    static void moveElementToEnd(Element element, String name) {
        Element[] es = XMLUtilities.getChildren((Element)element, (String)name);
        if (es != null) {
            int i = 0;
            while (i < es.length) {
                element.removeChild(es[i]);
                element.appendChild(es[i]);
                ++i;
            }
        }
    }

    protected String getChildEntity(XModelEntity entity, Element e) {
        if (e != null && "database-object".equals(e.getNodeName())) {
            Element c = XMLUtilities.getUniqueChild((Element)e, (String)"definition");
            return c != null ? "Hibernate3DatabaseObjectDef" : "Hibernate3DatabaseObjectCreateDrop";
        }
        return super.getChildEntity(entity, e);
    }
}

