/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.core.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.tree.HasRoot;
import org.jboss.tools.jmx.core.tree.Root;

public abstract class Node
implements Comparable,
HasRoot {
    protected Node parent;
    private List<Node> children = new ArrayList<Node>();

    public Node(Node parent) {
        this.parent = parent;
    }

    public Node addChild(Node node) {
        if (!this.children.contains(node)) {
            this.children.add(node);
            Collections.sort(this.children);
            return node;
        }
        return this.children.get(this.children.indexOf(node));
    }

    public boolean removeChild(Node child) {
        return this.children.remove(child);
    }

    public Node[] getChildren() {
        return this.children.toArray(new Node[this.children.size()]);
    }

    public List<Node> getChildrenList() {
        return this.children;
    }

    public Node getParent() {
        return this.parent;
    }

    public void clearChildren() {
        this.children.clear();
    }

    public static Root getRoot(Node n) {
        return n.getRoot();
    }

    @Override
    public Root getRoot() {
        if (this.parent == null) {
            return this instanceof Root ? (Root)this : null;
        }
        return this.parent.getRoot();
    }

    public IConnectionWrapper getConnection() {
        Root r = Node.getRoot(this);
        return r.getConnection();
    }
}

