/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.ajax4jsf.template;

import org.jboss.tools.jsf.vpe.jsf.VpeElementProxyData;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.AttributeData;
import org.jboss.tools.vpe.editor.mapping.NodeData;
import org.jboss.tools.vpe.editor.mapping.VpeElementData;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Ajax4JSFStatusTemplate
extends VpeAbstractTemplate {
    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Creator creator = new Creator(pageContext, (Element)sourceNode, visualDocument);
        return creator.create();
    }

    private static class Creator {
        private static final String ATTR_STOP_TEXT = "stopText";
        private static final String STOP_FACET_NAME = "stop";
        private static final String START_FACET_NAME = "start";
        private static final String ATTR_STOP_STYLE_CLASS = "stopStyleClass";
        private static final String ATTR_STOP_STYLE = "stopStyle";
        private final VpePageContext pageContext;
        private final Element sourceElement;
        private final nsIDOMDocument visualDocument;
        private VpeCreationData vpeCreationData;

        public Creator(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument) {
            this.pageContext = pageContext;
            this.sourceElement = sourceElement;
            this.visualDocument = visualDocument;
        }

        public VpeCreationData create() {
            nsIDOMElement mainElement = this.createMainElement();
            this.vpeCreationData = new VpeCreationData((nsIDOMNode)mainElement);
            VpeChildrenInfo childrenInfo = new VpeChildrenInfo(mainElement);
            this.vpeCreationData.addChildrenInfo(childrenInfo);
            Element stopFacet = ComponentUtil.getFacet((Element)this.sourceElement, (String)STOP_FACET_NAME);
            if (stopFacet != null) {
                childrenInfo.addSourceChild((Node)stopFacet);
            } else {
                nsIDOMElement stopTextElement = this.createStopTextElement();
                if (stopTextElement != null) {
                    mainElement.appendChild((nsIDOMNode)this.createStopTextElement());
                }
            }
            return this.vpeCreationData;
        }

        private nsIDOMElement createMainElement() {
            nsIDOMElement span = this.visualDocument.createElement("span");
            StringBuilder spanClass = new StringBuilder();
            if (this.sourceElement.hasAttribute("styleClass")) {
                String styleClass = this.sourceElement.getAttribute("styleClass");
                spanClass.append(styleClass);
            }
            if (this.sourceElement.hasAttribute(ATTR_STOP_STYLE_CLASS)) {
                String stopStyleClass = this.sourceElement.getAttribute(ATTR_STOP_STYLE_CLASS);
                spanClass.append(" ").append(stopStyleClass);
            }
            span.setAttribute("class", spanClass.toString());
            StringBuilder spanStyle = new StringBuilder();
            if (this.sourceElement.hasAttribute("style")) {
                String style = this.sourceElement.getAttribute("style");
                spanStyle.append(style).append(";");
            }
            if (this.sourceElement.hasAttribute(ATTR_STOP_STYLE)) {
                String stopStyle = this.sourceElement.getAttribute(ATTR_STOP_STYLE);
                spanStyle.append(stopStyle).append(";");
            }
            span.setAttribute("style", spanStyle.toString());
            return span;
        }

        private nsIDOMElement createStopTextElement() {
            nsIDOMElement visualElement = null;
            Attr stopTextAttribute = this.sourceElement.getAttributeNode(ATTR_STOP_TEXT);
            if (stopTextAttribute != null) {
                visualElement = VisualDomUtil.createBorderlessContainer((nsIDOMDocument)this.visualDocument);
                nsIDOMText textNode = this.visualDocument.createTextNode(stopTextAttribute.getNodeValue());
                visualElement.appendChild((nsIDOMNode)textNode);
                VpeElementProxyData elementData = new VpeElementProxyData();
                elementData.addNodeData((NodeData)new AttributeData(stopTextAttribute, (nsIDOMNode)textNode, true));
                this.vpeCreationData.setElementData((VpeElementData)elementData);
            }
            return visualElement;
        }

        private void addChildrenInfo(nsIDOMElement visualParent) {
            VpeChildrenInfo childrenInfo = new VpeChildrenInfo(visualParent);
            this.vpeCreationData.addChildrenInfo(childrenInfo);
            NodeList children = this.sourceElement.getChildNodes();
            int childrenLength = children.getLength();
            int i = 0;
            while (i < childrenLength) {
                Element facet;
                String facetName;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && child.getNodeName().endsWith("facet") && !START_FACET_NAME.equalsIgnoreCase(facetName = (facet = (Element)child).getAttribute("name")) && STOP_FACET_NAME.equalsIgnoreCase(facetName)) {
                    childrenInfo.addSourceChild((Node)facet);
                }
                ++i;
            }
        }
    }
}

