/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.IArchiveStandardFileSet;
import org.jboss.ide.eclipse.archives.core.util.PathUtils;
import org.jboss.tools.archives.scanner.ITreeNode;
import org.jboss.tools.archives.scanner.VirtualDirectoryScanner;

public class DirectoryScannerFactory {
    public static DirectoryScannerExtension createDirectoryScanner(IArchiveStandardFileSet fs, boolean scan) {
        String excludes = fs.getExcludesPattern();
        if (fs.getRootArchive().isDestinationInWorkspace()) {
            String s1 = fs.getRootArchive().getRawDestinationPath();
            excludes = excludes == null || excludes.length() == 0 ? s1 : String.valueOf(excludes) + "," + s1;
        }
        return DirectoryScannerFactory.createDirectoryScanner(fs.getRawSourcePath(), fs.getRootArchiveRelativePath(), fs.getIncludesPattern(), excludes, fs.getProjectName(), fs.isInWorkspace(), fs.getDescriptorVersion(), scan);
    }

    public static DirectoryScannerExtension createDirectoryScanner(String rawPath, IPath rootArchiveRelativePath, String includes, String excludes, String projectName, boolean inWorkspace, double version, boolean scan) {
        return DirectoryScannerFactory.createDirectoryScanner(rawPath, rootArchiveRelativePath, includes, excludes, projectName, inWorkspace, version, scan, null);
    }

    public static DirectoryScannerExtension createDirectoryScanner(String rawPath, IPath rootArchiveRelativePath, String includes, String excludes, String projectName, boolean inWorkspace, double version, boolean scan, IProgressMonitor monitor) throws RuntimeException {
        ScannableFileSet fs = new ScannableFileSet();
        fs.rawPath = rawPath;
        fs.rootArchiveRelativePath = rootArchiveRelativePath;
        fs.includes = includes;
        fs.excludes = excludes;
        fs.inWorkspace = inWorkspace;
        fs.projectName = projectName;
        fs.version = version;
        DirectoryScannerExtension scanner = new DirectoryScannerExtension(fs);
        if (scan) {
            if (monitor == null) {
                scanner.scan();
            } else {
                scanner.scan(monitor);
            }
        }
        return scanner;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DirectoryScannerExtension
    extends VirtualDirectoryScanner<FileWrapper> {
        protected boolean workspaceRelative;
        protected ScannableFileSet fs;
        protected ArrayList<FileWrapper> matches;
        protected HashMap<String, ArrayList<FileWrapper>> matchesMap;
        protected HashMap<String, ArrayList<FileWrapper>> requiredFolders;
        private IProgressMonitor monitor;

        public DirectoryScannerExtension(ScannableFileSet fs) {
            this.fs = fs;
            String includes = fs.includes == null ? "" : fs.includes;
            String excludes = fs.excludes == null ? "" : fs.excludes;
            String[] includesList = includes.split(" ?, ?");
            String[] excludesList = excludes.split(" ?, ?");
            this.setExcludes(excludesList);
            this.setIncludes(includesList);
            this.workspaceRelative = fs.inWorkspace;
            this.matches = new ArrayList();
            this.matchesMap = new HashMap();
            this.requiredFolders = new HashMap();
            this.setBasedir2(fs.rawPath);
        }

        public void scan(IProgressMonitor monitor) throws IllegalStateException {
            this.monitor = monitor;
            super.scan();
        }

        public void scan() throws IllegalStateException {
            super.scan();
        }

        public void setBasedir2(String path) {
            String s = PathUtils.getAbsoluteLocation(path, this.fs.projectName, this.fs.inWorkspace, this.fs.version);
            if (s == null) {
                return;
            }
            Path translatedPath = new Path(s);
            if (this.workspaceRelative) {
                IPath p = PathUtils.getGlobalLocation(path, this.fs.projectName, true, this.fs.version);
                this.setBasedir(new FileWrapper(p.toFile(), (IPath)translatedPath, this.fs.rootArchiveRelativePath));
            } else {
                this.setBasedir(new FileWrapper(translatedPath.toFile(), (IPath)translatedPath, this.fs.rootArchiveRelativePath));
            }
        }

        protected String getName(File file) {
            return this.getName((ITreeNode)file);
        }

        protected String getName(ITreeNode file) {
            return this.workspaceRelative ? ((FileWrapper)file).getOutputName() : super.getName(file);
        }

        protected ITreeNode[] listChildren(ITreeNode file) {
            return this.listFileWrapperChildren((FileWrapper)file);
        }

        protected File[] list2(File file) {
            return this.listFileWrapperChildren((FileWrapper)file);
        }

        protected FileWrapper[] listFileWrapperChildren(FileWrapper file) {
            if (this.monitor != null && this.monitor.isCanceled()) {
                throw new RuntimeException();
            }
            if (this.fs.inWorkspace) {
                return this.listWorkspace(file);
            }
            return this.listAbsolute(file);
        }

        protected File getChild(File file, String element) {
            ITreeNode n = this.getChild((FileWrapper)file, element);
            return (File)n;
        }

        protected ITreeNode getChild(FileWrapper file, String element) {
            if (this.monitor != null && this.monitor.isCanceled()) {
                throw new RuntimeException();
            }
            FileWrapper f2 = file;
            if (!this.fs.inWorkspace) {
                return new FileWrapper(f2, (IPath)new Path(f2.getAbsolutePath()), this.fs.rootArchiveRelativePath);
            }
            FileWrapper pWrapper = file;
            File child = new File(f2, element);
            FileWrapper childWrapper = new FileWrapper(child, pWrapper.getWrapperPath().append(element), this.fs.rootArchiveRelativePath);
            return childWrapper;
        }

        protected File[] list2workspace(File file) {
            return this.list2workspace(file);
        }

        protected FileWrapper[] listWorkspace(File file) {
            if (this.monitor != null && this.monitor.isCanceled()) {
                throw new RuntimeException();
            }
            IPath workspaceRelative = ((FileWrapper)file).getWrapperPath();
            if (workspaceRelative == null) {
                return new FileWrapper[0];
            }
            IPath[] childrenWorkspace = ArchivesCore.getInstance().getVFS().getWorkspaceChildren(workspaceRelative);
            IPath[] childrenAbsolute = this.globalize(childrenWorkspace);
            FileWrapper[] files = new FileWrapper[childrenAbsolute.length];
            IPath parentRootFSRelative = ((FileWrapper)file).getRootArchiveRelative();
            int i = 0;
            while (i < files.length) {
                files[i] = new FileWrapper(childrenAbsolute[i].toFile(), childrenWorkspace[i], parentRootFSRelative.append(childrenWorkspace[i].lastSegment()));
                ++i;
            }
            return files;
        }

        protected IPath[] globalize(IPath[] paths) {
            IPath[] results = new IPath[paths.length];
            int i = 0;
            while (i < paths.length) {
                results[i] = ArchivesCore.getInstance().getVFS().workspacePathToAbsolutePath(paths[i]);
                ++i;
            }
            return results;
        }

        protected File[] list2absolute(File file) {
            return this.listAbsolute(file);
        }

        protected FileWrapper[] listAbsolute(File file) {
            if (this.monitor != null && this.monitor.isCanceled()) {
                throw new RuntimeException();
            }
            File[] children = file.listFiles();
            if (children != null) {
                FileWrapper[] children2 = new FileWrapper[children.length];
                int i = 0;
                while (i < children.length) {
                    children2[i] = new FileWrapper(children[i], (IPath)new Path(children[i].getAbsolutePath()), this.fs.rootArchiveRelativePath);
                    ++i;
                }
                return children2;
            }
            return new FileWrapper[0];
        }

        protected void postInclude(File f, String relative) {
            this.postInclude((FileWrapper)f, relative);
        }

        protected void postInclude(FileWrapper f, String relative) {
            super.postInclude((ITreeNode)f, relative);
            if (f instanceof FileWrapper) {
                FileWrapper f2 = f;
                f2.setFilesetRelative(relative);
                if (f2.isFile()) {
                    this.matches.add(f2);
                    this.addMatchToMap(f2, this.matchesMap);
                    if (this.fs.inWorkspace) {
                        this.ensureRequiredFoldersIncluded(f2);
                    }
                }
            }
        }

        protected void addMatchToMap(FileWrapper f2, HashMap<String, ArrayList<FileWrapper>> map) {
            ArrayList<FileWrapper> l = map.get(f2);
            if (l == null) {
                l = new ArrayList();
                map.put(f2.getAbsolutePath(), l);
            }
            l.add(f2);
        }

        protected void ensureRequiredFoldersIncluded(FileWrapper includedFile) {
            FileWrapper tmpParentWrapper = includedFile.getParentFile();
            while (tmpParentWrapper != null) {
                includedFile = tmpParentWrapper;
                if (this.requiredFolders.get(includedFile.getAbsolutePath()) != null) {
                    return;
                }
                this.addMatchToMap(includedFile, this.requiredFolders);
                tmpParentWrapper = includedFile.getParentFile();
            }
        }

        protected boolean isSelected(String name, File file) {
            return this.isSelected(name, (ITreeNode)file);
        }

        protected boolean isSelected(String name, ITreeNode file) {
            return file != null && super.isSelected(name, file) && file.isLeaf();
        }

        public FileWrapper[] getMatchedArray() {
            return this.matches.toArray(new FileWrapper[this.matches.size()]);
        }

        public HashMap<String, ArrayList<FileWrapper>> getMatchedMap() {
            return this.matchesMap;
        }

        public HashMap<String, ArrayList<FileWrapper>> getRequiredFolderMap() {
            return this.requiredFolders;
        }

        public boolean couldBeIncluded(String path, boolean inWorkspace) {
            if (this.getBasedir() == null) {
                return false;
            }
            IPath targetBase = ((FileWrapper)this.getBasedir()).getWrapperPath();
            IPath[] questionFiles = new IPath[]{new Path(path)};
            if (this.workspaceRelative && !inWorkspace) {
                questionFiles = ArchivesCore.getInstance().getVFS().absolutePathToWorkspacePath(questionFiles[0]);
            } else if (!this.workspaceRelative && inWorkspace) {
                questionFiles[0] = ArchivesCore.getInstance().getVFS().workspacePathToAbsolutePath(questionFiles[0]);
            }
            ArrayList<IPath> acceptablePaths = new ArrayList<IPath>();
            int i = 0;
            while (i < questionFiles.length) {
                if (targetBase.isPrefixOf(questionFiles[i])) {
                    acceptablePaths.add(questionFiles[i].removeFirstSegments(targetBase.segmentCount()));
                }
                ++i;
            }
            if (acceptablePaths.size() == 0) {
                return false;
            }
            int i2 = 0;
            while (i2 < acceptablePaths.size()) {
                IPath p = (IPath)acceptablePaths.get(i2);
                if (super.isIncluded(p.toString()) && !super.isExcluded(p.toString())) {
                    return true;
                }
                ++i2;
            }
            return false;
        }

        public static class FileWrapper
        extends File
        implements ITreeNode {
            File f;
            IPath path;
            String fsRelative;
            IPath rootArchiveRelativePath;

            public FileWrapper(File delegate, IPath path2, IPath rootArchiveRelative) {
                super(delegate.getAbsolutePath());
                this.f = delegate;
                this.path = path2;
                this.rootArchiveRelativePath = rootArchiveRelative;
            }

            public FileWrapper(File delegate, IPath path2, IPath rootArchiveRelative, String fsRelative) {
                this(delegate, path2, rootArchiveRelative);
                this.fsRelative = fsRelative;
            }

            public IPath getWrapperPath() {
                return this.path;
            }

            public String getOutputName() {
                return this.path.lastSegment();
            }

            public String getFilesetRelative() {
                return this.fsRelative;
            }

            void setFilesetRelative(String s) {
                this.fsRelative = s;
            }

            public IPath getRootArchiveRelative() {
                if (this.rootArchiveRelativePath != null) {
                    if (this.fsRelative == null) {
                        return this.rootArchiveRelativePath;
                    }
                    return this.rootArchiveRelativePath.append(this.fsRelative);
                }
                return null;
            }

            public boolean equals(Object o) {
                if (o instanceof FileWrapper) {
                    FileWrapper fo = (FileWrapper)o;
                    return this.f.equals(fo.f) && this.path.equals((Object)fo.path);
                }
                return false;
            }

            public FileWrapper getParentFile() {
                if (this.f.getParentFile() == null) {
                    return null;
                }
                if (this.path.segmentCount() == 0) {
                    return null;
                }
                if (this.rootArchiveRelativePath.segmentCount() == 0) {
                    return null;
                }
                Path p = new Path(this.fsRelative);
                if (p.segmentCount() == 0) {
                    return null;
                }
                FileWrapper ret = new FileWrapper(this.f.getParentFile(), this.path.removeLastSegments(1), this.rootArchiveRelativePath.removeLastSegments(1));
                ret.setFilesetRelative(p.removeLastSegments(1).toString());
                return ret;
            }

            public boolean isLeaf() {
                return !this.isDirectory();
            }

            public ITreeNode getChild(String name) {
                return null;
            }

            public ITreeNode[] listChildren() {
                return null;
            }
        }
    }

    private static class ScannableFileSet {
        public String rawPath;
        public IPath rootArchiveRelativePath;
        public String includes;
        public String excludes;
        public boolean inWorkspace;
        public String projectName;
        public double version;

        private ScannableFileSet() {
        }
    }
}

