/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.ui.internal.command;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.IServerModule;
import org.jboss.tools.livereload.core.internal.server.jetty.LiveReloadProxyServer;
import org.jboss.tools.livereload.core.internal.server.wst.LiveReloadServerBehaviour;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.ProjectUtils;
import org.jboss.tools.livereload.core.internal.util.WSTUtils;
import org.jboss.tools.livereload.ui.internal.command.DialogMessages;
import org.jboss.tools.livereload.ui.internal.command.LiveReloadServerConfigurationDialog;
import org.jboss.tools.livereload.ui.internal.command.LiveReloadServerConfigurationDialogModel;
import org.jboss.tools.livereload.ui.internal.util.Pair;

public class OpenInWebBrowserViaLiveReloadUtils {
    private OpenInWebBrowserViaLiveReloadUtils() {
    }

    public static IServerModule retrieveServerModuleFromSelectedElement(Object selection) {
        Object selectedObject;
        if (selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof IServerModule) {
            IServerModule selectedModule = (IServerModule)selectedObject;
            return selectedModule;
        }
        return null;
    }

    public static Pair<IServer, Boolean> openWithLiveReloadServer(Object location, boolean shouldEnableScriptInjection, boolean shouldAllowRemoteConnections) throws CoreException {
        boolean serverStopped;
        IServer liveReloadServer = WSTUtils.findLiveReloadServer();
        if (liveReloadServer == null) {
            LiveReloadServerConfigurationDialogModel model = new LiveReloadServerConfigurationDialogModel(shouldEnableScriptInjection, shouldAllowRemoteConnections);
            LiveReloadServerConfigurationDialog dialog = new LiveReloadServerConfigurationDialog(model, DialogMessages.LIVERELOAD_SERVER_DIALOG_TITLE, DialogMessages.LIVERELOAD_SERVER_DIALOG_MESSAGE);
            int result = dialog.open();
            if (result == 3) {
                return null;
            }
            IServer createdLiveReloadServer = WSTUtils.createLiveReloadServer((int)35729, (boolean)model.isScriptInjectionEnabled(), (boolean)model.isRemoteConnectionsAllowed());
            return new Pair<IServer, Boolean>(createdLiveReloadServer, Boolean.TRUE);
        }
        LiveReloadServerBehaviour liveReloadServerBehaviour = (LiveReloadServerBehaviour)WSTUtils.findServerBehaviour((IServer)liveReloadServer);
        boolean scriptInjectionEnabled = liveReloadServerBehaviour.isScriptInjectionEnabled();
        boolean remoteConnectionsAllowed = liveReloadServerBehaviour.isRemoteConnectionsAllowed();
        boolean bl = serverStopped = liveReloadServer.getServerState() != 2;
        if (serverStopped || shouldEnableScriptInjection && !scriptInjectionEnabled || shouldAllowRemoteConnections && !remoteConnectionsAllowed) {
            LiveReloadServerConfigurationDialogModel model = new LiveReloadServerConfigurationDialogModel(scriptInjectionEnabled || shouldEnableScriptInjection, remoteConnectionsAllowed || shouldAllowRemoteConnections);
            LiveReloadServerConfigurationDialog dialog = new LiveReloadServerConfigurationDialog(model, DialogMessages.LIVERELOAD_SERVER_DIALOG_TITLE, NLS.bind((String)DialogMessages.LIVERELOAD_SERVER_DIALOG_MESSAGE, (Object[])new Object[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}));
            int result = dialog.open();
            if (result == 1) {
                return null;
            }
            liveReloadServerBehaviour.setScriptInjectionAllowed(model.isScriptInjectionEnabled());
            liveReloadServerBehaviour.setRemoteConnectionsAllowed(model.isRemoteConnectionsAllowed());
            return new Pair<IServer, Boolean>(liveReloadServer, Boolean.TRUE);
        }
        return new Pair<IServer, Boolean>(liveReloadServer, Boolean.FALSE);
    }

    public static void openInBrowser(URL url) throws PartInitException, MalformedURLException {
        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
    }

    public static void openInBrowser(IPath location, IServer liveReloadServer) throws PartInitException, MalformedURLException {
        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(OpenInWebBrowserViaLiveReloadUtils.computeURL(location, liveReloadServer));
    }

    public static void openInBrowser(IServerModule module) throws PartInitException, MalformedURLException {
        URL url = OpenInWebBrowserViaLiveReloadUtils.computeURL(module);
        if (url != null) {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
        } else {
            String moduleName = module != null && module.getModule().length > 0 ? module.getModule()[0].getName() : "unknown";
            Logger.warn((String)("Unable to open the selected module '" + moduleName + "' in an external browser."));
        }
    }

    private static URL computeURL(IPath file, IServer liveReloadServer) throws MalformedURLException {
        String host = liveReloadServer.getHost();
        int port = liveReloadServer.getAttribute("org.jboss.tools.livereload.core.websocket_port", -1);
        IProject project = ProjectUtils.findProjectFromAbsolutePath((IPath)file);
        IPath location = new Path("/").append(project.getName()).append(file.makeRelativeTo(project.getLocation()));
        return new URL("http", host, port, location.toString());
    }

    private static URL computeURL(IServerModule appModule) throws MalformedURLException {
        LiveReloadProxyServer liveReloadProxyServer = WSTUtils.findLiveReloadProxyServer((IServer)appModule.getServer());
        if (liveReloadProxyServer == null) {
            return null;
        }
        int proxyPort = liveReloadProxyServer.getProxyPort();
        String host = liveReloadProxyServer.getProxyHost();
        URL url = new URL("http", host, proxyPort, "/" + appModule.getModule()[0].getName());
        return url;
    }
}

