/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.angularjs.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.jst.angularjs.AngularJsPlugin;
import org.jboss.tools.jst.angularjs.internal.AngularJSRecognizer;
import org.jboss.tools.jst.angularjs.internal.AngularMessages;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.IProposalProcessor;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.internal.BrowserDataProviderManager;

public class ExpressionsProposalProcessor
implements IProposalProcessor {
    private ImageDescriptor image;

    public TextProposal[] getProposals(KbQuery query, IPageContext context) {
        String value;
        ArrayList<TextProposal> proposals = new ArrayList<TextProposal>();
        String qValue = query.getValue();
        int startEl = qValue.lastIndexOf("{{");
        if (startEl < 0 && (qValue = query.getRegionValuePrefix()) != null) {
            startEl = qValue.lastIndexOf("{{");
        }
        if (startEl > -1 && !(value = qValue.substring(startEl + 2)).contains("\n") && !value.contains("}") && new AngularJSRecognizer().isUsed((ELContext)context)) {
            String js = this.generateJs(value, context);
            Collection results = BrowserDataProviderManager.getInstance().evaluate(js, context);
            if (!results.isEmpty()) {
                if (this.image == null) {
                    this.image = ImageDescriptor.createFromFile(AngularJsPlugin.class, (String)"angular.png");
                }
                for (Object object : results) {
                    if (object == BrowserDataProviderManager.DATA_LOADING) {
                        ReplacementString rs = ExpressionsProposalProcessor.getReplacementString(query, "", qValue, "");
                        TextProposal proposal = new TextProposal();
                        proposal.setLabel(AngularMessages.dataLoading);
                        proposal.setReplacementString(rs.string);
                        proposal.setPosition(rs.position);
                        proposal.setImageDescriptor(this.image);
                        proposal.setAutoActivationContentAssistantAfterApplication(true);
                        proposal.setRelevance(Integer.MAX_VALUE);
                        proposals.add(proposal);
                        continue;
                    }
                    String result = object.toString();
                    StringTokenizer st = new StringTokenizer(result, ";", false);
                    int dotIndex = value.lastIndexOf(46);
                    String remove = value;
                    if (dotIndex > -1) {
                        remove = value.substring(dotIndex + 1);
                    }
                    while (st.hasMoreElements()) {
                        String label = st.nextToken().trim();
                        if (label.matches("\\d+")) continue;
                        ReplacementString rs = ExpressionsProposalProcessor.getReplacementString(query, label, qValue, remove);
                        TextProposal proposal = new TextProposal();
                        proposal.setRelevance(1260);
                        proposal.setLabel(label);
                        proposal.setReplacementString(rs.string);
                        proposal.setPosition(rs.position);
                        proposal.setImageDescriptor(this.image);
                        proposal.setAutoActivationContentAssistantAfterApplication(false);
                        proposals.add(proposal);
                    }
                }
            }
        }
        return proposals.toArray(new TextProposal[proposals.size()]);
    }

    private static ReplacementString getReplacementString(KbQuery query, String label, String qValue, String remove) {
        String c;
        String suffix = query.getRegionValueSufix();
        if (suffix == null) {
            suffix = "";
        }
        StringBuilder replacementString = new StringBuilder();
        if (query.getType() == KbQuery.Type.ATTRIBUTE_VALUE) {
            replacementString.append(qValue);
        }
        replacementString.append(label.substring(remove.length()));
        int position = replacementString.length();
        if (query.getType() == KbQuery.Type.ATTRIBUTE_VALUE) {
            replacementString.append(suffix);
        }
        int close = suffix.indexOf("}}");
        boolean closedExp = false;
        if (close > -1 && !(c = suffix.substring(0, close)).contains("\n")) {
            closedExp = true;
        }
        if (!closedExp) {
            replacementString.append("}}");
        }
        ReplacementString rs = new ReplacementString();
        rs.string = replacementString.toString();
        rs.position = position;
        return rs;
    }

    private String generateJs(String value, IPageContext context) {
        String js = "var ORG_JBOSS_TOOLS_JST = {};ORG_JBOSS_TOOLS_JST.getProposals = function(element, value) {var result = '';if(typeof angular == \"object\") {var scope = angular.element(element).scope();var values = value.split(\".\");var parentObject = scope;for (var i = 0; i < values.length-1; i++) {parentObject = ORG_JBOSS_TOOLS_JST.getMemberObject(parentObject, values[i]);}if(parentObject) {result = ORG_JBOSS_TOOLS_JST.getProposalsForLastSegment(parentObject, values[values.length-1]);}}return result;};ORG_JBOSS_TOOLS_JST.getProposalsForLastSegment = function(member, nameMask) {var result = '';for (var p in member) {if ((p.indexOf('$') !== 0) && (p.lastIndexOf(nameMask, 0) === 0)) {result += p;if (typeof member[p] === \"function\") {var funStr = member[p].toString();var funArgsStr = funStr.slice(funStr.indexOf('(') + 1, funStr.indexOf(')'));result += '(' + funArgsStr + ')';}result += ';';}}return result;};ORG_JBOSS_TOOLS_JST.getMemberObject = function(parentObject, memberName) {var brIndex = memberName.indexOf('(');var name = memberName;if(brIndex>0) {name = memberName.slice(0, brIndex);}for(var propertyName in parentObject) {if(propertyName == name) {return parentObject[propertyName];}}};var element = document.querySelector(\"[#{idParamName}='#{idParamValue}']\");if(element) { return ORG_JBOSS_TOOLS_JST.getProposals(element, '" + value + "');" + "}" + "return \"\"";
        return js;
    }

    private static class ReplacementString {
        String string;
        int position;

        private ReplacementString() {
        }
    }
}

