/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.core.preferences;

import org.eclipse.angularjs.core.AngularCoreConstants;
import org.eclipse.angularjs.core.AngularCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import tern.eclipse.ide.core.preferences.PreferencesSupport;
import tern.utils.StringUtils;

public class AngularCorePreferencesSupport {
    private static final Preferences store = AngularCorePlugin.getDefault().getPluginPreferences();
    private PreferencesSupport preferencesSupport = new PreferencesSupport("org.eclipse.angularjs.core", store);
    private static AngularCorePreferencesSupport instance = null;

    private AngularCorePreferencesSupport() {
    }

    public static AngularCorePreferencesSupport getInstance() {
        if (instance == null) {
            instance = new AngularCorePreferencesSupport();
        }
        return instance;
    }

    public boolean isDirectiveUseOriginalName(IProject project) {
        return this.getBool(project, "directiveUseOriginalName");
    }

    public boolean isDirectiveStartsWithNothing(IProject project) {
        return this.getBool(project, AngularCoreConstants.DIRECTIVE_STARTS_WITH_NOTHING);
    }

    public boolean isDirectiveStartsWithX(IProject project) {
        return this.getBool(project, AngularCoreConstants.DIRECTIVE_STARTS_WITH_X);
    }

    public boolean isDirectiveStartsWithData(IProject project) {
        return this.getBool(project, AngularCoreConstants.DIRECTIVE_STARTS_WITH_DATA);
    }

    public boolean isDirectiveColonDelimiter(IProject project) {
        return this.getBool(project, AngularCoreConstants.DIRECTIVE_COLON_DELIMITER);
    }

    public boolean isDirectiveMinusDelimiter(IProject project) {
        return this.getBool(project, "directiveMinusDelimiter");
    }

    public boolean isDirectiveUnderscoreDelimiter(IProject project) {
        return this.getBool(project, "directiveUnderscoreDelimiter");
    }

    public boolean getBool(IProject project, String key) {
        String result = this.preferencesSupport.getPreferencesValue(key, null, project);
        return StringUtils.asBoolean((String)result, (boolean)false);
    }

    public IEclipsePreferences getEclipsePreferences(IProject project) {
        return this.preferencesSupport.getEclipsePreferences(project);
    }

    public String getStartSymbol(IProject project) {
        return this.preferencesSupport.getPreferencesValue("startSymbol", "{{", project);
    }

    public String getEndSymbol(IProject project) {
        return this.preferencesSupport.getPreferencesValue("endSymbol", "}}", project);
    }
}

