/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.core;

import org.eclipse.angularjs.core.BaseModel;
import org.eclipse.angularjs.core.IDefinitionAware;
import org.eclipse.angularjs.core.Module;
import tern.angular.AngularType;
import tern.angular.protocol.definition.TernAngularDefinitionQuery;
import tern.server.protocol.definition.ITernDefinitionCollector;

public class AngularElement
extends BaseModel
implements IDefinitionAware {
    private final AngularType angularType;
    private final Module module;

    public AngularElement(String name, AngularType angularType, Module module) {
        super(name, BaseModel.Type.AngularElement, module.getScriptPath());
        this.angularType = angularType;
        this.module = module;
    }

    public Module getModule() {
        return this.module;
    }

    @Override
    public void findDefinition(ITernDefinitionCollector collector) {
        TernAngularDefinitionQuery query = new TernAngularDefinitionQuery(this.angularType);
        query.getScope().setModule(this.getModule().getName());
        query.setExpression(super.getName());
        super.execute(query, collector);
    }

    public AngularType getAngularType() {
        return this.angularType;
    }
}

