/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.ui.hyperlink;

import org.eclipse.angularjs.core.AngularProject;
import org.eclipse.angularjs.core.utils.AngularDOMUtils;
import org.eclipse.angularjs.core.utils.AngularELRegion;
import org.eclipse.angularjs.core.utils.AngularRegionUtils;
import org.eclipse.angularjs.core.utils.AngularScopeHelper;
import org.eclipse.angularjs.core.utils.DOMUtils;
import org.eclipse.angularjs.core.utils.HyperlinkUtils;
import org.eclipse.angularjs.internal.ui.AngularELWordFinder;
import org.eclipse.angularjs.internal.ui.Trace;
import org.eclipse.angularjs.internal.ui.hyperlink.HTMLAngularHyperLink;
import org.eclipse.angularjs.internal.ui.utils.DOMUIUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import tern.angular.AngularType;
import tern.angular.modules.Directive;
import tern.eclipse.ide.core.IIDETernProject;

public class HTMLAngularHyperLinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        IDOMNode currentNode = DOMUtils.getNodeByOffset((IDocument)document, (int)region.getOffset());
        if (currentNode == null) {
            return null;
        }
        IFile file = DOMUtils.getFile((IDOMNode)currentNode);
        IProject project = file.getProject();
        Object hyperlink = null;
        if (AngularProject.hasAngularNature((IProject)project)) {
            try {
                IStructuredDocumentRegion documentRegion = DOMUIUtils.getStructuredDocumentRegion(textViewer, region.getOffset());
                IIDETernProject ternProject = AngularProject.getTernProject((IProject)project);
                String startSymbol = "{{";
                String endSymbol = "}}";
                try {
                    AngularProject angularProject = AngularProject.getAngularProject((IProject)project);
                    startSymbol = angularProject.getStartSymbol();
                    endSymbol = angularProject.getEndSymbol();
                }
                catch (CoreException coreException) {}
                switch (currentNode.getNodeType()) {
                    case 3: {
                        hyperlink = this.createHyperlinkForExpression(documentRegion.getType(), documentRegion.getText(), documentRegion.getStartOffset(), region.getOffset(), currentNode, document, ternProject, file, startSymbol, endSymbol);
                        return this.createHyperlinks((IHyperlink)hyperlink);
                    }
                    case 1: {
                        boolean isAttrValue;
                        IDOMAttr attr = DOMUtils.getAttrByOffset((Node)currentNode, (int)region.getOffset());
                        IDOMAttr node = attr != null ? attr : currentNode;
                        Directive directive = AngularDOMUtils.getAngularDirective((IProject)project, (Node)node);
                        if (directive != null) {
                            Integer end = null;
                            if (attr != null) {
                                boolean isAttrValue2;
                                boolean bl = isAttrValue2 = region.getOffset() > attr.getNameRegionEndOffset();
                                if (isAttrValue2) {
                                    IRegion valueRegion = AngularELWordFinder.findWord(document, region.getOffset(), startSymbol, endSymbol);
                                    end = region.getOffset() - attr.getValueRegionStartOffset() - 1;
                                    hyperlink = new HTMLAngularHyperLink(attr.getOwnerElement(), valueRegion, file, textViewer.getDocument(), ternProject, AngularScopeHelper.getAngularValue((IDOMAttr)attr, (AngularType)directive.getType()), end, directive.getType());
                                    break;
                                }
                                if (directive.isCustom()) {
                                    hyperlink = new HTMLAngularHyperLink(attr.getOwnerElement(), HyperlinkUtils.getNameRegion((IDOMAttr)attr), file, textViewer.getDocument(), ternProject, directive.getName(), end, AngularType.directive);
                                }
                            } else if (directive.isCustom()) {
                                IDOMElement element = (IDOMElement)node;
                                hyperlink = new HTMLAngularHyperLink((Node)element, HyperlinkUtils.getElementRegion((IDOMElement)element), file, textViewer.getDocument(), ternProject, directive.getName(), end, AngularType.directive);
                            }
                            break;
                        }
                        if (attr == null) break;
                        boolean bl = isAttrValue = region.getOffset() > attr.getNameRegionEndOffset();
                        if (!isAttrValue) break;
                        hyperlink = this.createHyperlinkForExpression("XML_TAG_ATTRIBUTE_VALUE", attr.getValue(), attr.getValueRegionStartOffset() + 1, region.getOffset(), (IDOMNode)attr.getOwnerElement(), document, ternProject, file, startSymbol, endSymbol);
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (CoreException e) {
                Trace.trace((byte)2, "Error while Angular hyperlink", e);
            }
        }
        return this.createHyperlinks((IHyperlink)hyperlink);
    }

    private IHyperlink createHyperlinkForExpression(String regionType, String regionText, int regionStartOffset, int documentPosition, IDOMNode node, IDocument document, IIDETernProject ternProject, IFile file, String startSymbol, String endSymbol) {
        AngularELRegion angularRegion = AngularRegionUtils.getAngularELRegion((String)regionType, (String)regionText, (int)regionStartOffset, (int)documentPosition, (IProject)file.getProject());
        if (angularRegion != null) {
            String expression = angularRegion.getExpression();
            int expressionOffset = angularRegion.getExpressionOffset();
            return new HTMLAngularHyperLink((Node)node, AngularELWordFinder.findWord(document, documentPosition, startSymbol, endSymbol), file, document, ternProject, expression, expressionOffset, AngularType.model);
        }
        return null;
    }

    private IHyperlink[] createHyperlinks(IHyperlink hyperlink) {
        if (hyperlink != null) {
            IHyperlink[] hyperlinks = new IHyperlink[]{hyperlink};
            return hyperlinks;
        }
        return null;
    }
}

