/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.legacyconversion;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.springsource.ide.eclipse.commons.frameworks.core.FrameworkCoreActivator;
import org.springsource.ide.eclipse.commons.frameworks.core.legacyconversion.IConversionConstants;

public class ListMessageDialog
extends MessageDialogWithToggle
implements IConversionConstants {
    private static final IPreferenceStore PREFERENCE_STORE = FrameworkCoreActivator.getDefault().getPreferenceStore();
    private static final String PREFERENCE_QUESTION = "Don't show this dialog again.";
    private static final String TITLE = "Should convert legacy STS projects?";
    private final IProject[] legacyProjects;
    private IProject[] checkedLegacyProjects;
    private CheckboxTableViewer viewer;

    public static IProject[] openViewer(Shell shell, IProject[] legacyProjects) {
        ListMessageDialog dialog = new ListMessageDialog(shell, legacyProjects);
        int res = dialog.open();
        PREFERENCE_STORE.setValue("org.springsource.ide.eclipse.commons.frameworks.ui.legacyconversion.autocheck", !dialog.getToggleState());
        if (res == 2) {
            return dialog.getAllChecked();
        }
        return null;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2) {
            Object[] checkedElements = this.viewer.getCheckedElements();
            this.checkedLegacyProjects = new IProject[checkedElements.length];
            System.arraycopy(checkedElements, 0, this.checkedLegacyProjects, 0, checkedElements.length);
            PREFERENCE_STORE.setValue("org.springsource.ide.eclipse.commons.frameworks.ui.legacyconversion.done", true);
        }
        super.buttonPressed(buttonId);
    }

    protected boolean isResizable() {
        return true;
    }

    public ListMessageDialog(Shell shell, IProject[] legacyProjects) {
        super(shell, TITLE, null, ListMessageDialog.createMessage(legacyProjects), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, PREFERENCE_QUESTION, PREFERENCE_STORE.getBoolean("org.springsource.ide.eclipse.commons.frameworks.ui.legacyconversion.autocheck"));
        this.legacyProjects = legacyProjects;
    }

    protected Control createCustomArea(Composite parent) {
        ((GridLayout)parent.getLayout()).numColumns = 2;
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        gd.verticalSpan = 2;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setInput((Object)this.legacyProjects);
        this.viewer.setAllChecked(true);
        ListMessageDialog.applyDialogFont((Control)this.viewer.getControl());
        this.createButton(parent, "Select all", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListMessageDialog.this.viewer.setAllChecked(true);
            }
        });
        this.createButton(parent, "Select none", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListMessageDialog.this.viewer.setAllChecked(false);
            }
        });
        return this.viewer.getControl();
    }

    protected Button createButton(Composite parent, String label, SelectionListener listener) {
        return this.createButton(parent, label, 8, listener);
    }

    protected Button createButton(Composite parent, String label, int style, SelectionListener listener) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        button.addSelectionListener(listener);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.verticalAlignment = 1;
        gd.widthHint = 100;
        button.setLayoutData((Object)gd);
        return button;
    }

    IProject[] getAllChecked() {
        return this.checkedLegacyProjects;
    }

    private static String createMessage(IProject[] allLegacyProjects) {
        StringBuilder sb = new StringBuilder();
        if (allLegacyProjects.length > 1) {
            sb.append("The following legacy STS projects have been found:\n");
        } else {
            sb.append("The following legacy STS project has been found:\n");
        }
        if (allLegacyProjects.length > 1) {
            sb.append("\n** These projects may not compile until they are upgraded to STS 3.0. **\n\n");
        } else {
            sb.append("\n** This project may not compile until it is upgraded to STS 3.0. **\n\n");
        }
        sb.append("Do you want to upgrade now?\nYou can choose to upgrade later by going to:\nProject -> Configure -> Convert legacy STS projects...");
        return sb.toString();
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IProject[]) {
                return (IProject[])inputElement;
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer2, Object oldInput, Object newInput) {
        }
    }
}

