/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.dashboard.internal.ui;

import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.springsource.ide.eclipse.commons.core.ResourceProvider;
import org.springsource.ide.eclipse.commons.frameworks.core.util.Gtk3Check;
import org.springsource.ide.eclipse.dashboard.internal.ui.IIdeUiConstants;
import org.springsource.ide.eclipse.dashboard.ui.actions.ShowDashboardAction;

public class IdeUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.springsource.ide.eclipse.dashboard.ui";
    private static IdeUiPlugin plugin;
    public static final Version JAVAFX_MINIMUM_ECLIPSE_VERSION;
    public static final Version JAVAFX_MINIMUM_JRE_VERSION;

    static {
        JAVAFX_MINIMUM_ECLIPSE_VERSION = new Version("4.3");
        JAVAFX_MINIMUM_JRE_VERSION = new Version("1.7");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.migrateBlogFeeds();
        UIJob startupJob = new UIJob("Spring Tool Suite Initialization"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window != null) {
                            IEditorReference[] references;
                            IEditorReference[] iEditorReferenceArray = references = window.getActivePage().getEditorReferences();
                            int n = references.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IEditorReference reference = iEditorReferenceArray[n2];
                                if ("org.springsource.ide.eclipse.dashboard.ui.dashboard.elementFactory".equals(reference.getFactoryId())) {
                                    return;
                                }
                                ++n2;
                            }
                            if (IdeUiPlugin.this.getPreferenceStore().getBoolean("org.springsource.ide.eclipse.dashboard.uidashboard.startup")) {
                                if (window.getWorkbench().getIntroManager().getIntro() != null) {
                                    return;
                                }
                                ShowDashboardAction showDashboard = new ShowDashboardAction();
                                showDashboard.init(window);
                                showDashboard.run(null);
                                return;
                            }
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        startupJob.setSystem(true);
        startupJob.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("org.springsource.ide.eclipse.dashboard.uidashboard.startup", true);
        store.setDefault("org.springsource.ide.eclipse.dashboard.uidashboard.use.old", IIdeUiConstants.DEFAULT_PREF_USE_OLD_DASHOARD);
        store.setDefault("dashboard.feed.springio.migration", false);
        store.setDefault("org.springsource.ide.eclipse.dashboard.uidashboard.news.update", true);
    }

    public static IdeUiPlugin getDefault() {
        return plugin;
    }

    public static Image getImage(String path) {
        ImageRegistry imageRegistry = IdeUiPlugin.getDefault().getImageRegistry();
        Image image = imageRegistry.get(path);
        if (image == null) {
            if (path.startsWith("http")) {
                try {
                    ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(path));
                    if (imageDescriptor == null) {
                        imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
                    }
                    image = imageDescriptor.createImage(true);
                    imageRegistry.put(path, image);
                }
                catch (Exception exception) {
                    ImageDescriptor imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
                    image = imageDescriptor.createImage(true);
                    imageRegistry.put(path, image);
                }
            } else {
                ImageDescriptor imageDescriptor = IdeUiPlugin.getImageDescriptor(path);
                if (imageDescriptor == null) {
                    imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
                }
                image = imageDescriptor.createImage(true);
                imageRegistry.put(path, image);
            }
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return IdeUiPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)("icons/" + path));
    }

    public static void log(IStatus status) {
        IdeUiPlugin.getDefault().getLog().log(status);
    }

    public static void log(IStatus status, boolean informUser) {
        IdeUiPlugin.getDefault().getLog().log(status);
        if (informUser) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)status.getMessage());
        }
    }

    public static void log(Throwable e) {
        IdeUiPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Unexpected exception", e));
    }

    public boolean supportsNewDashboard(IProgressMonitor mon) {
        boolean jreCompatible;
        Version eclipseVersion = new Version((String)Platform.getBundle((String)"org.eclipse.platform").getHeaders().get("Bundle-Version"));
        boolean eclipseCompatible = eclipseVersion.compareTo(JAVAFX_MINIMUM_ECLIPSE_VERSION) >= 0;
        String javaVersionString = System.getProperty("java.version");
        String[] majorMinorQualifier = StringUtils.split((String)javaVersionString, (String)".");
        Version jreVersion = new Version(Integer.parseInt(majorMinorQualifier[0]), Integer.parseInt(majorMinorQualifier[1]), 0);
        boolean bl = jreCompatible = jreVersion.compareTo(JAVAFX_MINIMUM_JRE_VERSION) >= 0;
        return eclipseCompatible && jreCompatible;
    }

    public boolean useNewDashboard(IProgressMonitor mon) {
        return this.supportsNewDashboard(mon) && !IdeUiPlugin.getDefault().getPreferenceStore().getBoolean("org.springsource.ide.eclipse.dashboard.uidashboard.use.old") && !Gtk3Check.isGTK3;
    }

    private void migrateBlogFeeds() {
        IPreferenceStore prefStore = this.getPreferenceStore();
        if (!prefStore.getBoolean("dashboard.feed.springio.migration")) {
            ResourceProvider provider = ResourceProvider.getInstance();
            ResourceProvider.Property feedsProp = provider.getProperty("dashboard.feeds.blogs");
            if (feedsProp != null) {
                String value = feedsProp.getValue();
                if (value.contains("http://www.springframework.org/node/feed/")) {
                    value = value.replace("http://www.springframework.org/node/feed/", " ");
                }
                if (value.contains("http://blog.springsource.com/main/feed/")) {
                    value = value.replace("http://blog.springsource.com/main/feed/", " ");
                }
                if (!value.contains("https://spring.io/blog.atom")) {
                    value = value.concat("\nhttps://spring.io/blog.atom");
                }
                value = value.trim();
                feedsProp.setValue(value);
            }
            prefStore.setValue("dashboard.feed.springio.migration", true);
        }
    }
}

