/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.IImportedBeansConfig;
import org.springframework.ide.eclipse.beans.ui.editor.Activator;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.IClassNameProvider;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.IReferenceableElementsLocator;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.ui.editors.ZipEntryEditorInput;
import org.springframework.util.StringUtils;
import org.springsource.ide.eclipse.commons.ui.SpringUIUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansEditorUtils {
    protected static final String AMPERSTAND = "&";
    protected static final String AMPERSTAND_ENTITY = "&&;";
    protected static final String CARRIAGE_RETURN = "\r";
    protected static final String CARRIAGE_RETURN_ENTITY = "\\r";
    protected static final String CR = "\r";
    protected static final String CRLF = "\r\n";
    protected static final String DELIMITERS = " \t\n\r\f";
    protected static final String DOUBLE_QUOTE = "\"";
    protected static final char DOUBLE_QUOTE_CHAR = '\"';
    protected static final String DOUBLE_QUOTE_ENTITY = "&quot;";
    protected static final String EQUAL_SIGN = "=";
    protected static final String EQUAL_SIGN_ENTITY = "&#61;";
    protected static final String GREATER_THAN = ">";
    protected static final String GREATER_THAN_ENTITY = "&gt;";
    protected static final String LESS_THAN = "<";
    protected static final String LESS_THAN_ENTITY = "&lt;";
    protected static final String LF = "\n";
    protected static final String LINE_FEED = "\n";
    protected static final String LINE_FEED_ENTITY = "\\n";
    protected static final String LINE_FEED_TAG = "<dl>";
    protected static final String LINE_TAB = "\t";
    protected static final String LINE_TAB_ENTITY = "\\t";
    protected static final String LINE_TAB_TAG = "<dd>";
    protected static final String SINGLE_QUOTE = "'";
    protected static final char SINGLE_QUOTE_CHAR = '\'';
    protected static final String SINGLE_QUOTE_ENTITY = "&#039;";
    protected static final String SPACE = " ";
    protected static final String SPACE_ENTITY = "&nbsp;";

    public static String attributeNameToPropertyName(String attributeName) {
        if (attributeName.indexOf("-") == -1) {
            return attributeName;
        }
        char[] chars = attributeName.toCharArray();
        char[] result = new char[chars.length - 1];
        int currPos = 0;
        boolean upperCaseNext = false;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '-') {
                upperCaseNext = true;
            } else if (upperCaseNext) {
                result[currPos++] = Character.toUpperCase(c);
                upperCaseNext = false;
            } else {
                result[currPos++] = c;
            }
            ++n2;
        }
        return new String(result, 0, currPos);
    }

    public static String convertToHTMLContent(String content) {
        content = BeansEditorUtils.replace(content, AMPERSTAND, AMPERSTAND_ENTITY);
        content = BeansEditorUtils.replace(content, LESS_THAN, LESS_THAN_ENTITY);
        content = BeansEditorUtils.replace(content, GREATER_THAN, GREATER_THAN_ENTITY);
        content = BeansEditorUtils.replace(content, "\n", LINE_FEED_TAG);
        content = BeansEditorUtils.replace(content, LINE_TAB, LINE_TAB_TAG);
        content = BeansEditorUtils.replace(content, SINGLE_QUOTE, SINGLE_QUOTE_ENTITY);
        content = BeansEditorUtils.replace(content, DOUBLE_QUOTE, DOUBLE_QUOTE_ENTITY);
        content = BeansEditorUtils.replace(content, "  ", "&nbsp;&nbsp;");
        return content;
    }

    public static final String createAdditionalProposalInfo(IBean bean) {
        StringBuffer buf = new StringBuffer();
        buf.append("<b>id:</b> ");
        buf.append(bean.getElementName());
        if (bean.getAliases() != null && bean.getAliases().length > 0) {
            buf.append("<br><b>alias:</b> ");
            int i = 0;
            while (i < bean.getAliases().length) {
                buf.append(bean.getAliases()[i]);
                if (i < bean.getAliases().length - 1) {
                    buf.append(", ");
                }
                ++i;
            }
        }
        buf.append("<br><b>class:</b> ");
        buf.append(bean.getClassName());
        buf.append("<br><b>singleton:</b> ");
        buf.append(bean.isSingleton());
        buf.append("<br><b>abstract:</b> ");
        buf.append(bean.isAbstract());
        buf.append("<br><b>lazy-init:</b> ");
        buf.append(bean.isLazyInit());
        buf.append("<br><b>filename:</b> ");
        buf.append(bean.getElementResource().getProjectRelativePath());
        return buf.toString();
    }

    public static final String createAdditionalProposalInfo(Node bean, IFile file) {
        NamedNodeMap attributes = bean.getAttributes();
        StringBuffer buf = new StringBuffer();
        buf.append("<b>id:</b> ");
        if (attributes.getNamedItem("id") != null) {
            buf.append(attributes.getNamedItem("id").getNodeValue());
        }
        if (attributes.getNamedItem("name") != null) {
            buf.append("<br><b>alias:</b> ");
            buf.append(attributes.getNamedItem("name").getNodeValue());
        }
        buf.append("<br><b>class:</b> ");
        if (attributes.getNamedItem("class") != null) {
            buf.append(attributes.getNamedItem("class").getNodeValue());
        }
        buf.append("<br><b>singleton:</b> ");
        if (attributes.getNamedItem("singleton") != null) {
            buf.append(attributes.getNamedItem("singleton").getNodeValue());
        } else {
            buf.append("true");
        }
        buf.append("<br><b>abstract:</b> ");
        if (attributes.getNamedItem("abstract") != null) {
            buf.append(attributes.getNamedItem("abstract").getNodeValue());
        } else {
            buf.append("false");
        }
        buf.append("<br><b>lazy-init:</b> ");
        if (attributes.getNamedItem("lazy-init") != null) {
            buf.append(attributes.getNamedItem("lazy-init").getNodeValue());
        } else {
            buf.append("default");
        }
        if (file != null) {
            buf.append("<br><b>filename:</b> ");
            buf.append(file.getProjectRelativePath());
        }
        return buf.toString();
    }

    public static final String createAdditionalProposalInfo(Object obj, IProgressMonitor monitor) {
        if (obj instanceof IBean) {
            return BeansEditorUtils.createAdditionalProposalInfo((IBean)obj);
        }
        if (obj instanceof ElementImpl) {
            ElementImpl node = (ElementImpl)obj;
            IStructuredDocument document = node.getStructuredDocument();
            IFile resource = BeansEditorUtils.getFile((IDocument)document);
            return BeansEditorUtils.createAdditionalProposalInfo((Node)obj, resource);
        }
        if (obj instanceof IMember) {
            return new ProposalInfo((IMember)obj).getInfo(monitor);
        }
        return null;
    }

    public static final void extractAllMethodsFromPropertyPathElements(List propertyPath, List types, IFile file, int counter, List<IMethod> methods) {
        block6: {
            IMethod method;
            block7: {
                method = null;
                if (propertyPath == null || propertyPath.size() <= 0) break block6;
                if (propertyPath.size() <= counter + 1) break block7;
                if (types == null) break block6;
                IType returnType = null;
                int i = 0;
                while (i < types.size()) {
                    IType type = (IType)types.get(i);
                    try {
                        IMethod getMethod = Introspector.getReadableProperty((IType)type, (String)((String)propertyPath.get(counter)));
                        returnType = JdtUtils.getJavaTypeForMethodReturnType((IMethod)getMethod, (IType)type);
                        methods.add(getMethod);
                    }
                    catch (JavaModelException javaModelException) {}
                    ++i;
                }
                if (returnType == null) break block6;
                ArrayList<IType> newTypes = new ArrayList<IType>();
                newTypes.add(returnType);
                BeansEditorUtils.extractAllMethodsFromPropertyPathElements(propertyPath, newTypes, file, counter + 1, methods);
                break block6;
            }
            int i = 0;
            while (i < types.size()) {
                IType type = (IType)types.get(i);
                try {
                    method = Introspector.getWritableProperty((IType)type, (String)((String)propertyPath.get(counter)));
                    methods.add(method);
                }
                catch (JavaModelException javaModelException) {}
                ++i;
            }
        }
    }

    public static final IMethod extractMethodFromPropertyPathElements(List propertyPathElements, List types, IFile file, int counter) {
        IMethod method;
        block6: {
            block7: {
                method = null;
                if (propertyPathElements == null || propertyPathElements.size() <= 0) break block6;
                if (propertyPathElements.size() <= counter + 1) break block7;
                if (types == null) break block6;
                IType returnType = null;
                int i = 0;
                while (i < types.size()) {
                    IType type = (IType)types.get(i);
                    String propertyPath = (String)propertyPathElements.get(counter);
                    try {
                        IMethod getMethod = Introspector.getReadableProperty((IType)type, (String)PropertyAccessorUtils.getPropertyName((String)propertyPath));
                        returnType = JdtUtils.getJavaTypeForMethodReturnType((IMethod)getMethod, (IType)type);
                    }
                    catch (JavaModelException javaModelException) {}
                    ++i;
                }
                if (returnType == null) break block6;
                ArrayList<IType> newTypes = new ArrayList<IType>();
                newTypes.add(returnType);
                method = BeansEditorUtils.extractMethodFromPropertyPathElements(propertyPathElements, newTypes, file, counter + 1);
                break block6;
            }
            int i = 0;
            while (i < types.size()) {
                IType type = (IType)types.get(i);
                String propertyPath = (String)propertyPathElements.get(counter);
                try {
                    method = Introspector.getWritableProperty((IType)type, (String)PropertyAccessorUtils.getPropertyName((String)propertyPath));
                }
                catch (JavaModelException javaModelException) {}
                ++i;
            }
        }
        return method;
    }

    public static final IRegion extractPropertyPathFromCursorPosition(IRegion hyperlinkRegion, IRegion cursor, String target, List<String> propertyPaths) {
        String preTarget;
        int cursorIndexInTarget = cursor.getOffset() - hyperlinkRegion.getOffset();
        if (cursorIndexInTarget > 0 && cursorIndexInTarget < target.length() && !(preTarget = target.substring(0, cursorIndexInTarget)).endsWith(".")) {
            int regionOffset = hyperlinkRegion.getOffset() + preTarget.lastIndexOf(".") + 1;
            int segmentCount = new StringTokenizer(preTarget, ".").countTokens();
            StringTokenizer tok = new StringTokenizer(target, ".");
            int i = 0;
            while (i < segmentCount) {
                propertyPaths.add(tok.nextToken());
                ++i;
            }
            int regionLength = propertyPaths.get(segmentCount - 1).length();
            return new Region(regionOffset, regionLength);
        }
        return hyperlinkRegion;
    }

    public static final Attr getAttrByOffset(Node node, int offset) {
        if (node instanceof IndexedRegion && ((IndexedRegion)node).contains(offset) && node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                IndexedRegion attRegion = (IndexedRegion)attrs.item(i);
                if (attRegion.contains(offset)) {
                    return (Attr)attrs.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static final boolean isElementAtOffset(Node node, int offset) {
        IndexedRegion region = (IndexedRegion)node;
        int nameLength = node.getNodeName().length();
        return region.getStartOffset() + nameLength >= offset && region.getStartOffset() <= offset;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IndexedRegion getNodeAt(ITextViewer viewer, int documentOffset) {
        if (viewer == null) {
            return null;
        }
        IndexedRegion node = null;
        IModelManager mm = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        if (mm != null) {
            model = mm.getExistingModelForRead(viewer.getDocument());
        }
        try {
            block9: {
                int lastOffset;
                block8: {
                    if (model == null) return node;
                    lastOffset = documentOffset;
                    node = model.getIndexedRegion(documentOffset);
                    if (!true) break block8;
                    if (node != null) return node;
                    if (lastOffset < 0) break block9;
                }
                do {
                    node = model.getIndexedRegion(--lastOffset);
                    if (node != null) return node;
                } while (lastOffset >= 0);
            }
            return node;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public static final String getAttribute(Node node, String attributeName) {
        if (BeansEditorUtils.hasAttribute(node, attributeName)) {
            return node.getAttributes().getNamedItem(attributeName).getNodeValue();
        }
        return null;
    }

    public static final Set<IBean> getBeansFromConfigSets(IFile file) {
        HashSet<IBean> beans = new HashSet<IBean>();
        HashSet<IBeansConfig> configs = new HashSet<IBeansConfig>();
        if (file != null && file.exists()) {
            IBeansProject project = BeansCorePlugin.getModel().getProject(file.getProject());
            Set allConfigs = BeansCorePlugin.getModel().getConfigs(file, true);
            for (IBeansConfig config : allConfigs) {
                if (!(config instanceof IImportedBeansConfig)) continue;
                IBeansConfig rootBeansConfig = (IBeansConfig)BeansModelUtils.getParentOfClass((IModelElement)config, IBeansConfig.class);
                configs.add(rootBeansConfig);
            }
            if (project != null) {
                Set configSets = project.getConfigSets();
                for (IBeansConfigSet configSet : configSets) {
                    if (configSet.hasConfig(file) || !BeansCoreUtils.isBeansConfig((IResource)file)) {
                        Set bcs = configSet.getConfigs();
                        configs.addAll(bcs);
                    }
                    HashSet tempConfigs = new HashSet(configs);
                    for (IBeansConfig config : tempConfigs) {
                        if (!configSet.hasConfig(config.getElementName())) continue;
                        Set bcs = configSet.getConfigs();
                        configs.addAll(bcs);
                    }
                }
            }
            if (BeansCoreUtils.isBeansConfig((IResource)file, (boolean)true)) {
                IBeansConfig config;
                config = BeansCorePlugin.getModel().getConfig(file);
                if (config instanceof IImportedBeansConfig) {
                    configs.add((IBeansConfig)BeansModelUtils.getParentOfClass((IModelElement)config, IBeansConfig.class));
                } else {
                    configs.add(config);
                }
            }
            for (IBeansConfig bc : configs) {
                Set bs = bc.getBeans();
                for (IBean b : bs) {
                    if (b.getElementResource().equals((Object)file)) continue;
                    beans.add(b);
                }
                Set components = bc.getComponents();
                for (IBeansComponent component : components) {
                    BeansEditorUtils.getBeansFromComponent(file, component, beans);
                }
            }
        }
        return beans;
    }

    private static void getBeansFromComponent(IFile file, IBeansComponent component, Set<IBean> beansAcc) {
        Set bs = component.getBeans();
        for (IBean b : bs) {
            if (b.getElementResource().equals((Object)file)) continue;
            beansAcc.add(b);
        }
        Set childComponents = component.getComponents();
        for (IBeansComponent childComponent : childComponents) {
            BeansEditorUtils.getBeansFromComponent(file, childComponent, beansAcc);
        }
    }

    public static final String getClassNameForBean(IFile file, Document document, Node node) {
        String parent;
        String factoryBean;
        NamedNodeMap attributes = node.getAttributes();
        String className = attributes.getNamedItem("class") != null ? attributes.getNamedItem("class").getNodeValue() : null;
        String factoryMethod = attributes.getNamedItem("factory-method") != null ? attributes.getNamedItem("factory-method").getNodeValue() : null;
        String string = factoryBean = attributes.getNamedItem("factory-bean") != null ? attributes.getNamedItem("factory-bean").getNodeValue() : null;
        if (!StringUtils.hasText((String)factoryBean)) {
            factoryBean = attributes.getNamedItem("factory-ref") != null ? attributes.getNamedItem("factory-ref").getNodeValue() : null;
        }
        String string2 = parent = attributes.getNamedItem("parent") != null ? attributes.getNamedItem("parent").getNodeValue() : null;
        if (factoryBean == null && factoryMethod == null && parent == null) {
            return className;
        }
        if (className != null && factoryMethod != null && factoryBean == null && file != null) {
            return BeansEditorUtils.resolveClassNameFromFactoryMethod(factoryMethod, className, file.getProject());
        }
        if (factoryMethod != null && factoryBean != null && file != null) {
            String factoryClass = BeansEditorUtils.getClassNameForBean(file, document, factoryBean);
            if (factoryClass != null && file != null) {
                return BeansEditorUtils.resolveClassNameFromFactoryMethod(factoryMethod, factoryClass, file.getProject());
            }
            return null;
        }
        if (className == null && parent != null) {
            return BeansEditorUtils.getClassNameForBean(file, document, parent);
        }
        if (className != null) {
            return className;
        }
        return null;
    }

    public static final String getClassNameForBean(IFile file, Document document, String id) {
        Element node;
        boolean foundLocal = false;
        NodeList beanNodes = document.getElementsByTagNameNS("http://www.springframework.org/schema/beans", "bean");
        int i = 0;
        while (i < beanNodes.getLength()) {
            Node beanNode = beanNodes.item(i);
            NamedNodeMap attributes = beanNode.getAttributes();
            if (attributes.getNamedItem("id") != null) {
                String idTemp;
                String string = idTemp = attributes.getNamedItem("id") != null ? attributes.getNamedItem("id").getNodeValue() : null;
                if (id != null && id.equals(idTemp)) {
                    return BeansEditorUtils.getClassNameForBean(file, document, beanNode);
                }
            }
            ++i;
        }
        if (!foundLocal) {
            Set<IBean> beansList = BeansEditorUtils.getBeansFromConfigSets(file);
            for (IBean bean : beansList) {
                if (id == null || !id.equals(bean.getElementName())) continue;
                return BeansModelUtils.getBeanClass((IBean)bean, null);
            }
        }
        if ((node = document.getElementById(id)) != null && node.getNamespaceURI() != null && NamespaceUtils.getClassNameProvider(node.getNamespaceURI()).length > 0) {
            IClassNameProvider[] iClassNameProviderArray = NamespaceUtils.getClassNameProvider(node.getNamespaceURI());
            int n = iClassNameProviderArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClassNameProvider provider = iClassNameProviderArray[n2];
                String className = provider.getClassNameForElement(node);
                if (className != null) {
                    return className;
                }
                ++n2;
            }
        }
        return null;
    }

    public static String getClassNameForBean(Node bean) {
        return BeansEditorUtils.getAttribute(bean, "class");
    }

    public static final List<IType> getClassNamesOfBean(IFile file, Node node) {
        String id;
        ArrayList<IType> classNames = new ArrayList<IType>();
        NamedNodeMap rootAttributes = node.getAttributes();
        String string = id = rootAttributes.getNamedItem("id") != null ? rootAttributes.getNamedItem("id").getNodeValue() : null;
        if (id == null) {
            id = node.toString();
        }
        String className = rootAttributes.getNamedItem("class") != null ? rootAttributes.getNamedItem("class").getNodeValue() : null;
        String parentId = rootAttributes.getNamedItem("parent") != null ? rootAttributes.getNamedItem("parent").getNodeValue() : null;
        BeansEditorUtils.getClassNamesOfBeans(file, node.getOwnerDocument(), id, className, parentId, classNames, new ArrayList<String>());
        return classNames;
    }

    private static final void getClassNamesOfBeans(IFile file, Document document, String id, String className, String parentId, List<IType> classNames, List<String> beans) {
        IType type;
        if (id != null) {
            if (beans.contains(id)) {
                return;
            }
        } else {
            return;
        }
        beans.add(id);
        if (className != null && file != null && (type = JdtUtils.getJavaType((IProject)file.getProject(), (String)className)) != null && !classNames.contains(type)) {
            classNames.add(type);
        }
        if (parentId != null) {
            boolean foundLocal = false;
            NodeList beanNodes = document.getElementsByTagName("bean");
            int i = 0;
            while (i < beanNodes.getLength()) {
                Node beanNode = beanNodes.item(i);
                NamedNodeMap attributes = beanNode.getAttributes();
                if (attributes.getNamedItem("id") != null) {
                    String parentIdTemp;
                    String idTemp = attributes.getNamedItem("id") != null ? attributes.getNamedItem("id").getNodeValue() : null;
                    String classNameTemp = attributes.getNamedItem("class") != null ? attributes.getNamedItem("class").getNodeValue() : null;
                    String string = parentIdTemp = attributes.getNamedItem("parent") != null ? attributes.getNamedItem("parent").getNodeValue() : null;
                    if (parentId.equals(idTemp)) {
                        foundLocal = true;
                        BeansEditorUtils.getClassNamesOfBeans(file, document, idTemp, classNameTemp, parentIdTemp, classNames, beans);
                    }
                }
                ++i;
            }
            if (!foundLocal) {
                Set<IBean> beansList = BeansEditorUtils.getBeansFromConfigSets(file);
                for (IBean bean : beansList) {
                    if (!parentId.equals(bean.getElementName())) continue;
                    BeansEditorUtils.getClassNamesOfBeans(file, document, bean.getElementName(), BeansModelUtils.getBeanClass((IBean)bean, null), bean.getParentName(), classNames, beans);
                    break;
                }
            }
        }
    }

    public static IFile getFile(ContentAssistRequest request) {
        IStructuredDocumentRegion region;
        IFile resource = null;
        String baselocation = null;
        if (request != null && (region = request.getDocumentRegion()) != null) {
            IStructuredDocument document = region.getParentDocument();
            IStructuredModel model = null;
            try {
                model = StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)document);
                if (model != null) {
                    baselocation = model.getBaseLocation();
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        if (baselocation != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path filePath = new Path(baselocation);
            if (filePath.segmentCount() > 0) {
                resource = root.getFile((IPath)filePath);
            }
        }
        return resource;
    }

    public static final IFile getFile(IDocument document) {
        IFile resource = null;
        String baselocation = null;
        if (document != null) {
            IStructuredModel model = null;
            try {
                model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                if (model != null) {
                    baselocation = model.getBaseLocation();
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (baselocation != null) {
            Path path = new Path(baselocation);
            if (root.exists((IPath)path) && path.segmentCount() > 1) {
                resource = root.getFile((IPath)path);
            } else {
                IEditorPart editor = SpringUIUtils.getActiveEditor();
                IEditorInput input = editor.getEditorInput();
                if (input instanceof IFileEditorInput) {
                    resource = ((IFileEditorInput)input).getFile();
                } else if (input instanceof ZipEntryEditorInput) {
                    resource = (IFile)((ZipEntryEditorInput)input).getAdapter(IFile.class);
                } else if (input instanceof JarEntryEditorInput) {
                    JarEntryFile jarFile = (JarEntryFile)((JarEntryEditorInput)input).getStorage();
                    IPackageFragmentRoot jarPackageFragmentRoot = jarFile.getPackageFragmentRoot();
                    resource = jarPackageFragmentRoot.getJavaProject().getProject().getFile(".project");
                }
            }
        }
        return resource;
    }

    public static final Node getFirstReferenceableNodeById(Document document, String id, IFile file) {
        Map<String, Node> nodes = BeansEditorUtils.getReferenceableNodes(document, file);
        for (Map.Entry<String, Node> node : nodes.entrySet()) {
            if (!node.getKey().equals(id)) continue;
            return node.getValue();
        }
        return null;
    }

    public static final List<Node> getReferenceableNodesById(Document document, String id, IFile file) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (IReferenceableElementsLocator locator : NamespaceUtils.getAllElementsLocators()) {
            Map<String, Set<Node>> tempNodess = locator.getReferenceableElements(document, file);
            if (tempNodess == null) continue;
            for (String name : tempNodess.keySet()) {
                if (!name.equals(id)) continue;
                Set<Node> tempNodes = tempNodess.get(name);
                for (Node tempNode : tempNodes) {
                    BeansEditorUtils.updateList(tempNode, nodes);
                }
            }
        }
        return nodes;
    }

    private static void updateList(Node newNode, List<Node> nodes) {
        IDOMNode domNewNode = (IDOMNode)newNode;
        boolean found = false;
        for (Node node : nodes) {
            IDOMNode domNode;
            if (!newNode.getOwnerDocument().equals(node.getOwnerDocument()) || (domNode = (IDOMNode)node).getStartOffset() != domNewNode.getStartOffset() || domNode.getEndOffset() != domNewNode.getEndOffset()) continue;
            found = true;
        }
        if (!found) {
            nodes.add(newNode);
        }
    }

    public static final Node getNodeByOffset(IDocument document, int offset) {
        IndexedRegion inode = null;
        IStructuredModel sModel = null;
        try {
            sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (sModel == null && document instanceof IStructuredDocument) {
                sModel = StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)document);
            }
            if ((inode = sModel.getIndexedRegion(offset)) == null) {
                inode = sModel.getIndexedRegion(offset - 1);
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        if (inode instanceof Node) {
            return (Node)inode;
        }
        return null;
    }

    public static final IProgressMonitor getProgressMonitor() {
        IWorkbenchWindow activeWorkbenchWindow = Activator.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return new NullProgressMonitor();
        }
        IEditorPart editor = activeWorkbenchWindow.getActivePage().getActiveEditor();
        if (editor != null && editor.getEditorSite() != null && editor.getEditorSite().getActionBars() != null && editor.getEditorSite().getActionBars().getStatusLineManager() != null && editor.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor() != null) {
            IStatusLineManager manager = editor.getEditorSite().getActionBars().getStatusLineManager();
            IProgressMonitor monitor = manager.getProgressMonitor();
            manager.setMessage("Processing completion proposals");
            manager.setCancelEnabled(true);
            return monitor;
        }
        return new NullProgressMonitor();
    }

    public static final IProject getProject(IDocument document) {
        IProject project = null;
        IEditorInput input = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        if (input instanceof ZipEntryEditorInput) {
            ZipEntryStorage storage = (ZipEntryStorage)((ZipEntryEditorInput)input).getStorage();
            project = storage.getFile().getProject();
        } else {
            IFile file = BeansEditorUtils.getFile(document);
            project = file.getProject();
        }
        return project;
    }

    public static final Map<String, Node> getReferenceableNodes(Document document, IFile file) {
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        for (IReferenceableElementsLocator locator : NamespaceUtils.getAllElementsLocators()) {
            Map<String, Set<Node>> tempNodes = locator.getReferenceableElements(document, file);
            if (tempNodes == null) continue;
            for (String name : tempNodes.keySet()) {
                Set<Node> set = tempNodes.get(name);
                if (set == null || set.size() <= 0) continue;
                nodes.put(name, set.iterator().next());
            }
        }
        return nodes;
    }

    public static final boolean hasAttribute(Node node, String attributeName) {
        return node != null && node.hasAttributes() && node.getAttributes().getNamedItem(attributeName) != null;
    }

    public static final boolean isSpringStyleOutline() {
        return Activator.getDefault().getPreferenceStore().getBoolean("org.springframework.ide.eclipse.beans.ui.editor.outline.spring");
    }

    public static final String propertyNameToAttributeName(String propertyName) {
        char[] chars = propertyName.toCharArray();
        StringBuffer buf = new StringBuffer();
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
                buf.append('-');
                buf.append(c);
            } else {
                buf.append(c);
            }
            ++n2;
        }
        return buf.toString();
    }

    public static final String replace(String aString, String source, String target) {
        if (aString == null) {
            return null;
        }
        String normalString = "";
        int length = aString.length();
        int position = 0;
        int previous = 0;
        int spacer = source.length();
        while (position + spacer - 1 < length && aString.indexOf(source, position) > -1) {
            position = aString.indexOf(source, previous);
            normalString = String.valueOf(normalString) + aString.substring(previous, position) + target;
            previous = position += spacer;
        }
        normalString = String.valueOf(normalString) + aString.substring(position, aString.length());
        return normalString;
    }

    private static String resolveClassNameFromFactoryMethod(String factoryMethod, String className, IProject project) {
        IType type = JdtUtils.getJavaType((IProject)project, (String)className);
        if (type != null) {
            try {
                Set methods = Introspector.getAllMethods((IType)type);
                for (IMethod m : methods) {
                    if (!m.getElementName().equals(factoryMethod)) continue;
                    return JdtUtils.resolveClassNameBySignature((String)m.getReturnType(), (IType)type);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public static String prepareMatchString(ContentAssistRequest request) {
        String matchString = request.getMatchString();
        return BeansEditorUtils.prepareMatchString(matchString);
    }

    public static String prepareMatchString(String matchString) {
        if (matchString == null) {
            matchString = "";
        }
        if (matchString.length() > 0 && (matchString.startsWith(DOUBLE_QUOTE) || matchString.startsWith(SINGLE_QUOTE))) {
            matchString = matchString.substring(1);
        }
        return matchString;
    }
}

