/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.namespaces;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.viewers.ILabelProvider;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.editor.Activator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IAnnotationBasedContentAssistProcessor;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IAnnotationBasedHyperlinkDetector;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.IClassNameProvider;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.INamespaceContentAssistProcessor;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.INamespaceHyperlinkDetector;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.IReferenceableElementsLocator;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceUtils {
    public static final String DEFAULT_NAMESPACE_URI = "http://www.springframework.org/schema/beans";
    public static final String EXTENSION_POINT = "org.springframework.ide.eclipse.beans.ui.editor.namespaces";

    public static IClassNameProvider[] getClassNameProvider(String namespaceUri) {
        return NamespaceUtils.getExecutableExtension(namespaceUri, "classNameProvider", IClassNameProvider.class);
    }

    public static INamespaceContentAssistProcessor[] getContentAssistProcessor(String namespaceUri) {
        INamespaceContentAssistProcessor[] processors;
        INamespaceContentAssistProcessor[] iNamespaceContentAssistProcessorArray = processors = NamespaceUtils.getExecutableExtension(namespaceUri, "contentAssistProcessor", INamespaceContentAssistProcessor.class);
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            INamespaceContentAssistProcessor processor = iNamespaceContentAssistProcessorArray[n2];
            processor.init();
            ++n2;
        }
        return processors;
    }

    public static IAnnotationBasedContentAssistProcessor[] getAnnotationBasedContentAssistProcessor(String namespaceUri) {
        IAnnotationBasedContentAssistProcessor[] processors;
        IAnnotationBasedContentAssistProcessor[] iAnnotationBasedContentAssistProcessorArray = processors = NamespaceUtils.getExecutableExtension(namespaceUri, "contentAssistProcessor", IAnnotationBasedContentAssistProcessor.class);
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBasedContentAssistProcessor processor = iAnnotationBasedContentAssistProcessorArray[n2];
            processor.init();
            ++n2;
        }
        return processors;
    }

    public static List<IReferenceableElementsLocator> getAllElementsLocators() {
        ArrayList<IReferenceableElementsLocator> locators = new ArrayList<IReferenceableElementsLocator>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    try {
                        if (config.getAttribute("elementLocator") != null) {
                            locators.add((IReferenceableElementsLocator)config.createExecutableExtension("elementLocator"));
                        }
                    }
                    catch (Exception e) {
                        BeansUIPlugin.log((Throwable)e);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return locators;
    }

    private static <T> T[] getExecutableExtension(String namespaceUri, String attributeName, Class<T> requiredType) {
        namespaceUri = NamespaceUtils.checkNamespaceUri(namespaceUri);
        ArrayList<Object> extensions = new ArrayList<Object>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (namespaceUri.equals(config.getAttribute("uri"))) {
                        try {
                            if (config.getAttribute(attributeName) != null) {
                                extensions.add(config.createExecutableExtension(attributeName));
                            }
                        }
                        catch (Exception e) {
                            Activator.log(e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return extensions.toArray((Object[])Array.newInstance(requiredType, extensions.size()));
    }

    public static IHyperlinkDetector[] getHyperlinkDetector(String namespaceUri) {
        IHyperlinkDetector[] detectors;
        IHyperlinkDetector[] iHyperlinkDetectorArray = detectors = NamespaceUtils.getExecutableExtension(namespaceUri, "hyperLinkDetector", IHyperlinkDetector.class);
        int n = detectors.length;
        int n2 = 0;
        while (n2 < n) {
            IHyperlinkDetector detector = iHyperlinkDetectorArray[n2];
            if (detector instanceof INamespaceHyperlinkDetector) {
                ((INamespaceHyperlinkDetector)detector).init();
            }
            ++n2;
        }
        return detectors;
    }

    public static IAnnotationBasedHyperlinkDetector[] getAnnotationBasedHyperlinkDetector(String namespaceUri) {
        IAnnotationBasedHyperlinkDetector[] detectors;
        IAnnotationBasedHyperlinkDetector[] iAnnotationBasedHyperlinkDetectorArray = detectors = NamespaceUtils.getExecutableExtension(namespaceUri, "hyperLinkDetector", IAnnotationBasedHyperlinkDetector.class);
        int n = detectors.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBasedHyperlinkDetector detector = iAnnotationBasedHyperlinkDetectorArray[n2];
            if (detector instanceof INamespaceHyperlinkDetector) {
                ((INamespaceHyperlinkDetector)((Object)detector)).init();
            }
            ++n2;
        }
        return detectors;
    }

    public static ILabelProvider[] getLabelProvider(String namespaceUri) {
        return NamespaceUtils.getExecutableExtension(namespaceUri, "labelProvider", ILabelProvider.class);
    }

    public static String getNamespaceUri(Element element) {
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = DEFAULT_NAMESPACE_URI;
        }
        return namespaceURI;
    }

    public static String checkNamespaceUri(String namespaceUri) {
        if (namespaceUri == null) {
            namespaceUri = DEFAULT_NAMESPACE_URI;
        }
        return namespaceUri;
    }
}

