/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink.bean;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.JavaElementHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.w3c.dom.Node;

public class PropertyNameHyperlinkCalculator
implements IHyperlinkCalculator {
    public IHyperlink createHyperlink(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        String parentName = null;
        if (parentNode != null) {
            parentName = parentNode.getNodeName();
        }
        ArrayList<String> propertyPaths = new ArrayList<String>();
        hyperlinkRegion = BeansEditorUtils.extractPropertyPathFromCursorPosition(hyperlinkRegion, cursor, target, propertyPaths);
        if ("bean".equals(parentName)) {
            IMethod method;
            IFile file = BeansEditorUtils.getFile(document);
            ArrayList<IType> classes = new ArrayList<IType>();
            String className = BeansEditorUtils.getClassNameForBean(file, node.getOwnerDocument(), parentNode);
            if (file != null && file.exists()) {
                IType type = JdtUtils.getJavaType((IProject)file.getProject(), (String)className);
                if (type != null) {
                    classes.add(type);
                } else {
                    return null;
                }
            }
            if ((method = BeansEditorUtils.extractMethodFromPropertyPathElements(propertyPaths, classes, file, 0)) != null) {
                return new JavaElementHyperlink(hyperlinkRegion, (IJavaElement)method);
            }
        }
        return null;
    }
}

