/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.JavaElementHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.w3c.dom.Node;

public class FieldHyperlinkCalculator
implements IHyperlinkCalculator {
    public IHyperlink createHyperlink(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        int ix = target.lastIndexOf(46);
        if (ix > 0) {
            String typeName = target.substring(0, ix);
            IFile file = BeansEditorUtils.getFile(document);
            if (file != null && file.exists()) {
                IType type = JdtUtils.getJavaType((IProject)file.getProject(), (String)typeName);
                if (type != null) {
                    try {
                        IField[] fields;
                        IField[] iFieldArray = fields = type.getFields();
                        int n = fields.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IField field = iFieldArray[n2];
                            if (target.endsWith(String.valueOf('.') + field.getElementName())) {
                                return new JavaElementHyperlink(hyperlinkRegion, (IJavaElement)field);
                            }
                            ++n2;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    return new JavaElementHyperlink(hyperlinkRegion, (IJavaElement)type);
                }
                type = JdtUtils.getJavaType((IProject)file.getProject(), (String)target);
                if (type != null) {
                    return new JavaElementHyperlink(hyperlinkRegion, (IJavaElement)type);
                }
            }
        }
        return null;
    }
}

