/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.ExternalBeanHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IMultiHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.NodeElementHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.StringUtils;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.w3c.dom.Node;

public class BeanHyperlinkCalculator
implements IHyperlinkCalculator,
IMultiHyperlinkCalculator {
    public IHyperlink createHyperlink(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        IFile file = BeansEditorUtils.getFile(document);
        Node bean = BeansEditorUtils.getFirstReferenceableNodeById(node.getOwnerDocument(), target, file);
        return this.createHyperlinkHelper(bean, target, hyperlinkRegion, textViewer, file);
    }

    private IHyperlink createHyperlinkHelper(Node bean, String target, IRegion hyperlinkRegion, ITextViewer textViewer, IFile file) {
        if (bean != null) {
            IRegion region = this.getHyperlinkRegion(bean);
            return new NodeElementHyperlink(bean, file, hyperlinkRegion, region, textViewer);
        }
        for (IBean modelBean : BeansEditorUtils.getBeansFromConfigSets(file)) {
            if (!modelBean.getElementName().equals(target)) continue;
            return new ExternalBeanHyperlink((ISourceModelElement)modelBean, hyperlinkRegion);
        }
        return null;
    }

    public IHyperlink[] createHyperlinks(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        IFile file = BeansEditorUtils.getFile(document);
        List<Node> beans = BeansEditorUtils.getReferenceableNodesById(node.getOwnerDocument(), target, file);
        ArrayList<IHyperlink> result = new ArrayList<IHyperlink>();
        for (Node bean : beans) {
            IHyperlink link = this.createHyperlinkHelper(bean, target, hyperlinkRegion, textViewer, file);
            if (link == null) continue;
            result.add(link);
        }
        Set<IBean> beansFromConfigSets = BeansEditorUtils.getBeansFromConfigSets(file);
        for (IBean bean : beansFromConfigSets) {
            if (!bean.getElementName().equals(target)) continue;
            result.add(new ExternalBeanHyperlink((ISourceModelElement)bean, hyperlinkRegion));
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new IHyperlink[result.size()]);
    }

    protected final IRegion getHyperlinkRegion(Node node) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 3: 
                case 10: {
                    IDOMNode docNode = (IDOMNode)node;
                    return new Region(docNode.getStartOffset(), docNode.getEndOffset() - docNode.getStartOffset());
                }
                case 1: {
                    IDOMElement element = (IDOMElement)node;
                    int endOffset = element.hasEndTag() && element.isClosed() ? element.getStartEndOffset() : element.getEndOffset();
                    return new Region(element.getStartOffset(), endOffset - element.getStartOffset());
                }
                case 2: {
                    IDOMAttr att = (IDOMAttr)node;
                    int regOffset = att.getValueRegionStartOffset();
                    int regLength = att.getValueRegionText().length();
                    String attValue = att.getValueRegionText();
                    if (StringUtils.isQuoted((String)attValue)) {
                        ++regOffset;
                        regLength -= 2;
                    }
                    return new Region(regOffset, regLength);
                }
            }
        }
        return null;
    }
}

