/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hover;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.taginfo.XMLTagInfoHoverProcessor;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansJavaDocUtils;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BeansTextHoverProcessor
extends XMLTagInfoHoverProcessor
implements ITextHover {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String displayText = null;
        int documentOffset = hoverRegion.getOffset();
        displayText = this.computeHoverHelp(textViewer, documentOffset);
        if (displayText != null) {
            return displayText;
        }
        return super.getHoverInfo(textViewer, hoverRegion);
    }

    protected String computeHoverHelp(ITextViewer textViewer, int documentPosition) {
        ITextRegion region;
        String result = null;
        IndexedRegion treeNode = BeansEditorUtils.getNodeAt((ITextViewer)((StructuredTextViewer)textViewer), documentPosition);
        if (treeNode == null) {
            return null;
        }
        Node node = (Node)treeNode;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode parentNode = (IDOMNode)node;
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(documentPosition);
        if (flatNode != null && (region = flatNode.getRegionAtCharacterOffset(documentPosition)) != null) {
            result = this.computeRegionHelp(treeNode, parentNode, flatNode, region, textViewer.getDocument());
        }
        return result;
    }

    protected String computeRegionHelp(IndexedRegion treeNode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region, IDocument document) {
        String result = null;
        if (region == null) {
            return null;
        }
        String regionType = region.getType();
        if (regionType == "XML_TAG_NAME") {
            result = this.computeTagNameHelp((IDOMNode)treeNode, parentNode, flatNode, region);
        } else if (regionType == "XML_TAG_ATTRIBUTE_NAME") {
            result = this.computeTagAttNameHelp((IDOMNode)treeNode, parentNode, flatNode, region);
        } else if (regionType == "XML_TAG_ATTRIBUTE_VALUE") {
            result = this.computeTagAttValueHelp((IDOMNode)treeNode, parentNode, flatNode, region, document);
        }
        return result;
    }

    protected String computeTagAttValueHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region, IDocument document) {
        BeansJavaDocUtils utils;
        IMethod method;
        IType type;
        String className;
        String factoryMethod;
        Element ref;
        IFile file = BeansEditorUtils.getFile(document);
        ITextRegion attrNameRegion = this.getAttrNameRegion(xmlnode, region);
        String attName = flatNode.getText(attrNameRegion);
        NamedNodeMap attributes = xmlnode.getAttributes();
        String result = null;
        if ("class".equals(attName) && attributes.getNamedItem("class") != null) {
            IType type2;
            String className2 = attributes.getNamedItem("class").getNodeValue();
            if (className2 != null && file != null && (type2 = JdtUtils.getJavaType((IProject)file.getProject(), (String)className2)) != null) {
                BeansJavaDocUtils utils2 = new BeansJavaDocUtils((IMember)type2);
                result = utils2.getJavaDoc();
            }
        } else if ("name".equals(attName) && "property".equals(xmlnode.getNodeName())) {
            String propertyName = attributes.getNamedItem(attName).getNodeValue();
            String[] paths = StringUtils.split((String)propertyName, (String)".");
            if (paths == null) {
                paths = new String[]{propertyName};
            }
            List<String> propertyPaths = Arrays.asList(paths);
            List<IType> classNames = BeansEditorUtils.getClassNamesOfBean(file, xmlnode.getParentNode());
            ArrayList<IMethod> methods = new ArrayList<IMethod>();
            BeansEditorUtils.extractAllMethodsFromPropertyPathElements(propertyPaths, classNames, file, 0, methods);
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < methods.size()) {
                IMethod method2 = (IMethod)methods.get(i);
                if (method2 != null) {
                    BeansJavaDocUtils utils3 = new BeansJavaDocUtils((IMember)method2);
                    buf.append(String.valueOf(utils3.getJavaDoc()) + "<br>");
                }
                ++i;
            }
            result = buf.toString();
        } else if ("local".equals(attName) && attributes.getNamedItem(attName) != null) {
            ref = xmlnode.getOwnerDocument().getElementById(attributes.getNamedItem(attName).getNodeValue());
            result = BeansEditorUtils.createAdditionalProposalInfo(ref, file);
        } else if ("bean".equals(attName) && attributes.getNamedItem(attName) != null) {
            String target = attributes.getNamedItem(attName).getNodeValue();
            for (IBean modelBean : BeansEditorUtils.getBeansFromConfigSets(file)) {
                if (!modelBean.getElementName().equals(target)) continue;
                result = BeansEditorUtils.createAdditionalProposalInfo(modelBean);
            }
        } else if (("ref".equals(attName) || "local".equals(attName) || "parent".equals(attName) || "depends-on".equals(attName) || "factory-bean".equals(attName) || "key-ref".equals(attName) || "value-ref".equals(attName) || attName.endsWith("-ref") || "name".equals(attName) && "alias".equals(xmlnode.getNodeName()) || "bean".equals(attName) && "ref".equals(xmlnode.getNodeName())) && attributes.getNamedItem(attName) != null) {
            ref = xmlnode.getOwnerDocument().getElementById(attributes.getNamedItem(attName).getNodeValue());
            if (ref != null) {
                result = BeansEditorUtils.createAdditionalProposalInfo(ref, file);
            } else {
                String target = attributes.getNamedItem(attName).getNodeValue();
                for (IBean modelBean : BeansEditorUtils.getBeansFromConfigSets(file)) {
                    if (!modelBean.getElementName().equals(target)) continue;
                    result = BeansEditorUtils.createAdditionalProposalInfo(modelBean);
                }
            }
        } else if ("factory-method".equals(attName)) {
            factoryMethod = attributes.getNamedItem(attName).getNodeValue();
            className = BeansEditorUtils.getClassNameForBean(file, xmlnode.getOwnerDocument(), (Node)xmlnode);
            if (file != null && file.exists() && (type = JdtUtils.getJavaType((IProject)file.getProject(), (String)className)) != null) {
                try {
                    IMethod[] methods;
                    IMethod[] iMethodArray = methods = type.getMethods();
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod method3 = iMethodArray[n2];
                        if (method3.getElementName().equals(factoryMethod)) {
                            BeansJavaDocUtils utils4 = new BeansJavaDocUtils((IMember)method3);
                            result = utils4.getJavaDoc();
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        if ("init-method".equals(attName) || "destroy-method".equals(attName)) {
            factoryMethod = attributes.getNamedItem(attName).getNodeValue();
            className = BeansEditorUtils.getClassNameForBean(file, xmlnode.getOwnerDocument(), (Node)xmlnode);
            if (file != null && file.exists()) {
                type = JdtUtils.getJavaType((IProject)file.getProject(), (String)className);
                try {
                    method = Introspector.findMethod((IType)type, (String)factoryMethod, (int)0, (Introspector.Public)Introspector.Public.DONT_CARE, (Introspector.Static)Introspector.Static.DONT_CARE);
                    if (method != null) {
                        utils = new BeansJavaDocUtils((IMember)method);
                        result = utils.getJavaDoc();
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        } else if ("lookup-method".equals(xmlnode.getNodeName()) && "name".equals(attName) || "replaced-method".equals(xmlnode.getNodeName()) && "name".equals(attName)) {
            factoryMethod = attributes.getNamedItem(attName).getNodeValue();
            className = BeansEditorUtils.getClassNameForBean(file, xmlnode.getOwnerDocument(), xmlnode.getParentNode());
            if (file != null && file.exists()) {
                type = JdtUtils.getJavaType((IProject)file.getProject(), (String)className);
                try {
                    method = Introspector.findMethod((IType)type, (String)factoryMethod, (int)0, (Introspector.Public)Introspector.Public.DONT_CARE, (Introspector.Static)Introspector.Static.DONT_CARE);
                    if (method != null) {
                        utils = new BeansJavaDocUtils((IMember)method);
                        result = utils.getJavaDoc();
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        if (result != null && !"".equals(result)) {
            return result;
        }
        return super.computeTagAttValueHelp(xmlnode, parentNode, flatNode, attrNameRegion);
    }
}

