/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.ClassContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConstructorArgValueContentAssistCalculator
extends ClassContentAssistCalculator
implements IContentAssistCalculator {
    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        block5: {
            IType type;
            String propertyName;
            String matchString = context.getMatchString();
            if (matchString == null || matchString.length() == 0) {
                return;
            }
            if (context.getParentNode() == null || !"bean".equals(context.getParentNode().getLocalName()) || !StringUtils.hasText((String)(propertyName = BeansEditorUtils.getAttribute(context.getNode(), "name")))) break block5;
            IFile file = context.getFile();
            String className = BeansEditorUtils.getClassNameForBean(file, context.getDocument(), context.getParentNode());
            if (file == null || !file.exists() || (type = JdtUtils.getJavaType((IProject)file.getProject(), (String)className)) == null) break block5;
            try {
                IMethod method;
                block7: {
                    Set methods;
                    int argIndex;
                    block6: {
                        IBean bean;
                        int count;
                        IBeansConfig config = BeansCorePlugin.getModel().getConfig(file);
                        if (config == null || !(context.getParentNode() instanceof Element)) break block5;
                        IModelElement element = BeansModelUtils.getModelElement((Element)((Element)context.getParentNode()), (IModelElement)config);
                        argIndex = this.getArgumentIndex(context.getNode());
                        if (argIndex < 0 || !(element instanceof IBean) || (count = (bean = (IBean)element).getConstructorArguments().size()) <= 0) break block5;
                        method = null;
                        methods = Introspector.getConstructors((IType)type, (int)count, (boolean)false);
                        if (methods.size() != 1) break block6;
                        IMethod[] array = methods.toArray(new IMethod[0]);
                        IMethod candidate = array[0];
                        if (!this.isConstructorArgComputable(type, candidate, argIndex)) break block7;
                        method = candidate;
                        break block7;
                    }
                    for (IMethod candidate : methods) {
                        if (!this.isConstructorArgComputable(type, candidate, argIndex)) continue;
                        method = candidate;
                        break;
                    }
                }
                if (method != null) {
                    super.computeProposals(context, recorder);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private int getArgumentIndex(Node arg) {
        if (arg instanceof Element && "constructor-arg".equals(arg.getNodeName())) {
            Element parent = (Element)arg.getParentNode();
            NodeList list = parent.getElementsByTagName("constructor-arg");
            int i = 0;
            while (i < list.getLength()) {
                Node candidate = list.item(i);
                if (arg.equals(candidate)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private boolean isConstructorArgComputable(IType type, IMethod candidate, int argIndex) {
        String parameterType = JdtUtils.resolveClassNameBySignature((String)candidate.getParameterTypes()[argIndex], (IType)type);
        return Class.class.getName().equals(parameterType) || String.class.getName().equals(parameterType);
    }
}

