/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.AbstractContentAssistProcessor;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.DefaultContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.DefaultContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.INamespaceContentAssistProcessor;
import org.springframework.util.StringUtils;
import org.w3c.dom.Node;

public abstract class NamespaceContentAssistProcessorSupport
extends AbstractContentAssistProcessor
implements INamespaceContentAssistProcessor {
    private Map<String, IContentAssistCalculator> calculators = new HashMap<String, IContentAssistCalculator>();

    protected void computeAttributeNameProposals(ContentAssistRequest request, String prefix, String namespace, String namespacePrefix, Node attributeNode) {
    }

    protected void computeTagInsertionProposals(ContentAssistRequest request, IDOMNode node) {
    }

    protected final void computeAttributeValueProposals(ContentAssistRequest request, IDOMNode node, String matchString, String attributeName, String namespace, String prefix) {
        if (matchString == null) {
            matchString = "";
        }
        String parentNodeName = null;
        String parentNamespaceUri = null;
        IDOMNode parentNode = (IDOMNode)node.getParentNode();
        if (parentNode != null) {
            parentNodeName = parentNode.getLocalName();
            parentNamespaceUri = parentNode.getNamespaceURI();
        }
        if (parentNamespaceUri == null) {
            parentNamespaceUri = "http://www.springframework.org/schema/beans";
        }
        IContentAssistCalculator calculator = this.locateContentAssistCalculator(parentNamespaceUri, parentNodeName, node.getLocalName(), attributeName);
        DefaultContentAssistContext context = new DefaultContentAssistContext(request, attributeName, matchString);
        DefaultContentAssistProposalRecorder recorder = new DefaultContentAssistProposalRecorder(request);
        if (calculator != null) {
            calculator.computeProposals(context, recorder);
        }
        this.postComputeAttributeValueProposals(request, node, matchString, attributeName, namespace, prefix);
    }

    protected void postComputeAttributeValueProposals(ContentAssistRequest request, IDOMNode node, String matchString, String attributeName, String namespace, String prefix) {
    }

    private IContentAssistCalculator locateContentAssistCalculator(String parentNamespaceUri, String parentNodeName, String nodeName, String attributeName) {
        String key = this.createRegisteredName(parentNamespaceUri, parentNodeName, nodeName, attributeName);
        if (this.calculators.containsKey(key)) {
            return this.calculators.get(key);
        }
        key = this.createRegisteredName(null, null, nodeName, attributeName);
        if (this.calculators.containsKey(key)) {
            return this.calculators.get(key);
        }
        key = this.createRegisteredName(null, null, null, attributeName);
        if (this.calculators.containsKey(key)) {
            return this.calculators.get(key);
        }
        return null;
    }

    protected String createRegisteredName(String parentNamespaceUri, String parentNodeName, String nodeName, String attributeName) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.hasText((String)parentNamespaceUri)) {
            builder.append("/parentNamespaceUri=");
            builder.append(parentNamespaceUri);
        } else {
            builder.append("/parentNamespaceUri=");
            builder.append("*");
        }
        if (StringUtils.hasText((String)parentNodeName)) {
            builder.append("/parentNodeName=");
            builder.append(parentNodeName);
        } else {
            builder.append("/parentNodeName=");
            builder.append("*");
        }
        if (StringUtils.hasText((String)nodeName)) {
            builder.append("/nodeName=");
            builder.append(nodeName);
        } else {
            builder.append("/nodeName=");
            builder.append("*");
        }
        if (StringUtils.hasText((String)attributeName)) {
            builder.append("/attribute=");
            builder.append(attributeName);
        }
        return builder.toString();
    }

    protected void registerContentAssistCalculator(String attributeName, IContentAssistCalculator calculator) {
        this.registerContentAssistCalculator(null, null, null, attributeName, calculator);
    }

    protected void registerContentAssistCalculator(String nodeName, String attributeName, IContentAssistCalculator calculator) {
        this.registerContentAssistCalculator(null, null, nodeName, attributeName, calculator);
    }

    protected void registerContentAssistCalculator(String parentNamespaceUri, String parentNodeName, String nodeName, String attributeName, IContentAssistCalculator calculator) {
        this.calculators.put(this.createRegisteredName(parentNamespaceUri, parentNodeName, nodeName, attributeName), calculator);
    }
}

