/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist;

import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.DelegatingContentAssistProcessor;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.INamespaceContentAssistProcessor;
import org.springframework.ide.eclipse.beans.ui.editor.templates.BeansTemplateCompletionProcessor;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.w3c.dom.Node;

public abstract class AbstractContentAssistProcessor
implements INamespaceContentAssistProcessor {
    protected IContentAssistProcessor delegatingContextAssistProcessor;
    private BeansTemplateCompletionProcessor templateProcessor = null;

    public void init() {
    }

    public void addAttributeNameProposals(IContentAssistProcessor delegatingContextAssistProcessor, ContentAssistRequest request) {
        String matchString;
        this.delegatingContextAssistProcessor = delegatingContextAssistProcessor;
        IDOMNode node = (IDOMNode)request.getNode();
        IStructuredDocumentRegion open = node.getFirstStructuredDocumentRegion();
        ITextRegionList openRegions = open.getRegions();
        int i = openRegions.indexOf(request.getRegion());
        if (i < 0) {
            return;
        }
        ITextRegion nameRegion = null;
        while (i >= 0) {
            if ((nameRegion = openRegions.get(i--)).getType() == "XML_TAG_ATTRIBUTE_NAME") break;
        }
        if ((matchString = request.getMatchString()) == null) {
            matchString = "";
        }
        if (matchString.length() > 0 && (matchString.startsWith("\"") || matchString.startsWith("'"))) {
            matchString = matchString.substring(1);
        }
        if (nameRegion != null) {
            String attributeName = open.getText(nameRegion);
            Node attribute = node.getAttributes().getNamedItem(attributeName);
            if (attribute != null) {
                String prefix = attribute.getPrefix();
                String namespace = attribute.getNamespaceURI();
                if (prefix != null) {
                    attributeName = attributeName.substring(prefix.length() + 1);
                }
                this.computeAttributeNameProposals(request, attributeName, namespace, prefix, (Node)node);
            }
        }
    }

    public void addAttributeValueProposals(IContentAssistProcessor delegatingContextAssistProcessor, ContentAssistRequest request) {
        this.delegatingContextAssistProcessor = delegatingContextAssistProcessor;
        IDOMNode node = (IDOMNode)request.getNode();
        IStructuredDocumentRegion open = node.getFirstStructuredDocumentRegion();
        ITextRegionList openRegions = open.getRegions();
        int i = openRegions.indexOf(request.getRegion());
        if (i < 0) {
            return;
        }
        ITextRegion nameRegion = null;
        while (i >= 0) {
            if ((nameRegion = openRegions.get(i--)).getType() == "XML_TAG_ATTRIBUTE_NAME") break;
        }
        String matchString = BeansEditorUtils.prepareMatchString(request);
        if (nameRegion != null) {
            String attributeName = open.getText(nameRegion);
            Node attribute = node.getAttributes().getNamedItem(attributeName);
            if (attribute != null) {
                String prefix = attribute.getPrefix();
                String namespace = attribute.getNamespaceURI();
                if (prefix != null) {
                    attributeName = attributeName.substring(prefix.length() + 1);
                }
                if (prefix == null && namespace == null) {
                    prefix = node.getPrefix();
                    namespace = node.getNamespaceURI();
                }
                this.computeAttributeValueProposals(request, node, matchString, attributeName, namespace, prefix);
            }
        }
    }

    public void addTagCloseProposals(IContentAssistProcessor delegatingContextAssistProcessor, ContentAssistRequest request) {
        this.delegatingContextAssistProcessor = delegatingContextAssistProcessor;
        this.addAttributeValueProposals(delegatingContextAssistProcessor, request);
    }

    public void addTagInsertionProposals(IContentAssistProcessor delegatingContextAssistProcessor, ContentAssistRequest request, int childPosition) {
        this.delegatingContextAssistProcessor = delegatingContextAssistProcessor;
        IDOMNode node = (IDOMNode)request.getNode();
        this.computeTagInsertionProposals(request, node);
    }

    protected void addTemplates(ContentAssistRequest contentAssistRequest, String context) {
        boolean useProposalList;
        if (contentAssistRequest == null) {
            return;
        }
        boolean bl = useProposalList = !contentAssistRequest.shouldSeparate();
        if (this.getTemplateCompletionProcessor() != null) {
            ICompletionProposal[] proposals;
            this.getTemplateCompletionProcessor().setContextType(context);
            ICompletionProposal[] iCompletionProposalArray = proposals = this.getTemplateCompletionProcessor().computeCompletionProposals(((DelegatingContentAssistProcessor)this.delegatingContextAssistProcessor).getTextViewer(), contentAssistRequest.getReplacementBeginPosition());
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal element = iCompletionProposalArray[n2];
                if (useProposalList) {
                    contentAssistRequest.addProposal(element);
                } else {
                    contentAssistRequest.addMacro(element);
                }
                ++n2;
            }
        }
    }

    protected abstract void computeAttributeNameProposals(ContentAssistRequest var1, String var2, String var3, String var4, Node var5);

    protected abstract void computeAttributeValueProposals(ContentAssistRequest var1, IDOMNode var2, String var3, String var4, String var5, String var6);

    protected abstract void computeTagInsertionProposals(ContentAssistRequest var1, IDOMNode var2);

    protected BeansTemplateCompletionProcessor getTemplateCompletionProcessor() {
        if (this.templateProcessor == null) {
            this.templateProcessor = new BeansTemplateCompletionProcessor();
        }
        return this.templateProcessor;
    }
}

