/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.model.xml;

import org.springframework.core.io.Resource;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.util.ObjectUtils;
import org.w3c.dom.Node;

public class XmlSourceLocation
implements IModelSourceLocation {
    private Resource resource;
    private String localName;
    private String prefix;
    private String namespaceURI;
    private int startLine;
    private int endLine;

    public XmlSourceLocation(Resource resource, Node node, int startLine, int endLine) {
        this.resource = resource;
        this.startLine = startLine;
        this.endLine = endLine;
        if (node != null) {
            this.localName = node.getLocalName();
            this.prefix = node.getPrefix();
            this.namespaceURI = node.getNamespaceURI();
        }
    }

    public XmlSourceLocation(XmlSourceLocation location) {
        this.resource = location.getResource();
        this.localName = location.getLocalName();
        this.prefix = location.getPrefix();
        this.namespaceURI = location.getNamespaceURI();
        this.startLine = location.getStartLine();
        this.endLine = location.getEndLine();
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getNodeName() {
        return this.prefix == null ? this.localName : String.valueOf(this.prefix) + ':' + this.localName;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof XmlSourceLocation)) {
            return false;
        }
        XmlSourceLocation that = (XmlSourceLocation)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.resource, (Object)that.resource)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.localName, (Object)that.localName)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.prefix, (Object)that.prefix)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.namespaceURI, (Object)that.namespaceURI)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.startLine, (Object)that.startLine)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.endLine, (Object)that.endLine);
    }

    public int hashCode() {
        int hashCode = 29 * ObjectUtils.nullSafeHashCode((Object)this.resource);
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.localName);
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.prefix);
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.namespaceURI);
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.startLine);
        return 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.endLine);
    }

    public String toString() {
        return "XmlSource: resource=" + this.resource + ", nodeName=" + this.getNodeName() + ", startLine=" + this.startLine + ", endLine=" + this.endLine;
    }
}

