/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.model.validation;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.springframework.ide.eclipse.core.MarkerUtils;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidationRuleDefinition;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidationRuleDefinitionFactory;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationElementLifecycleManager;
import org.springframework.ide.eclipse.core.model.validation.IValidationElementLifecycleManagerExtension;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.IValidator;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblem;
import org.springframework.ide.eclipse.core.model.validation.ValidationProgressState;
import org.springframework.ide.eclipse.core.model.validation.ValidationUtils;
import org.springframework.ide.eclipse.core.project.DefaultProjectContributorState;
import org.springframework.ide.eclipse.core.project.IProjectContributorState;
import org.springframework.ide.eclipse.core.project.IProjectContributorStateAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidator
implements IValidator,
IProjectContributorStateAware {
    private IProjectContributorState contributorState;
    private String markerId;
    private String validatorId;

    @Override
    public void cleanup(IResource resource, IProgressMonitor monitor) throws CoreException {
        MarkerUtils.deleteMarkers(resource, this.getMarkerId());
    }

    public void setMarkerId(String markerId) {
        this.markerId = markerId;
    }

    @Override
    public void setProjectContributorState(IProjectContributorState contributorState) {
        this.contributorState = contributorState;
        this.contributorState.hold(new ValidationProgressState());
    }

    public void setValidatorId(String validatorId) {
        this.validatorId = validatorId;
    }

    @Override
    public final void validate(Set<IResource> affectedResources, int kind, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, affectedResources.size());
        try {
            for (IResource resource : affectedResources) {
                String progressMessage = "Validating '" + resource.getFullPath().toString().substring(1) + "'";
                this.reportProgress(progressMessage, (IProgressMonitor)subMonitor);
                this.cleanup(resource, (IProgressMonitor)subMonitor);
                if (subMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IValidationElementLifecycleManager callback = this.initValidationElementCallback(resource, kind);
                IResourceModelElement rootElement = callback.getRootElement();
                if (rootElement != null && rootElement.isExternal()) {
                    monitor.worked(1);
                    break;
                }
                Set<ValidationRuleDefinition> ruleDefinitions = this.getRuleDefinitions(resource);
                if (rootElement != null && ruleDefinitions != null && ruleDefinitions.size() > 0) {
                    Set<ValidationProblem> problems = this.validate(callback, ruleDefinitions, subMonitor);
                    ValidationUtils.createProblemMarkers(resource, problems, this.getMarkerId());
                }
                callback.destroy();
                subMonitor.worked(1);
                if (!subMonitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        }
        finally {
            subMonitor.done();
        }
    }

    private IValidationElementLifecycleManager initValidationElementCallback(IResource resource, int kind) {
        IValidationElementLifecycleManager callback = this.createValidationElementLifecycleManager();
        if (callback instanceof IValidationElementLifecycleManagerExtension) {
            ((IValidationElementLifecycleManagerExtension)callback).setKind(kind);
        }
        callback.init(resource);
        return callback;
    }

    private Set<ValidationProblem> validate(IValidationElementLifecycleManager callback, Set<ValidationRuleDefinition> ruleDefinitions, SubProgressMonitor subMonitor) {
        LinkedHashSet<ValidationProblem> problems = new LinkedHashSet<ValidationProblem>();
        for (IResourceModelElement contextElement : callback.getContextElements()) {
            IValidationContext context = this.createContext(callback.getRootElement(), contextElement);
            if (context instanceof IProjectContributorStateAware) {
                ((IProjectContributorStateAware)((Object)context)).setProjectContributorState(this.contributorState);
            }
            if (context != null) {
                ValidationVisitor visitor = new ValidationVisitor(context, ruleDefinitions);
                callback.getRootElement().accept(visitor, (IProgressMonitor)subMonitor);
                problems.addAll(context.getProblems());
            }
            if (!subMonitor.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return problems;
    }

    protected abstract IValidationContext createContext(IResourceModelElement var1, IResourceModelElement var2);

    protected abstract IValidationElementLifecycleManager createValidationElementLifecycleManager();

    protected String getMarkerId() {
        return this.markerId;
    }

    protected synchronized IProjectContributorState getProjectContributorState() {
        if (this.contributorState == null) {
            this.contributorState = new DefaultProjectContributorState();
        }
        return this.contributorState;
    }

    protected Set<ValidationRuleDefinition> getRuleDefinitions(IResource resource) {
        return ValidationRuleDefinitionFactory.getEnabledRuleDefinitions(this.getValidatorId(), resource.getProject());
    }

    protected String getValidatorId() {
        return this.validatorId;
    }

    protected void reportProgress(String message, IProgressMonitor monitor, Object ... args) {
        this.reportProgress(String.format(message, args), monitor);
    }

    protected void reportProgress(String message, IProgressMonitor monitor) {
        ValidationProgressState progress = this.getProjectContributorState().get(ValidationProgressState.class);
        if (progress != null) {
            int errorCount = progress.getErrorCount();
            int warningCount = progress.getWarningCount();
            if (errorCount > 0 || warningCount > 0) {
                StringBuilder builder = new StringBuilder("(Found ");
                if (errorCount > 0) {
                    builder.append(errorCount).append(errorCount > 1 ? " errors" : " error");
                }
                if (errorCount > 0 && warningCount > 0) {
                    builder.append(" + ");
                }
                if (warningCount > 0) {
                    builder.append(warningCount).append(warningCount > 1 ? " warnings" : " warning");
                }
                builder.append(") ").append(message);
                monitor.subTask(builder.toString());
            } else {
                monitor.subTask(message);
            }
        } else {
            monitor.subTask(message);
        }
    }

    protected abstract boolean supports(IModelElement var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ValidationVisitor
    implements IModelElementVisitor {
        private IValidationContext context;
        private Set<ValidationRuleDefinition> ruleDefinitions;

        public ValidationVisitor(IValidationContext context, Set<ValidationRuleDefinition> ruleDefinitions) {
            this.ruleDefinitions = ruleDefinitions;
            this.context = context;
        }

        @Override
        public boolean visit(IModelElement element, IProgressMonitor monitor) {
            if (AbstractValidator.this.supports(element)) {
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, this.ruleDefinitions.size());
                try {
                    for (ValidationRuleDefinition ruleDefinition : this.ruleDefinitions) {
                        if (subMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        String progressMessage = "Validating element '" + element.getElementName() + "' with rule '" + ruleDefinition.getName() + "'";
                        AbstractValidator.this.reportProgress(progressMessage, (IProgressMonitor)subMonitor);
                        IValidationRule rule = ruleDefinition.getRule();
                        if (rule.supports(element, this.context)) {
                            this.context.setCurrentRuleDefinition(ruleDefinition);
                            rule.validate(element, this.context, monitor);
                        }
                        subMonitor.worked(1);
                    }
                }
                finally {
                    subMonitor.done();
                }
                return true;
            }
            return false;
        }
    }
}

