/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.FieldVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.annotation.Annotation;
import org.springframework.ide.eclipse.core.java.annotation.AnnotationMemberVisitor;
import org.springframework.ide.eclipse.core.java.annotation.IAnnotationMetadata;
import org.springframework.ide.eclipse.core.type.asm.ClassMetadataReadingVisitor;
import org.springframework.ide.eclipse.core.type.asm.EmptyAnnotationVisitor;
import org.springframework.ide.eclipse.core.type.asm.EmptyFieldVisitor;
import org.springframework.ide.eclipse.core.type.asm.EmptyMethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMetadataReadingVisitor
extends ClassMetadataReadingVisitor
implements IAnnotationMetadata {
    public static AnnotationVisitor EMPTY_ANNOTATION_VISITOR = new EmptyAnnotationVisitor();
    public static MethodVisitor EMPTY_METHOD_VISITOR = new EmptyMethodVisitor();
    public static FieldVisitor EMPTY_FIELD_VISITOR = new EmptyFieldVisitor();
    private Map<String, Annotation> classAnnotations = new LinkedHashMap<String, Annotation>();
    private Map<IMethod, Set<Annotation>> methodAnnotations = new LinkedHashMap<IMethod, Set<Annotation>>();
    private Map<IField, Set<Annotation>> fieldAnnotations = new LinkedHashMap<IField, Set<Annotation>>();
    private Set<String> visitedMethods = new HashSet<String>();
    private IType type;
    private ClassLoader classloader;
    private boolean advancedValueProcessing;

    public AnnotationMetadataReadingVisitor() {
        this(false);
    }

    public AnnotationMetadataReadingVisitor(boolean advancedValueProcessing) {
        this.advancedValueProcessing = advancedValueProcessing;
    }

    public void setType(IType type) {
        this.type = type;
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    @Override
    public Set<String> getTypeLevelAnnotationClasses() {
        return this.classAnnotations.keySet();
    }

    @Override
    public Annotation getTypeLevelAnnotation(String annotationClass) {
        return this.classAnnotations.get(annotationClass);
    }

    @Override
    public Map<IMethod, Annotation> getMethodLevelAnnotations(String ... annotationClasses) {
        HashMap<IMethod, Annotation> result = new HashMap<IMethod, Annotation>();
        for (Map.Entry<IMethod, Set<Annotation>> entry : this.methodAnnotations.entrySet()) {
            for (Annotation annotation : entry.getValue()) {
                String[] stringArray = annotationClasses;
                int n = annotationClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    String annotationClass = stringArray[n2];
                    if (annotation.getAnnotationClass().equals(annotationClass)) {
                        result.put(entry.getKey(), annotation);
                    }
                    ++n2;
                }
            }
        }
        return result;
    }

    @Override
    public boolean hasMethodLevelAnnotations(String ... annotationClasses) {
        List<String> annoatations = Arrays.asList(annotationClasses);
        for (Map.Entry<IMethod, Set<Annotation>> entry : this.methodAnnotations.entrySet()) {
            for (Annotation annotation : entry.getValue()) {
                if (!annoatations.contains(annotation.getAnnotationClass())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasTypeLevelAnnotations(String ... annotationClasses) {
        Set<String> foundAnnoatationClasses = this.getTypeLevelAnnotationClasses();
        String[] stringArray = annotationClasses;
        int n = annotationClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String annotationClass = stringArray[n2];
            if (foundAnnoatationClasses.contains(annotationClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Map<IField, Annotation> getFieldLevelAnnotations(String ... annotationClasses) {
        HashMap<IField, Annotation> result = new HashMap<IField, Annotation>();
        for (Map.Entry<IField, Set<Annotation>> entry : this.fieldAnnotations.entrySet()) {
            for (Annotation annotation : entry.getValue()) {
                String[] stringArray = annotationClasses;
                int n = annotationClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    String annotationClass = stringArray[n2];
                    if (annotation.getAnnotationClass().equals(annotationClass)) {
                        result.put(entry.getKey(), annotation);
                    }
                    ++n2;
                }
            }
        }
        return result;
    }

    @Override
    public boolean hasFieldLevelAnnotations(String ... annotationClasses) {
        List<String> annoatations = Arrays.asList(annotationClasses);
        for (Map.Entry<IField, Set<Annotation>> entry : this.fieldAnnotations.entrySet()) {
            for (Annotation annotation : entry.getValue()) {
                if (!annoatations.contains(annotation.getAnnotationClass())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String annotationClass = Type.getType((String)desc).getClassName();
        if (!this.classAnnotations.containsKey(annotationClass)) {
            Annotation annotation = new Annotation(annotationClass);
            this.classAnnotations.put(annotationClass, annotation);
            return new AnnotationMemberVisitor(annotation, this.classloader, this.advancedValueProcessing);
        }
        return EMPTY_ANNOTATION_VISITOR;
    }

    @Override
    public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
        String methodKey = String.valueOf(name) + desc;
        if (!this.visitedMethods.contains(methodKey)) {
            this.visitedMethods.add(methodKey);
            return new EmptyMethodVisitor(){

                public AnnotationVisitor visitAnnotation(String annotationDesc, boolean visible) {
                    String annotationClass = Type.getType((String)annotationDesc).getClassName();
                    IMethod method = AnnotationMetadataReadingVisitor.this.getMethodFromSignature(name, desc);
                    if (method != null) {
                        Set methodAnnotations = AnnotationMetadataReadingVisitor.this.getAnnotationSet(method);
                        Annotation annotation = new Annotation(annotationClass);
                        methodAnnotations.add(annotation);
                        return new AnnotationMemberVisitor(annotation, AnnotationMetadataReadingVisitor.this.classloader, AnnotationMetadataReadingVisitor.this.advancedValueProcessing);
                    }
                    return EMPTY_ANNOTATION_VISITOR;
                }
            };
        }
        return EMPTY_METHOD_VISITOR;
    }

    @Override
    public FieldVisitor visitField(int access, final String name, String desc, String signature, Object value) {
        return new EmptyFieldVisitor(){

            public AnnotationVisitor visitAnnotation(String annotationDesc, boolean visible) {
                String annotationClass = Type.getType((String)annotationDesc).getClassName();
                IField field = AnnotationMetadataReadingVisitor.this.getFieldFromSignature(name);
                if (field != null) {
                    Set fieldAnnotations = AnnotationMetadataReadingVisitor.this.getAnnotationSet(field);
                    Annotation annotation = new Annotation(annotationClass);
                    fieldAnnotations.add(annotation);
                    return new AnnotationMemberVisitor(annotation, AnnotationMetadataReadingVisitor.this.classloader, AnnotationMetadataReadingVisitor.this.advancedValueProcessing);
                }
                return EMPTY_ANNOTATION_VISITOR;
            }
        };
    }

    private Set<Annotation> getAnnotationSet(IMethod method) {
        if (!this.methodAnnotations.containsKey(method)) {
            this.methodAnnotations.put(method, new LinkedHashSet());
        }
        return this.methodAnnotations.get(method);
    }

    private Set<Annotation> getAnnotationSet(IField field) {
        if (!this.fieldAnnotations.containsKey(field)) {
            this.fieldAnnotations.put(field, new LinkedHashSet());
        }
        return this.fieldAnnotations.get(field);
    }

    private IMethod getMethodFromSignature(String name, String desc) {
        Type[] parameterTypes = Type.getArgumentTypes((String)desc);
        IMethod method = null;
        method = this.isConstructor(name) ? this.quickCheckForConstructor(parameterTypes) : this.quickCheckForMethod(name, parameterTypes);
        if (method == null) {
            ArrayList<String> parameters = new ArrayList<String>();
            if (parameterTypes != null && parameterTypes.length > 0) {
                Type[] typeArray = parameterTypes;
                int n = parameterTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Type parameterType = typeArray[n2];
                    parameters.add(parameterType.getClassName());
                    ++n2;
                }
            }
            method = this.isConstructor(name) ? JdtUtils.getConstructor(this.type, parameters.toArray(new String[parameters.size()])) : JdtUtils.getMethod(this.type, name, parameters.toArray(new String[parameters.size()]), false);
        }
        return method;
    }

    private boolean isConstructor(String name) {
        return "<init>".equals(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IMethod quickCheckForMethod(String name, Type[] parameterTypes) {
        IMethod result = null;
        try {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = this.type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return result;
                }
                IMethod method = iMethodArray[n2];
                if (method.getElementName().equals(name) && method.getParameterTypes().length == parameterTypes.length) {
                    if (result != null) return null;
                    result = method;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IMethod quickCheckForConstructor(Type[] parameterTypes) {
        IMethod result = null;
        try {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = this.type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return result;
                }
                IMethod method = iMethodArray[n2];
                if (method.isConstructor() && method.getParameterTypes().length == parameterTypes.length) {
                    if (result != null) return null;
                    result = method;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return result;
    }

    private IField getFieldFromSignature(String name) {
        IField field = this.quickCheckForField(name);
        if (field == null) {
            field = JdtUtils.getField(this.type, name, false);
        }
        return field;
    }

    private IField quickCheckForField(String name) {
        IField field = this.type.getField(name);
        return field != null && field.exists() ? field : null;
    }
}

