/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IResource;
import org.springframework.ide.eclipse.core.SpringCore;

public class TypeStructureState {
    private boolean useChangeDetectionInJavaFiles = false;
    private Map<IResource, Boolean> resultsCache = new ConcurrentHashMap<IResource, Boolean>();

    public TypeStructureState() {
        this.useChangeDetectionInJavaFiles = SpringCore.getDefault().getPluginPreferences().getBoolean("org.springframework.ide.eclipse.core.useChangeDetectionForJavaFiles");
    }

    public boolean hasStructuralChanges(IResource resource, int flags) {
        if (!this.resultsCache.containsKey(resource)) {
            boolean result = !this.useChangeDetectionInJavaFiles || SpringCore.getTypeStructureCache().hasStructuralChanges(resource, flags);
            this.resultsCache.put(resource, result);
        }
        return this.resultsCache.get(resource);
    }

    public boolean hasStructuralChanges(IResource resource) {
        return this.hasStructuralChanges(resource, 0);
    }
}

