/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.internal.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.internal.model.SpringProject;
import org.springframework.ide.eclipse.core.internal.model.resources.ISpringResourceChangeEvents;
import org.springframework.ide.eclipse.core.internal.model.resources.SpringResourceChangeListener;
import org.springframework.ide.eclipse.core.internal.project.SpringProjectContributionManager;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.AbstractModel;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISpringModel;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;
import org.springframework.util.ObjectUtils;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringModel
extends AbstractModel
implements ISpringModel {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    protected Map<IProject, ISpringProject> projects = new ConcurrentHashMap<IProject, ISpringProject>();
    private IResourceChangeListener workspaceListener;
    private IElementChangedListener classpathListener;

    public SpringModel() {
        super(null, "SpringModel");
    }

    @Override
    public IModelElement[] getElementChildren() {
        try {
            this.r.lock();
            Collection<ISpringProject> elements = this.projects.values();
            IModelElement[] iModelElementArray = elements.toArray(new IModelElement[elements.size()]);
            return iModelElementArray;
        }
        finally {
            this.r.unlock();
        }
    }

    public void startup() {
        try {
            this.w.lock();
            this.projects.clear();
            for (IProject project : SpringCoreUtils.getSpringProjects()) {
                SpringProject proj = new SpringProject(this, project);
                this.projects.put(project, proj);
            }
        }
        finally {
            this.w.unlock();
        }
        this.workspaceListener = new SpringResourceChangeListener(new ResourceChangeEventHandler());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(this.workspaceListener, 62);
        this.classpathListener = new ClasspathChangedListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.classpathListener);
    }

    public void shutdown() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.workspaceListener);
        this.workspaceListener = null;
        JavaCore.removeElementChangedListener((IElementChangedListener)this.classpathListener);
        this.classpathListener = null;
        try {
            this.w.lock();
            this.projects.clear();
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public boolean hasProject(IProject project) {
        try {
            this.r.lock();
            boolean bl = this.projects.containsKey(project);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public ISpringProject getProject(IProject project) {
        try {
            this.r.lock();
            ISpringProject iSpringProject = this.projects.get(project);
            return iSpringProject;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public Set<ISpringProject> getProjects() {
        try {
            this.r.lock();
            Set<ISpringProject> set = Collections.unmodifiableSet(new HashSet<ISpringProject>(this.projects.values()));
            return set;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpringModel)) {
            return false;
        }
        SpringModel that = (SpringModel)other;
        if (!ObjectUtils.nullSafeEquals(this.projects, that.projects)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode(this.projects);
        return this.getElementType() * hashCode + super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer text = new StringBuffer("Spring model:\n");
        Map<IProject, ISpringProject> map = this.projects;
        synchronized (map) {
            int count = this.projects.size();
            for (ISpringProject project : this.projects.values()) {
                text.append(project.getElementName());
                if (--count <= 0) continue;
                text.append(", ");
            }
        }
        return text.toString();
    }

    private class ClasspathChangedListener
    implements IElementChangedListener {
        private ClasspathChangedListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            IJavaElementDelta[] iJavaElementDeltaArray = event.getDelta().getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta delta = iJavaElementDeltaArray[n2];
                if ((delta.getFlags() & 0x200000) != 0 || (delta.getFlags() & 0x20000) != 0) {
                    boolean addedOrRemoved = false;
                    IJavaElementDelta[] iJavaElementDeltaArray2 = delta.getAffectedChildren();
                    int n3 = iJavaElementDeltaArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IJavaElementDelta classpathDelta = iJavaElementDeltaArray2[n4];
                        if ((classpathDelta.getFlags() & 0x40) != 0 || (classpathDelta.getFlags() & 0x80) != 0 || (classpathDelta.getKind() & 1) != 0 || (classpathDelta.getKind() & 2) != 0) {
                            addedOrRemoved = true;
                            break;
                        }
                        ++n4;
                    }
                    if (addedOrRemoved) {
                        SpringProjectContributionManager.classpathChanged(delta.getElement().getJavaProject().getProject().getName());
                        for (ISpringProject project : SpringCore.getModel().getProjects()) {
                            IJavaProject javaProject = JdtUtils.getJavaProject(project.getProject());
                            if (javaProject == null || !javaProject.equals(delta.getElement().getJavaProject()) && !javaProject.isOnClasspath(delta.getElement())) continue;
                            SpringProjectContributionManager.classpathChanged(project.getProject().getName());
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private class ResourceChangeEventHandler
    implements ISpringResourceChangeEvents {
        private ResourceChangeEventHandler() {
        }

        public boolean isSpringProject(IProject project, int eventType) {
            try {
                SpringModel.this.r.lock();
                boolean bl = SpringModel.this.projects.get(project) != null;
                return bl;
            }
            finally {
                SpringModel.this.r.unlock();
            }
        }

        public void springNatureAdded(IProject project, int eventType) {
            if (eventType == 16) {
                SpringProject proj = new SpringProject(SpringModel.this, project);
                try {
                    SpringModel.this.w.lock();
                    SpringModel.this.projects.put(project, proj);
                }
                finally {
                    SpringModel.this.w.unlock();
                }
                SpringModel.this.notifyListeners(proj, ModelChangeEvent.Type.ADDED);
            }
        }

        public void springNatureRemoved(IProject project, int eventType) {
            if (eventType == 16) {
                ISpringProject proj = null;
                try {
                    SpringModel.this.w.lock();
                    proj = SpringModel.this.projects.remove(project);
                }
                finally {
                    SpringModel.this.w.unlock();
                }
                if (proj != null) {
                    SpringModel.this.notifyListeners(proj, ModelChangeEvent.Type.REMOVED);
                }
            }
        }

        public void projectAdded(IProject project, int eventType) {
            if (eventType == 16) {
                SpringProject proj = new SpringProject(SpringModel.this, project);
                try {
                    SpringModel.this.w.lock();
                    SpringModel.this.projects.put(project, proj);
                }
                finally {
                    SpringModel.this.w.unlock();
                }
                SpringModel.this.notifyListeners(proj, ModelChangeEvent.Type.ADDED);
            }
        }

        public void projectOpened(IProject project, int eventType) {
            if (eventType == 16) {
                SpringProject proj = new SpringProject(SpringModel.this, project);
                try {
                    SpringModel.this.w.lock();
                    SpringModel.this.projects.put(project, proj);
                }
                finally {
                    SpringModel.this.w.unlock();
                }
                SpringModel.this.notifyListeners(proj, ModelChangeEvent.Type.ADDED);
            }
        }

        public void projectClosed(IProject project, int eventType) {
            ISpringProject proj = null;
            try {
                SpringModel.this.w.lock();
                proj = SpringModel.this.projects.remove(project);
            }
            finally {
                SpringModel.this.w.unlock();
            }
            if (proj != null) {
                SpringModel.this.notifyListeners(proj, ModelChangeEvent.Type.REMOVED);
            }
        }

        public void projectDeleted(IProject project, int eventType) {
            ISpringProject proj = null;
            try {
                SpringModel.this.w.lock();
                proj = SpringModel.this.projects.remove(project);
            }
            finally {
                SpringModel.this.w.unlock();
            }
            if (proj != null) {
                SpringModel.this.notifyListeners(proj, ModelChangeEvent.Type.REMOVED);
            }
        }
    }
}

