/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.conflicts;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.tigris.subversion.subclipse.ui.Messages;
import org.tigris.subversion.subclipse.ui.conflicts.ConflictHandlingWizardPage;
import org.tigris.subversion.subclipse.ui.conflicts.ConflictResolution;
import org.tigris.subversion.subclipse.ui.conflicts.FinishedEditingWizardPage;
import org.tigris.subversion.subclipse.ui.conflicts.PropertyValueSelectionWizardPage;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;

public class DialogWizard
extends Wizard {
    private SVNConflictDescriptor conflictDescriptor;
    private String myValue;
    private String incomingValue;
    private String valueToUse;
    private IResource[] resources;
    private boolean conflictResolved;
    private int resolution;
    private volatile ConflictResolution conflictResolution;
    private FinishedEditingWizardPage finishedEditingWizardPage;
    private ConflictHandlingWizardPage conflictHandlingWizardPage;
    private PropertyValueSelectionWizardPage propertyValueSelectionWizardPage;
    public int type;
    public static final int CONFLICT_HANDLING = 0;
    public static final int FINISHED_EDITING = 1;
    public static final int PROPERTY_VALUE_SELECTION = 2;

    public DialogWizard(int type) {
        this.type = type;
    }

    public void addPages() {
        super.addPages();
        if (this.type == 1) {
            this.setWindowTitle(Messages.DialogWizard_0);
            boolean propertyConflict = this.conflictDescriptor != null && this.conflictDescriptor.getConflictKind() == 1;
            this.finishedEditingWizardPage = new FinishedEditingWizardPage("finishedEditing", propertyConflict);
            this.addPage((IWizardPage)this.finishedEditingWizardPage);
        }
        if (this.type == 0) {
            this.setWindowTitle(Messages.DialogWizard_1);
            this.conflictHandlingWizardPage = new ConflictHandlingWizardPage("handleConflict");
            this.conflictHandlingWizardPage.setConflictDescriptor(this.conflictDescriptor);
            this.conflictHandlingWizardPage.setResource(this.resources[0]);
            this.addPage((IWizardPage)this.conflictHandlingWizardPage);
        }
        if (this.type == 2) {
            this.setWindowTitle(Messages.DialogWizard_2);
            this.propertyValueSelectionWizardPage = new PropertyValueSelectionWizardPage("propertyValueSelection");
            this.propertyValueSelectionWizardPage.setConflictDescriptor(this.conflictDescriptor);
            this.propertyValueSelectionWizardPage.setMyValue(this.myValue);
            this.propertyValueSelectionWizardPage.setIncomingValue(this.incomingValue);
            this.propertyValueSelectionWizardPage.setResource(this.resources[0]);
            this.addPage((IWizardPage)this.propertyValueSelectionWizardPage);
        }
    }

    public boolean performFinish() {
        if (this.type == 1) {
            this.resolution = this.finishedEditingWizardPage.getResolution();
            boolean bl = this.conflictResolved = this.resolution != 0;
        }
        if (this.type == 0) {
            this.conflictResolution = this.conflictHandlingWizardPage.getConflictResolution();
        }
        if (this.type == 2) {
            this.conflictResolved = true;
            this.valueToUse = this.propertyValueSelectionWizardPage.getValue();
        }
        return true;
    }

    public boolean performCancel() {
        if (this.type == 0) {
            this.conflictResolution = this.conflictHandlingWizardPage.getConflictResolution();
        }
        if (this.type == 2) {
            this.valueToUse = this.propertyValueSelectionWizardPage.getValue();
            this.conflictResolved = false;
        }
        return super.performCancel();
    }

    public boolean isConflictResolved() {
        return this.conflictResolved;
    }

    public ConflictResolution getConflictResolution() {
        return this.conflictResolution;
    }

    public void setConflictDescriptor(SVNConflictDescriptor conflictDescriptor) {
        this.conflictDescriptor = conflictDescriptor;
    }

    public void setResources(IResource[] resources) {
        this.resources = resources;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setMyValue(String myValue) {
        this.myValue = myValue;
    }

    public void setIncomingValue(String incomingValue) {
        this.incomingValue = incomingValue;
    }

    public String getValueToUse() {
        return this.valueToUse;
    }
}

