/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.mylyn.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IImplicitlyIntersting;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.swt.widgets.Tree;
import org.springframework.ide.eclipse.aop.core.model.IAspectDefinition;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IReferenceNode;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;

public class AopReferenceModelNavigatorInterestFilter
extends InterestFilter {
    private Object temporarilyUnfiltered = null;

    public boolean select(Viewer viewer, Object parent, Object object) {
        IInteractionElement element;
        block13: {
            block12: {
                block11: {
                    block10: {
                        try {
                            if (viewer instanceof StructuredViewer && this.containsMylynInterestFilter((StructuredViewer)viewer)) break block10;
                            return true;
                        }
                        catch (Throwable throwable) {}
                    }
                    if (!this.isTemporarilyUnfilteredInternal(parent)) break block11;
                    return true;
                }
                if (!(this.temporarilyUnfiltered instanceof Tree) || !this.isRootElement(object)) break block12;
                return true;
            }
            element = null;
            if (!(object instanceof IImplicitlyIntersting)) break block13;
            return true;
        }
        if (object instanceof IInteractionElement) {
            element = (IInteractionElement)object;
        } else if (object instanceof IReferenceNode) {
            return this.isInterestingReferenceParticipant((IReferenceNode)object);
        }
        if (element != null) {
            return this.isInteresting(element);
        }
        return false;
    }

    private boolean isInterestingReferenceParticipant(IReferenceNode object) {
        if (object != null) {
            if (object.getReferenceParticipant() != null) {
                AbstractContextStructureBridge bridge;
                Object element = object.getReferenceParticipant();
                if (element instanceof IAspectDefinition) {
                    IAspectDefinition def = (IAspectDefinition)element;
                    element = BeansModelUtils.getMostSpecificModelElement((int)def.getAspectStartLineNumber(), (int)def.getAspectEndLineNumber(), (IFile)((IFile)def.getResource()), null);
                }
                if ((bridge = ContextCore.getStructureBridge((Object)element)) != null) {
                    String handle = bridge.getHandleIdentifier(element);
                    IInteractionElement interestElement = ContextCore.getContextManager().getElement(handle);
                    if (element != null && this.isInteresting(interestElement)) {
                        return true;
                    }
                }
            }
            if (object.getChildren() != null && object.getChildren().length > 0) {
                IReferenceNode[] iReferenceNodeArray = object.getChildren();
                int n = iReferenceNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IReferenceNode child = iReferenceNodeArray[n2];
                    if (child instanceof IReferenceNode && this.isInterestingReferenceParticipant(child)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    protected boolean isRootElement(Object object) {
        return object instanceof IReferenceNode;
    }

    protected boolean isInteresting(IInteractionElement element) {
        if (element.getInterest().isPredicted()) {
            return true;
        }
        return element.getInterest().isInteresting();
    }

    private boolean isTemporarilyUnfilteredInternal(Object parent) {
        if (parent instanceof TreePath) {
            TreePath treePath = (TreePath)parent;
            parent = treePath.getLastSegment();
        }
        return this.temporarilyUnfiltered != null && this.temporarilyUnfiltered.equals(parent);
    }

    protected boolean containsMylynInterestFilter(StructuredViewer viewer) {
        ViewerFilter[] viewerFilterArray = viewer.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (filter instanceof InterestFilter) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setTemporarilyUnfiltered(Object temprarilyUnfiltered) {
        this.temporarilyUnfiltered = temprarilyUnfiltered;
    }

    public boolean resetTemporarilyUnfiltered() {
        if (this.temporarilyUnfiltered != null) {
            this.temporarilyUnfiltered = null;
            return true;
        }
        return false;
    }

    public Object getTemporarilyUnfiltered() {
        return this.temporarilyUnfiltered;
    }
}

