/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ajdt.ui.visualiser;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.IMarkupKind;
import org.eclipse.contribution.visualiser.jdtImpl.JDTContentProvider;
import org.eclipse.contribution.visualiser.jdtImpl.JDTMember;
import org.eclipse.contribution.visualiser.simpleImpl.SimpleMarkupKind;
import org.eclipse.contribution.visualiser.simpleImpl.SimpleMarkupProvider;
import org.eclipse.contribution.visualiser.utils.JDTUtils;
import org.eclipse.contribution.visualiser.utils.MarkupUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.springframework.ide.eclipse.aop.core.Activator;
import org.springframework.ide.eclipse.aop.core.model.IAopModelChangedListener;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IIntroductionDefinition;
import org.springframework.ide.eclipse.aop.ui.navigator.util.AopReferenceModelNavigatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AopReferenceModelMarkupProvider
extends SimpleMarkupProvider
implements IAopModelChangedListener {
    private static Hashtable<org.eclipse.contribution.visualiser.interfaces.IMember, List<Stripe>> markupCache = new Hashtable();

    public static void resetCache() {
        markupCache.clear();
    }

    public List<Stripe> getMemberMarkups(org.eclipse.contribution.visualiser.interfaces.IMember member) {
        List references;
        List<Stripe> cachedValue = markupCache.get(member);
        if (cachedValue != null) {
            return cachedValue;
        }
        ArrayList<Stripe> stripeList = new ArrayList<Stripe>();
        if (ProviderManager.getContentProvider() instanceof JDTContentProvider && (references = Activator.getModel().getAllReferences()) != null && references.size() > 0) {
            for (IAopReference reference : references) {
                IJavaElement je;
                IType advisedType = null;
                advisedType = reference.getTarget() instanceof IType ? (IType)reference.getTarget() : reference.getTarget().getDeclaringType();
                ICompilationUnit advisedCu = advisedType.getCompilationUnit();
                if (!(member instanceof JDTMember) || !(je = ((JDTMember)member).getResource()).equals(advisedCu)) continue;
                String label = this.getText(reference);
                Stripe stripe = new Stripe((IMarkupKind)new SimpleMarkupKind(label), AopReferenceModelNavigatorUtils.getLineNumber((IMember)reference.getTarget()) + 1);
                stripeList.add(stripe);
                this.addMarkup(member.getFullname(), stripe);
            }
        }
        MarkupUtils.processStripes(stripeList);
        markupCache.put(member, stripeList);
        return stripeList;
    }

    public SortedSet<SimpleMarkupKind> getAllMarkupKinds() {
        List references;
        TreeSet<SimpleMarkupKind> kinds = new TreeSet<SimpleMarkupKind>();
        ArrayList<String> advices = new ArrayList<String>();
        if (ProviderManager.getContentProvider() instanceof JDTContentProvider && (references = Activator.getModel().getAllReferences()) != null && references.size() > 0) {
            for (IAopReference reference : references) {
                String label = this.getText(reference);
                if (advices.contains(label)) continue;
                kinds.add(new SimpleMarkupKind(label));
                advices.add(label);
            }
        }
        if (kinds.size() > 0) {
            return kinds;
        }
        return null;
    }

    public boolean processMouseclick(org.eclipse.contribution.visualiser.interfaces.IMember member, Stripe stripe, int buttonClicked) {
        if (buttonClicked == 1) {
            IJavaElement jEl;
            if (member instanceof JDTMember && (jEl = ((JDTMember)member).getResource()) != null) {
                JDTUtils.openInEditor((IResource)jEl.getResource(), (int)stripe.getOffset());
            }
            return false;
        }
        return true;
    }

    private String getText(IAopReference reference) {
        IAopReference.ADVICE_TYPE type = reference.getAdviceType();
        String text = "";
        if (type == IAopReference.ADVICE_TYPE.AFTER) {
            text = String.valueOf(text) + "after()";
        } else if (type == IAopReference.ADVICE_TYPE.AFTER_RETURNING) {
            text = String.valueOf(text) + "after-returning()";
        } else if (type == IAopReference.ADVICE_TYPE.AFTER_THROWING) {
            text = String.valueOf(text) + "after-throwing()";
        } else if (type == IAopReference.ADVICE_TYPE.BEFORE) {
            text = String.valueOf(text) + "before()";
        } else if (type == IAopReference.ADVICE_TYPE.AROUND) {
            text = String.valueOf(text) + "around()";
        } else if (type == IAopReference.ADVICE_TYPE.DECLARE_PARENTS) {
            text = String.valueOf(text) + "declare parents:";
            text = String.valueOf(text) + " implements " + ((IIntroductionDefinition)reference.getDefinition()).getImplInterfaceName();
        }
        text = String.valueOf(text) + " <";
        text = String.valueOf(text) + reference.getDefinition().getAspectName();
        text = String.valueOf(text) + "> [";
        text = String.valueOf(text) + reference.getDefinition().getResource().getProjectRelativePath().toString();
        text = String.valueOf(text) + "]";
        return text;
    }

    public void changed() {
        AopReferenceModelMarkupProvider.resetCache();
    }

    public void activate() {
        Activator.getModel().registerAopModelChangedListener((IAopModelChangedListener)this);
    }

    public void deactivate() {
        super.deactivate();
        Activator.getModel().unregisterAopModelChangedListener((IAopModelChangedListener)this);
    }
}

