/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation.rules;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.validation.AbstractBeanValidationRule;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.core.type.asm.AnnotationMetadataReadingVisitor;
import org.springframework.ide.eclipse.core.type.asm.ClassReaderFactory;
import org.springframework.ide.eclipse.core.type.asm.EmptyAnnotationVisitor;
import org.springframework.ide.eclipse.core.type.asm.EmptyMethodVisitor;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

public class BeanConstructorArgumentRule
extends AbstractBeanValidationRule {
    protected boolean supportsBean(IBean bean, IBeansValidationContext context) {
        return !bean.isAbstract();
    }

    public void validate(IBean bean, IBeansValidationContext context, IProgressMonitor monitor) {
        IType type;
        BeanDefinition mergedBd = BeansModelUtils.getMergedBeanDefinition(bean, (IModelElement)context.getContextElement());
        String mergedClassName = mergedBd.getBeanClassName();
        if (mergedClassName != null && !SpringCoreUtils.hasPlaceHolder((String)mergedClassName) && (type = JdtUtils.getJavaType((IProject)BeansModelUtils.getProject(bean).getProject(), (String)mergedClassName)) != null) {
            this.validateConstructorArguments(bean, type, context);
        }
    }

    protected void validateConstructorArguments(IBean bean, IType type, IBeansValidationContext context) {
        AbstractBeanDefinition bd = (AbstractBeanDefinition)((Bean)bean).getBeanDefinition();
        AbstractBeanDefinition mergedBd = (AbstractBeanDefinition)BeansModelUtils.getMergedBeanDefinition(bean, (IModelElement)context.getContextElement());
        if (!(bd instanceof AnnotatedBeanDefinition) && mergedBd.getAutowireMode() == 0 && mergedBd.getFactoryBeanName() == null && mergedBd.getFactoryMethodName() == null) {
            int numArguments = mergedBd.getConstructorArgumentValues() == null ? 0 : mergedBd.getConstructorArgumentValues().getArgumentCount();
            try {
                if (!Introspector.hasConstructor((IType)type, (int)numArguments, (boolean)true)) {
                    ISourceModelElement element = BeansModelUtils.getFirstConstructorArgument(bean);
                    if (element == null) {
                        element = bean;
                    }
                    AnnotationMetadata metadata = this.getAnnotationMetadata(context.getClassReaderFactory(), bean, type);
                    if (!(bd.isPrototype() && metadata.hasConfigurableAnnotation() || metadata.isConstructorAutowired() && context.isBeanRegistered("org.springframework.context.annotation.internalAutowiredAnnotationProcessor", AutowiredAnnotationBeanPostProcessor.class.getName()))) {
                        String className = type.getFullyQualifiedName();
                        context.error((IResourceModelElement)bean, "NO_CONSTRUCTOR", "No constructor with " + numArguments + (numArguments == 1 ? " argument" : " arguments") + " defined in class '" + className + "'", new ValidationProblemAttribute[]{new ValidationProblemAttribute("CLASS", (Object)className)});
                    }
                } else if (numArguments > 0) {
                    Set ctors = Introspector.getConstructors((IType)type, (int)numArguments, (boolean)true);
                    for (IBeanConstructorArgument argument : bean.getConstructorArguments()) {
                        String name = argument.getName();
                        if (name == null) continue;
                        boolean found = false;
                        for (IMethod ctor : ctors) {
                            List<String> parameterNames = Arrays.asList(ctor.getParameterNames());
                            if (!parameterNames.contains(name)) continue;
                            found = true;
                        }
                        if (found) continue;
                        context.warning((IResourceModelElement)argument, "MISSING_CONSTRUCTOR_ARG_NAME", String.format("Cannot find constructor parameter with name '%s'", name), new ValidationProblemAttribute[]{new ValidationProblemAttribute("CLASS", (Object)type.getFullyQualifiedName()), new ValidationProblemAttribute("NUM_CONSTRUCTOR_ARGS", (Object)numArguments)});
                    }
                }
            }
            catch (JavaModelException e) {
                BeansCorePlugin.log(e);
            }
        }
    }

    private AnnotationMetadata getAnnotationMetadata(ClassReaderFactory classReaderFactory, IBean bean, IType type) {
        String className = type.getFullyQualifiedName();
        AnnotationMetadata visitor = new AnnotationMetadata();
        try {
            ClassReader classReader = classReaderFactory.getClassReader(className);
            classReader.accept((ClassVisitor)visitor, 0);
        }
        catch (IOException iOException) {}
        return visitor;
    }

    private static class AnnotationMetadata
    extends AnnotationMetadataReadingVisitor {
        private static final String CONSTRUCTOR_NAME = "<init>";
        private static final String AUTOWIRED_NAME = Type.getDescriptor(Autowired.class);
        private static final String INJECT_NAME = "Ljavax/inject/Inject;";
        private boolean isConstructorAutowired = false;

        private AnnotationMetadata() {
        }

        public MethodVisitor visitMethod(int modifier, String name, String params, String arg3, String[] arg4) {
            if (CONSTRUCTOR_NAME.equals(name)) {
                return new EmptyMethodVisitor(){

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        if (AUTOWIRED_NAME.equals(desc)) {
                            AnnotationMetadata.this.isConstructorAutowired = true;
                        } else if (AnnotationMetadata.INJECT_NAME.equals(desc)) {
                            AnnotationMetadata.this.isConstructorAutowired = true;
                        }
                        return new EmptyAnnotationVisitor();
                    }
                };
            }
            return new EmptyMethodVisitor();
        }

        public boolean isConstructorAutowired() {
            return this.isConstructorAutowired;
        }

        public boolean hasConfigurableAnnotation() {
            return super.hasAnnotation(Configurable.class.getName());
        }
    }
}

