/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.resources.IBeansResourceChangeEvents;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.locate.BeansConfigLocatorDefinition;
import org.springframework.ide.eclipse.beans.core.model.locate.BeansConfigLocatorFactory;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.internal.model.resources.ISpringResourceChangeEvents;
import org.springframework.ide.eclipse.core.internal.model.resources.SpringResourceChangeListener;

public class BeansResourceChangeListener
extends SpringResourceChangeListener {
    private IBeansResourceChangeEvents events;

    public BeansResourceChangeListener(IBeansResourceChangeEvents events) {
        super((ISpringResourceChangeEvents)events);
        this.events = events;
    }

    protected IResourceDeltaVisitor getVisitor(int eventType) {
        return new BeansResourceVisitor(eventType);
    }

    public static boolean requiresRefresh(IFile file) {
        for (BeansConfigLocatorDefinition locator : BeansConfigLocatorFactory.getBeansConfigLocatorDefinitions()) {
            try {
                if (!locator.isEnabled(file.getProject()) || !locator.getBeansConfigLocator().supports(file.getProject()) || !locator.getBeansConfigLocator().requiresRefresh(file)) continue;
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    protected class BeansResourceVisitor
    extends SpringResourceChangeListener.SpringResourceVisitor {
        public BeansResourceVisitor(int eventType) {
            super((SpringResourceChangeListener)BeansResourceChangeListener.this, eventType);
        }

        protected boolean resourceAdded(IResource resource) {
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (this.isProjectDescriptionFile((IResource)file)) {
                    if (SpringCoreUtils.isSpringProject((IResource)file)) {
                        BeansResourceChangeListener.this.events.projectDescriptionChanged(file, this.eventType);
                    }
                } else if (this.isAutoDetectedConfig(file)) {
                    BeansResourceChangeListener.this.events.configAdded(file, this.eventType, IBeansConfig.Type.AUTO_DETECTED);
                } else if (BeansCoreUtils.isBeansConfig((IResource)file)) {
                    BeansResourceChangeListener.this.events.configAdded(file, this.eventType);
                }
                return false;
            }
            return super.resourceAdded(resource);
        }

        protected boolean resourceChanged(IResource resource, int flags) {
            if (resource instanceof IFile) {
                if ((flags & 0x100) != 0) {
                    IFile file = (IFile)resource;
                    if (this.isProjectDescriptionFile((IResource)file)) {
                        if (SpringCoreUtils.isSpringProject((IResource)file)) {
                            BeansResourceChangeListener.this.events.projectDescriptionChanged(file, this.eventType);
                        }
                    } else if (this.isAutoDetectedConfig(file)) {
                        BeansResourceChangeListener.this.events.configAdded(file, this.eventType, IBeansConfig.Type.AUTO_DETECTED);
                    } else if (BeansCoreUtils.isBeansConfig((IResource)file, true)) {
                        BeansResourceChangeListener.this.events.configChanged(file, this.eventType);
                    } else if (BeansResourceChangeListener.requiresRefresh(file)) {
                        BeansResourceChangeListener.this.events.listenedFileChanged(file, this.eventType);
                    }
                }
                return false;
            }
            return super.resourceChanged(resource, flags);
        }

        protected boolean resourceRemoved(IResource resource) {
            if (resource instanceof IFile) {
                if (BeansCoreUtils.isBeansConfig(resource)) {
                    BeansResourceChangeListener.this.events.configRemoved((IFile)resource, this.eventType);
                } else if (BeansResourceChangeListener.requiresRefresh((IFile)resource)) {
                    BeansResourceChangeListener.this.events.listenedFileChanged((IFile)resource, this.eventType);
                }
                return false;
            }
            return super.resourceRemoved(resource);
        }

        private boolean isProjectDescriptionFile(IResource resource) {
            return resource != null && resource.isAccessible() && resource.getType() == 1 && (resource.getFullPath().segmentCount() == 2 && resource.getName().equals(".springBeans") || SpringCoreUtils.isManifest((IResource)resource));
        }

        private boolean isAutoDetectedConfig(IFile file) {
            for (BeansConfigLocatorDefinition locator : BeansConfigLocatorFactory.getBeansConfigLocatorDefinitions()) {
                try {
                    if (!locator.isEnabled(file.getProject()) || !locator.getBeansConfigLocator().supports(file.getProject()) || !locator.getBeansConfigLocator().isBeansConfig(file)) continue;
                    return true;
                }
                catch (Exception exception) {}
            }
            return false;
        }
    }
}

