/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansModelElement;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansMapEntry;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansMapEntry;
import org.springframework.ide.eclipse.beans.core.model.IBeansProperties;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansProperties
extends AbstractBeansModelElement
implements IBeansProperties {
    private Properties properties = new Properties();
    private LinkedList<IBeansMapEntry> entries = new LinkedList();

    public BeansProperties(IModelElement parent, ManagedProperties properties) {
        super(parent, "(properties)", (BeanMetadataElement)properties);
        for (Object entry : properties.entrySet()) {
            Map.Entry mEntry = (Map.Entry)entry;
            this.properties.put(mEntry.getKey(), mEntry.getValue());
            BeansMapEntry bmEntry = new BeansMapEntry(this, mEntry);
            bmEntry.setKey(BeansModelUtils.resolveValueIfNecessary(bmEntry, mEntry.getKey()));
            bmEntry.setValue(BeansModelUtils.resolveValueIfNecessary(bmEntry, mEntry.getValue()));
            this.entries.add(bmEntry);
        }
    }

    public int getElementType() {
        return 16;
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IBeansMapEntry> children = new ArrayList<IBeansMapEntry>();
        for (IBeansMapEntry entry : this.entries) {
            children.add(entry);
        }
        return children.toArray(new IModelElement[children.size()]);
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (Object e : this.entries) {
                if (!(e instanceof IModelElement)) continue;
                ((IModelElement)e).accept(visitor, monitor);
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
    }

    @Override
    public Map<?, ?> getMap() {
        return this.properties;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeansProperties)) {
            return false;
        }
        BeansProperties that = (BeansProperties)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.properties, (Object)that.properties)) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.properties);
        return this.getElementType() * hashCode + super.hashCode();
    }

    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        text.append(": properties=");
        text.append(this.properties);
        return text.toString();
    }
}

