/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.Set;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;

public class BeansModelPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IFile && "isBeansConfig".equals(property)) {
            boolean isBeansConfig = BeansCoreUtils.isBeansConfig((IResource)((IFile)receiver), true);
            return expectedValue == null ? isBeansConfig : isBeansConfig == (Boolean)expectedValue;
        }
        if (receiver instanceof IBean && "isInfrstructureBean".equals(property)) {
            boolean isInfrstructureBean = ((IBean)receiver).isInfrastructure();
            return expectedValue == null ? isInfrstructureBean : isInfrstructureBean == (Boolean)expectedValue;
        }
        if (receiver instanceof IBeansConfig && "canAddToConfigSet".equals(property)) {
            IBeansConfig config = (IBeansConfig)receiver;
            boolean canAddToConfigSet = this.hasAvailableConfigSet(config);
            return expectedValue == null ? canAddToConfigSet : canAddToConfigSet == (Boolean)expectedValue;
        }
        if (receiver instanceof IBeansConfigSet && "isEmptyConfigSet".equals(property)) {
            IBeansConfigSet configSet = (IBeansConfigSet)receiver;
            boolean isEmpty = configSet.getConfigs().isEmpty();
            return expectedValue == null ? isEmpty : isEmpty == (Boolean)expectedValue;
        }
        return false;
    }

    private boolean hasAvailableConfigSet(IBeansConfig config) {
        IBeansProject project = BeansModelUtils.getProject(config);
        Set<IBeansConfigSet> configSets = project.getConfigSets();
        for (IBeansConfigSet configSet : configSets) {
            if (configSet.hasConfig(config.getElementName())) continue;
            return true;
        }
        return false;
    }
}

