/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansModelElement;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansMapEntry;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansMap;
import org.springframework.ide.eclipse.beans.core.model.IBeansMapEntry;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansMap
extends AbstractBeansModelElement
implements IBeansMap {
    private LinkedHashMap<Object, Object> map = new LinkedHashMap();
    private LinkedList<IBeansMapEntry> entries = new LinkedList();

    public BeansMap(IModelElement parent, ManagedMap<?, ?> map) {
        super(parent, "(map)", (BeanMetadataElement)map);
        for (Object entry : map.entrySet()) {
            Map.Entry mEntry = (Map.Entry)entry;
            this.map.put(mEntry.getKey(), mEntry.getValue());
            BeansMapEntry bmEntry = new BeansMapEntry(this, mEntry);
            bmEntry.setKey(BeansModelUtils.resolveValueIfNecessary(bmEntry, mEntry.getKey()));
            bmEntry.setValue(BeansModelUtils.resolveValueIfNecessary(bmEntry, mEntry.getValue()));
            this.entries.add(bmEntry);
        }
    }

    public int getElementType() {
        return 14;
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IBeansMapEntry> children = new ArrayList<IBeansMapEntry>();
        for (IBeansMapEntry entry : this.entries) {
            children.add(entry);
        }
        return children.toArray(new IModelElement[children.size()]);
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (Object e : this.entries) {
                if (!(e instanceof IModelElement)) continue;
                ((IModelElement)e).accept(visitor, monitor);
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeansMap)) {
            return false;
        }
        BeansMap that = (BeansMap)other;
        if (!ObjectUtils.nullSafeEquals(this.map, that.map)) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode(this.map);
        return this.getElementType() * hashCode + super.hashCode();
    }

    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        text.append(": map=");
        text.append(this.map);
        return text.toString();
    }
}

