/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansValueHolder;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanMethodOverride;
import org.springframework.util.ObjectUtils;

public abstract class AbstractBeanMethodOverride
extends AbstractBeansValueHolder
implements IBeanMethodOverride {
    private final String methodName;
    private final String beanName;
    private final MethodOverride methodOverride;

    public AbstractBeanMethodOverride(IBean bean, String beanName, MethodOverride methodOverride) {
        super(bean, AbstractBeanMethodOverride.createName(methodOverride), new RuntimeBeanReference(beanName), (BeanMetadataElement)methodOverride);
        this.methodName = methodOverride.getMethodName();
        this.beanName = beanName;
        this.methodOverride = methodOverride;
    }

    public int getElementType() {
        return 18;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractBeanMethodOverride)) {
            return false;
        }
        AbstractBeanMethodOverride that = (AbstractBeanMethodOverride)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.methodName, (Object)that.methodName)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.getBeanName(), (Object)that.getBeanName())) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.methodName);
        hashCode = this.getElementType() * hashCode + ObjectUtils.nullSafeHashCode((Object)this.getBeanName());
        return this.getElementType() * hashCode + super.hashCode();
    }

    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        text.append(", methodName=");
        text.append(this.methodName);
        text.append(", bean=");
        text.append(this.getBeanName());
        return text.toString();
    }

    protected static final String createName(MethodOverride methodOverride) {
        StringBuffer buf = new StringBuffer();
        if (methodOverride.getMethodName() != null) {
            buf.append(methodOverride.getMethodName());
        }
        return buf.toString();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public MethodOverride getMethodOverride() {
        return this.methodOverride;
    }
}

