/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.autowire.internal.model;

import java.beans.Introspector;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.ide.eclipse.beans.core.autowire.AutowireBeanReference;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.AutowireDependencyProvider;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanProperty;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConnection;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeanReference;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.ui.graph.model.Bean;
import org.springframework.ide.eclipse.beans.ui.graph.model.IGraphContentExtender;
import org.springframework.ide.eclipse.beans.ui.graph.model.Reference;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutowireGraphContentExtender
implements IGraphContentExtender {
    public void addAdditionalBeans(Map<String, Bean> beans, List<Reference> beansReferences, IBeansModelElement root, IBeansModelElement context) {
        AutowireDependencyProvider provider = new AutowireDependencyProvider(root, context);
        Map autowiredReferences = provider.resolveAutowiredDependencies();
        for (Map.Entry entry : autowiredReferences.entrySet()) {
            Bean bean = beans.get(((IBean)entry.getKey()).getElementName());
            if (bean == null) continue;
            HashSet<String> autowiredProperties = new HashSet<String>();
            Set refs = (Set)entry.getValue();
            for (IBeanReference ref : refs) {
                Bean targetBean = beans.get(ref.getBeanName());
                if (targetBean == null) continue;
                beansReferences.add(new Reference(BeansConnection.BeanType.STANDARD, bean, targetBean, null, !bean.isRootBean(), (IResourceModelElement)ref));
                try {
                    BeanProperty newProperty;
                    String propertyName;
                    IJavaElement source = ((AutowireBeanReference)ref).getSource();
                    if (source instanceof IField) {
                        propertyName = source.getElementName();
                        if (autowiredProperties.contains(propertyName)) continue;
                        newProperty = new BeanProperty((IBean)entry.getKey(), new PropertyValue(propertyName, (Object)new RuntimeBeanReference(ref.getBeanName())));
                        bean.addBeanProperty((IBeanProperty)newProperty);
                        autowiredProperties.add(propertyName);
                        continue;
                    }
                    if (source instanceof IMethod && ((IMethod)source).isConstructor()) {
                        BeanConstructorArgument newConstructorArg = new BeanConstructorArgument((IBean)entry.getKey(), ((AutowireBeanReference)ref).getParameterIndex(), new ConstructorArgumentValues.ValueHolder((Object)new RuntimeBeanReference(ref.getBeanName())));
                        bean.addBeanConstructorArgument((IBeanConstructorArgument)newConstructorArg);
                        continue;
                    }
                    if (!(source instanceof IMethod) || ((IMethod)source).isConstructor()) continue;
                    propertyName = source.getElementName();
                    if (propertyName.startsWith("set")) {
                        propertyName = Introspector.decapitalize(propertyName.substring(3));
                    }
                    if (autowiredProperties.contains(propertyName)) continue;
                    newProperty = new BeanProperty((IBean)entry.getKey(), new PropertyValue(propertyName, (Object)new RuntimeBeanReference(ref.getBeanName())));
                    bean.addBeanProperty((IBeanProperty)newProperty);
                    autowiredProperties.add(propertyName);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }
}

