/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.navigator.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.aop.core.Activator;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.util.AopReferenceModelUtils;
import org.springframework.ide.eclipse.aop.ui.navigator.model.BeanClassReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.BeanClassTargetReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IRevealableReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.InnerBeansReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.ModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanReferenceNode
implements IReferenceNode,
IRevealableReferenceNode {
    private String beanId;
    private boolean showChildren = true;
    private List<IAopReference> aspectReferences = new ArrayList<IAopReference>();
    private List<IAopReference> adviseReferences = new ArrayList<IAopReference>();
    private List<IAopReference> declareParentReferences = new ArrayList<IAopReference>();
    private List<IAopReference> declaredOnReferences = new ArrayList<IAopReference>();
    private List<IReferenceNode> innerBeanNodes = new ArrayList<IReferenceNode>();

    public BeanReferenceNode(String beanId, boolean showChildren) {
        this.beanId = beanId;
        this.showChildren = showChildren;
        IBean bean = AopReferenceModelUtils.getBeanFromElementId((String)beanId);
        IType type = BeansModelUtils.getBeanType((IBean)bean, null);
        if (type != null) {
            List references = Activator.getModel().getAllReferences();
            Set innerBeans = BeansModelUtils.getInnerBeans((IModelElement)bean);
            HashMap<String, BeanReferenceNode> refs = new HashMap<String, BeanReferenceNode>();
            for (IBean iBean : innerBeans) {
                BeanReferenceNode n = new BeanReferenceNode(iBean.getElementID(), true);
                refs.put(iBean.getElementID(), n);
                for (IAopReference r : references) {
                    if (!iBean.getElementID().equals(r.getTargetBeanId())) continue;
                    ((BeanReferenceNode)refs.get(r.getTargetBeanId())).getAdviseReferences().add(r);
                }
            }
            for (Map.Entry entry : refs.entrySet()) {
                this.innerBeanNodes.add((IReferenceNode)entry.getValue());
            }
        }
    }

    public BeanReferenceNode(String bean) {
        this(bean, true);
    }

    @Override
    public int getLineNumber() {
        IBean bean = AopReferenceModelUtils.getBeanFromElementId((String)this.beanId);
        if (bean != null) {
            return bean.getElementStartLine();
        }
        return -1;
    }

    @Override
    public IResource getResource() {
        IBean bean = AopReferenceModelUtils.getBeanFromElementId((String)this.beanId);
        if (bean != null) {
            return bean.getElementResource();
        }
        return null;
    }

    @Override
    public void openAndReveal() {
        IBean bean = AopReferenceModelUtils.getBeanFromElementId((String)this.beanId);
        if (bean != null) {
            BeansUIUtils.openInEditor((IResourceModelElement)bean);
        }
    }

    @Override
    public IReferenceNode[] getChildren() {
        IBean bean = AopReferenceModelUtils.getBeanFromElementId((String)this.beanId);
        if (bean != null && BeansModelUtils.getBeanClass((IBean)bean, null) != null && this.showChildren) {
            ArrayList<IReferenceNode> children = new ArrayList<IReferenceNode>();
            children.add(new BeanClassReferenceNode(new BeanClassTargetReferenceNode((IMember)BeansModelUtils.getBeanType((IBean)bean, null), this)));
            if (this.innerBeanNodes.size() > 0) {
                children.add(new InnerBeansReferenceNode(this.innerBeanNodes));
            }
            return children.toArray(new IReferenceNode[children.size()]);
        }
        return new IReferenceNode[0];
    }

    @Override
    public Image getImage() {
        IBean bean = this.getBean();
        if (bean != null) {
            return BeansUIPlugin.getLabelProvider().getImage((Object)bean);
        }
        return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.error_obj.gif");
    }

    @Override
    public String getText() {
        IBean bean = this.getBean();
        if (bean != null) {
            return String.valueOf(BeansUIPlugin.getLabelProvider().getText((Object)bean)) + " - " + ModelUtils.getFilePath(bean.getElementResource());
        }
        return "<bean cannot be found>";
    }

    @Override
    public boolean hasChildren() {
        return this.getChildren() != null && this.getChildren().length > 0;
    }

    public IBean getBean() {
        return AopReferenceModelUtils.getBeanFromElementId((String)this.beanId);
    }

    public List<IAopReference> getAdviseReferences() {
        return this.adviseReferences;
    }

    public List<IAopReference> getAspectReferences() {
        return this.aspectReferences;
    }

    public List<IAopReference> getDeclaredOnReferences() {
        return this.declaredOnReferences;
    }

    public List<IAopReference> getDeclareParentReferences() {
        return this.declareParentReferences;
    }

    @Override
    public Object getReferenceParticipant() {
        return this.getBean();
    }
}

