/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.springframework.ide.eclipse.aop.core.Activator;
import org.springframework.ide.eclipse.aop.core.model.IAopModelChangedListener;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IAspectDefinition;
import org.springframework.ide.eclipse.aop.core.util.AopReferenceModelUtils;
import org.springframework.ide.eclipse.aop.ui.navigator.AopReferenceModelNavigator;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdviceDeclareParentAopSourceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.BeanReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.ClassMethodReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.JavaElementReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.MethodBeanReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.MethodReference;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.model.IModelChangeListener;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;
import org.springframework.ide.eclipse.core.model.xml.XmlSourceLocation;
import org.springframework.ide.eclipse.ui.SpringUIUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AopReferenceModelNavigatorContentProvider
implements ICommonContentProvider,
IAopModelChangedListener,
IModelChangeListener {
    private StructuredViewer viewer;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer instanceof StructuredViewer ? (StructuredViewer)viewer : null;
    }

    public void dispose() {
        if (this.viewer != null && this.viewer.getInput() != null) {
            this.viewer = null;
        }
        Activator.getModel().unregisterAopModelChangedListener((IAopModelChangedListener)this);
        BeansCorePlugin.getModel().removeChangeListener((IModelChangeListener)this);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IType) {
            return this.getChildren(inputElement);
        }
        if (inputElement instanceof IMethod) {
            return this.getChildren(inputElement);
        }
        if (inputElement instanceof IField) {
            return this.getChildren(inputElement);
        }
        if (inputElement instanceof JavaElementReferenceNode) {
            return this.getChildren(((JavaElementReferenceNode)inputElement).getJavaElement());
        }
        if (inputElement instanceof ElementImpl) {
            return this.getChildren(inputElement);
        }
        return IModelElement.NO_CHILDREN;
    }

    /*
     * WARNING - void declaration
     */
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IReferenceNode) {
            return ((IReferenceNode)parentElement).getChildren();
        }
        if (parentElement instanceof JavaElementReferenceNode && ((JavaElementReferenceNode)parentElement).isRoot()) {
            return this.getChildren(((JavaElementReferenceNode)parentElement).getJavaElement());
        }
        if (parentElement instanceof IType) {
            IType type = (IType)parentElement;
            ArrayList<Object> me = new ArrayList<Object>();
            try {
                Set methods = Introspector.getAllMethods((IType)type);
                for (IMethod method : methods) {
                    if (!Activator.getModel().isAdvice((IJavaElement)method) && !Activator.getModel().isAdvised((IJavaElement)method)) continue;
                    me.addAll(Arrays.asList(this.getChildren(method)));
                }
            }
            catch (JavaModelException javaModelException) {}
            ClassMethodReferenceNode node = new ClassMethodReferenceNode((IMember)type, me);
            List references = Activator.getModel().getAllReferences();
            try {
                void var7_37;
                IField[] iFieldArray = type.getFields();
                int n = iFieldArray.length;
                boolean bl = false;
                while (var7_37 < n) {
                    IField field = iFieldArray[var7_37];
                    Object[] obj = this.getChildren(field);
                    if (obj != null && obj.length > 0) {
                        Object[] objectArray = obj;
                        int n2 = obj.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            Object o = objectArray[n3];
                            node.getDeclareParentReferences().add((IReferenceNode)o);
                            ++n3;
                        }
                    }
                    ++var7_37;
                }
            }
            catch (JavaModelException javaModelException) {}
            for (IAopReference reference : references) {
                if (reference.getAdviceType() != IAopReference.ADVICE_TYPE.DECLARE_PARENTS || !reference.getTarget().equals(type)) continue;
                node.getDeclaredOnReferences().add(reference);
            }
            Set configs = BeansCorePlugin.getModel().getConfigs(type.getFullyQualifiedName());
            HashSet<String> hashSet = new HashSet<String>();
            for (IBeansConfig iBeansConfig : configs) {
                ArrayList pBeans = new ArrayList();
                pBeans.addAll(iBeansConfig.getBeans());
                pBeans.addAll(BeansModelUtils.getInnerBeans((IModelElement)iBeansConfig));
                for (IBean b : pBeans) {
                    if (!type.getFullyQualifiedName().equals(BeansModelUtils.getBeanClass((IBean)b, (IModelElement)iBeansConfig))) continue;
                    hashSet.add(b.getElementID());
                }
            }
            node.setBeans(hashSet);
            return new Object[]{node};
        }
        if (parentElement instanceof IMethod) {
            MethodReference r;
            IMethod method = (IMethod)parentElement;
            List references = Activator.getModel().getAllReferences();
            ArrayList<IAopReference> foundSourceReferences = new ArrayList<IAopReference>();
            ArrayList<IAopReference> foundTargetReferences = new ArrayList<IAopReference>();
            for (IAopReference reference : references) {
                if (reference.getTarget().equals(method)) {
                    foundTargetReferences.add(reference);
                }
                if (reference.getSource() == null || !reference.getSource().equals(method)) continue;
                foundSourceReferences.add(reference);
            }
            ArrayList<MethodBeanReferenceNode> nodes = new ArrayList<MethodBeanReferenceNode>();
            HashMap<IMember, MethodReference> hashMap = new HashMap<IMember, MethodReference>();
            for (IAopReference iAopReference : foundSourceReferences) {
                if (hashMap.containsKey(iAopReference.getSource())) {
                    ((MethodReference)hashMap.get(iAopReference.getSource())).getAspects().add(iAopReference);
                    continue;
                }
                r = new MethodReference();
                r.setMember(iAopReference.getSource());
                r.getAspects().add(iAopReference);
                hashMap.put(iAopReference.getSource(), r);
            }
            for (IAopReference iAopReference : foundTargetReferences) {
                if (hashMap.containsKey(iAopReference.getTarget())) {
                    ((MethodReference)hashMap.get(iAopReference.getTarget())).getAdvices().add(iAopReference);
                    continue;
                }
                r = new MethodReference();
                r.setMember(iAopReference.getTarget());
                r.getAdvices().add(iAopReference);
                hashMap.put(iAopReference.getTarget(), r);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                nodes.add(new MethodBeanReferenceNode((IMember)entry.getKey(), ((MethodReference)entry.getValue()).getAspects(), ((MethodReference)entry.getValue()).getAdvices()));
            }
            return nodes.toArray();
        }
        if (parentElement instanceof IField && parentElement instanceof SourceField) {
            IField method = (IField)parentElement;
            List references = Activator.getModel().getAllReferences();
            ArrayList<IAopReference> foundSourceReferences = new ArrayList<IAopReference>();
            for (IAopReference reference : references) {
                if (reference.getSource() == null || !reference.getSource().equals(method)) continue;
                foundSourceReferences.add(reference);
            }
            ArrayList<AdviceDeclareParentAopSourceNode> nodes = new ArrayList<AdviceDeclareParentAopSourceNode>();
            HashMap refs = new HashMap();
            for (IAopReference iAopReference : foundSourceReferences) {
                if (refs.containsKey(iAopReference.getSource())) {
                    ((List)refs.get(iAopReference.getSource())).add(iAopReference);
                    continue;
                }
                ArrayList<IAopReference> f = new ArrayList<IAopReference>();
                f.add(iAopReference);
                refs.put(iAopReference.getSource(), f);
            }
            for (Map.Entry entry : refs.entrySet()) {
                nodes.add(new AdviceDeclareParentAopSourceNode((List)entry.getValue()));
            }
            return nodes.toArray();
        }
        if (parentElement instanceof ElementImpl) {
            ElementImpl element = (ElementImpl)parentElement;
            IStructuredDocument document = element.getStructuredDocument();
            ArrayList<IReferenceNode> nodes = new ArrayList<IReferenceNode>();
            IFile resource = SpringUIUtils.getFile((IStructuredDocument)document);
            if (!BeansCoreUtils.isBeansConfig((IResource)resource, (boolean)true) || document == null) {
                return nodes.toArray();
            }
            IBeansConfig beansConfig = BeansCorePlugin.getModel().getConfig(resource, true);
            int n = document.getLineOfOffset(element.getStartOffset()) + 1;
            int n4 = document.getLineOfOffset(element.getEndOffset()) + 1;
            String id = BeansEditorUtils.getAttribute((Node)element, (String)"id");
            nodes.addAll(this.getChildrenFromXmlLocation((IResource)resource, n, n4, id, BeansModelUtils.getBeans((IModelElement)beansConfig)));
            return nodes.toArray();
        }
        return IModelElement.NO_CHILDREN;
    }

    private List<IReferenceNode> getChildrenFromXmlLocation(IResource resource, int startLine, int endLine, String id, Set<IBean> beans) {
        ArrayList<IReferenceNode> nodes = new ArrayList<IReferenceNode>();
        List references = Activator.getModel().getAllReferencesForResource(resource);
        HashMap foundSourceReferences = new HashMap();
        HashMap foundIntroductionSourceReferences = new HashMap();
        HashMap foundTargetReferences = new HashMap();
        HashMap foundIntroductionTargetReferences = new HashMap();
        for (IAopReference reference : references) {
            ArrayList<IAopReference> tmp;
            IBean targetBean;
            if (reference.getDefinition().getAspectName().equals(id) || reference.getDefinition().getAspectStartLineNumber() >= startLine && reference.getDefinition().getAspectStartLineNumber() <= endLine && resource.equals((Object)reference.getDefinition().getResource())) {
                if (reference.getAdviceType() == IAopReference.ADVICE_TYPE.DECLARE_PARENTS) {
                    if (foundIntroductionSourceReferences.containsKey(reference.getDefinition())) {
                        ((List)foundIntroductionSourceReferences.get(reference.getDefinition())).add(reference);
                    } else {
                        ArrayList<IAopReference> tmp2 = new ArrayList<IAopReference>();
                        tmp2.add(reference);
                        foundIntroductionSourceReferences.put(reference.getDefinition(), tmp2);
                    }
                } else if (foundSourceReferences.containsKey(reference.getDefinition())) {
                    ((List)foundSourceReferences.get(reference.getDefinition())).add(reference);
                } else {
                    ArrayList<IAopReference> tmp2 = new ArrayList<IAopReference>();
                    tmp2.add(reference);
                    foundSourceReferences.put(reference.getDefinition(), tmp2);
                }
            }
            if ((targetBean = AopReferenceModelUtils.getBeanFromElementId((String)reference.getTargetBeanId())) == null || !reference.getDefinition().getAspectName().equals(id) && (targetBean.getElementStartLine() < startLine || targetBean.getElementEndLine() > endLine || !resource.equals((Object)targetBean.getElementResource()))) continue;
            if (reference.getAdviceType() == IAopReference.ADVICE_TYPE.DECLARE_PARENTS) {
                if (foundIntroductionTargetReferences.containsKey(targetBean)) {
                    ((List)foundIntroductionTargetReferences.get(targetBean)).add(reference);
                    continue;
                }
                tmp = new ArrayList<IAopReference>();
                tmp.add(reference);
                foundIntroductionTargetReferences.put(targetBean, tmp);
                continue;
            }
            if (foundTargetReferences.containsKey(targetBean)) {
                ((List)foundTargetReferences.get(targetBean)).add(reference);
                continue;
            }
            tmp = new ArrayList();
            tmp.add(reference);
            foundTargetReferences.put(targetBean, tmp);
        }
        HashMap<IBean, BeanReferenceNode> beansRefs = new HashMap<IBean, BeanReferenceNode>();
        for (IBean iBean : beans) {
            if (iBean.getElementStartLine() < startLine || iBean.getElementEndLine() > endLine || BeansCorePlugin.getModel().getElement(iBean.getElementID()) == null) continue;
            if (iBean.getElementSourceLocation() instanceof XmlSourceLocation) {
                String namespace = ((XmlSourceLocation)iBean.getElementSourceLocation()).getNamespaceURI();
                if (namespace.equals("http://www.springframework.org/schema/aop")) continue;
                BeanReferenceNode rn = new BeanReferenceNode(iBean.getElementID());
                nodes.add(rn);
                beansRefs.put(iBean, rn);
                continue;
            }
            BeanReferenceNode rn = new BeanReferenceNode(iBean.getElementID());
            nodes.add(rn);
            beansRefs.put(iBean, rn);
        }
        if (foundTargetReferences.size() > 0) {
            for (Map.Entry entry : foundTargetReferences.entrySet()) {
                if (!beansRefs.containsKey(entry.getKey())) continue;
                ((BeanReferenceNode)beansRefs.get(entry.getKey())).getAdviseReferences().addAll((Collection)entry.getValue());
            }
        }
        if (foundIntroductionTargetReferences.size() > 0) {
            for (Map.Entry entry : foundIntroductionTargetReferences.entrySet()) {
                if (!beansRefs.containsKey(entry.getKey())) continue;
                ((BeanReferenceNode)beansRefs.get(entry.getKey())).getDeclaredOnReferences().addAll((Collection)entry.getValue());
            }
        }
        if (foundSourceReferences.size() > 0) {
            for (Map.Entry entry : foundSourceReferences.entrySet()) {
                for (Map.Entry n : beansRefs.entrySet()) {
                    if (((IBean)n.getKey()).getElementStartLine() != ((IAspectDefinition)entry.getKey()).getAspectStartLineNumber() && !((IAspectDefinition)entry.getKey()).getAspectName().equals(((IBean)n.getKey()).getElementName())) continue;
                    ((BeanReferenceNode)beansRefs.get(n.getKey())).getAspectReferences().addAll((Collection)entry.getValue());
                }
            }
        }
        if (foundIntroductionSourceReferences.size() > 0) {
            for (Map.Entry entry : foundIntroductionSourceReferences.entrySet()) {
                for (Map.Entry n : beansRefs.entrySet()) {
                    if (((IBean)n.getKey()).getElementStartLine() != ((IAspectDefinition)entry.getKey()).getAspectStartLineNumber() && !((IAspectDefinition)entry.getKey()).getAspectName().equals(((IBean)n.getKey()).getElementName())) continue;
                    ((BeanReferenceNode)beansRefs.get(n.getKey())).getDeclareParentReferences().addAll((Collection)entry.getValue());
                }
            }
        }
        return nodes;
    }

    public Object getParent(Object element) {
        IBeansConfig config;
        if (element instanceof IModelElement) {
            return ((IModelElement)element).getElementParent();
        }
        if (element instanceof IFile) {
            IBeansConfig config2 = BeansCorePlugin.getModel().getConfig((IFile)element);
            if (config2 != null) {
                return config2.getElementParent();
            }
        } else if (element instanceof ZipEntryStorage && (config = BeansCorePlugin.getModel().getConfig(((ZipEntryStorage)element).getFullName())) != null) {
            return config.getElementParent();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Object element) {
        if (element instanceof IReferenceNode) {
            return ((IReferenceNode)element).hasChildren();
        }
        if (element instanceof IType) {
            IType type = (IType)element;
            try {
                IMethod[] methods;
                IMethod[] iMethodArray = methods = type.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    IMethod method = iMethodArray[n2];
                    if (Activator.getModel().isAdvised((IJavaElement)method)) return true;
                    if (Activator.getModel().isAdvice((IJavaElement)method)) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        if (!(element instanceof IMethod)) return false;
        IMethod method = (IMethod)element;
        List references = Activator.getModel().getAllReferences();
        for (IAopReference reference : references) {
            if (reference.getTarget().equals(method)) {
                return true;
            }
            if (!reference.getSource().equals(method)) continue;
            return true;
        }
        return false;
    }

    protected void refreshViewer(final Object element) {
        if (this.viewer instanceof TreeViewer) {
            Control ctrl = this.viewer.getControl();
            if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
                AopReferenceModelNavigator.refreshViewer((TreeViewer)this.viewer, AopReferenceModelNavigator.calculateRootElement(element), element);
            } else {
                ctrl.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        Control ctrl = AopReferenceModelNavigatorContentProvider.this.viewer.getControl();
                        if (ctrl == null || ctrl.isDisposed()) {
                            return;
                        }
                        AopReferenceModelNavigator.refreshViewer((TreeViewer)AopReferenceModelNavigatorContentProvider.this.viewer, AopReferenceModelNavigator.calculateRootElement(element), element);
                    }
                });
            }
        }
    }

    public void init(ICommonContentExtensionSite config) {
        Activator.getModel().registerAopModelChangedListener((IAopModelChangedListener)this);
        BeansCorePlugin.getModel().addChangeListener((IModelChangeListener)this);
    }

    public void saveState(IMemento aMemento) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void changed() {
        Object obj = this.viewer.getInput();
        this.refreshViewer(obj);
    }

    public void elementChanged(ModelChangeEvent event) {
        if (event.getType() == ModelChangeEvent.Type.CHANGED && event.getSource() instanceof IBeansProject) {
            this.changed();
        }
    }
}

